package com.digiwin.athena.abt.application.service.abt.migration.inout;

import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.DownloadHistoryProjectTaskParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ExportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.SimpleUser;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.ExportFileMsg;
import com.digiwin.athena.abt.application.service.abt.migration.lock.LockPool;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ExportBatchRecordMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportBatchRecordPO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.UUID;


/**
 * 历史项目/任务
 *
 * @author xuhx
 * @date 2025/5/15
 */
@Slf4j
@Service
public class HistoryProjectTaskServiceImpl {


    @Autowired
    RabbitTemplate rabbitTemplate;

    @Autowired
    ExportStatisticsDomainService exportStatisticsDomainService;

    @Autowired
    private ExportBatchRecordMapper exportBatchRecordMapper;

    @Autowired
    LockPool lockPool;

    /**
     * 发起异步下载 历史项目/任务明细
     *
     * @param paramDTO
     * @return
     */
    public Boolean startDownloadHistoryData(DownloadHistoryProjectTaskParamDTO paramDTO) {
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        ExportStatistics exportStatistics = new ExportStatistics();
        exportStatistics.setMasterId(UUID.randomUUID().toString());
        exportStatistics.setExportParams(JsonUtils.objectToString(paramDTO));
        exportStatistics.setType(ImportAndExportStatisticsConstants.EXPORT_FILE_TYPE_HISTORY_PROJECT_TASK_DATA);
        //由于增加了历史任务项目导出，前端和业务数据导出用的同一个组件  所以后端这里取activityName作为导出的作业名称
        exportStatistics.setActivityName("{\"default\":\"历史项目任务\",\"zh_TW\":\"歷史項目任務\",\"en_US\":\"history project|task\",\"zh_CN\":\"历史项目任务\"}");
        String locale = LocaleContextHolder.getLocale().toString();
        exportStatistics.setFileName(paramDTO.getFileName());
        exportStatistics.setLocale(locale == null ? "zh_CN" : locale);
        exportStatistics.setUserId(String.valueOf(athenaUser.getSid()));
        exportStatistics.setTenantId(athenaUser.getTenantId());
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        exportStatistics.setUserToken(securityToken);
        exportStatistics.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
        Date now = new Date();
        exportStatistics.setCreateTime(now);
        exportStatistics.setUpdateTime(now);
        //冗余用户对象
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        exportStatistics.setUserJson(JsonUtils.objectToString(simpleUser));
        // 设置失效时间为5天后
        exportStatistics.setExpireTime(DateUtils.addDays(now, ImportAndExportStatisticsConstants.EXPORT_FILE_EXPIRE_TIME));
        exportStatistics.setTotalSize(paramDTO.getList().size());
        ExportFileMsg exportFileMsg = new ExportFileMsg();
        exportFileMsg.setMasterId(exportStatistics.getMasterId());
        exportFileMsg.setLocale(exportStatistics.getLocale());
        exportFileMsg.setTenantId(exportStatistics.getTenantId());
        exportFileMsg.setUserToken(exportStatistics.getUserToken());
        exportFileMsg.setDownloadHistoryProjectTaskParamDTO(paramDTO);

        // 1、更新导入记录
        //更新对应masterId处理消息条数
        int insertExportStatistics = exportStatisticsDomainService.insertByMasterId(exportStatistics);

        boolean result = false;
        if (insertExportStatistics == 1) {
            for (int i = 0; i < paramDTO.getList().size(); i++) {
                DownloadHistoryProjectTaskParamDTO.DownloadHistoryProjectTaskSubParamDTO subParamDTO = paramDTO.getList().get(i);
                // 2、构建导入记录子表的数据（ExportBatchRecord）
                ExportBatchRecord exportBatchRecord = new ExportBatchRecord();
                exportBatchRecord.setMasterId(exportStatistics.getMasterId());
                exportBatchRecord.setBatchSeq(i);
                exportBatchRecord.setType(subParamDTO.getType());
                exportBatchRecord.setRelate(subParamDTO.getId().toString());
                exportBatchRecord.setExportParams(JsonUtils.objectToString(subParamDTO));
                exportBatchRecord.setState(ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING);
                exportBatchRecord.setCreateTime(now);
                exportBatchRecord.setUpdateTime(now);
                exportBatchRecord.setCode(subParamDTO.getCode());
                exportBatchRecord.setFileName(subParamDTO.getFileName());
                exportBatchRecord.setProxyToken(subParamDTO.getProxyToken());
                exportBatchRecord.setTenantId(subParamDTO.getTenantId());
                exportBatchRecord.setArchiveRouteKey(paramDTO.getArchiveRouteKey());
                exportBatchRecord.setName(subParamDTO.getName());
                exportFileMsg.setExportBatchRecord(exportBatchRecord);

                // 3、插入 export_batch_record
                ExportBatchRecordPO exportBatchRecordPO = new ExportBatchRecordPO();
                BeanUtils.copyProperties(exportBatchRecord, exportBatchRecordPO);
                int insertExportBatchRecordPO = exportBatchRecordMapper.insert(exportBatchRecordPO);

                // 4、发送MQ异步处理
                if (insertExportBatchRecordPO == 1) {
                    exportBatchRecord.setId(exportBatchRecordPO.getId());
                    result = sendExportFileMQ(exportStatistics, exportFileMsg);
                } else {
                    result = false;
                }
            }
        }
        return result;
    }

    private Boolean sendExportFileMQ(ExportStatistics exportStatistics, ExportFileMsg exportFileMsg) {
        String masterId = exportStatistics.getMasterId();
        Integer batchSeq = exportFileMsg.getExportBatchRecord().getBatchSeq();
        boolean result;
        log.info("startDownloadHistoryData sendExportFileMQ,masterId:{}", masterId);
//        //通过uuid的后n位从锁池获取锁
//        int lockId = LockPoolDataEntryHelper.getIdByUUID(masterId, lockPool.getPoolSize());
//        ReentrantLock lock = lockPool.getLockById(lockId + batchSeq);
//        //避免竞争rabbitmq channel资源,先加锁
//        lock.lock();
        try {
            rabbitTemplate.convertAndSend(DirectRabbitConfig.EXPORT_HISTORY_PROJECT_TASK_DETAIL_EXCHANGE_NAME, DirectRabbitConfig.EXPORT_HISTORY_PROJECT_TASK_DETAIL_ROUTING_KEY, JsonUtils.objectToString(exportFileMsg));
            result = true;
        } catch (Exception e) {
            log.error("startDownloadHistoryData send msg TimeoutException,masterId:" + masterId, e);
            result = false;
        } finally {
//            lock.unlock();
        }
        return result;
    }
}

