package com.digiwin.athena.abt.application.service.abt.migration.inout;

import com.digiwin.athena.abt.application.convert.ImportBatchRecordCovert;
import com.digiwin.athena.abt.application.convert.ImportStatisticsCovert;
import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ActivityStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.UserStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.valueobject.SimpleUser;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.AppPermissionUtil;
import com.digiwin.athena.abt.application.service.abt.migration.helpler.ExcelHelper;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.dto.ImportCounters;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ImportBatchRecordPO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ImportStatisticsPO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName ImportStatisticsService
 * @Description 导入数据领域服务
 * @Author zhuangli
 * @Date 2021/4/6 17:51
 * @Version 1.0
 **/
@Slf4j
@Service
public class ImportStatisticsDomainService {

    @Autowired
    ImportStatisticsRepositoryFacade importStatisticsRepositoryFacade;
    @Autowired
    ImportBatchRecordRepositoryFacade importBatchRecordRepositoryFacade;
    @Autowired
    ImportStatisticsFactory importStatisticsFactory;
    @Autowired
    ExcelHelper excelHelper;
    @Autowired
    private AppPermissionUtil appPermissionUtil;

    public final String SHEET_NAME = "sheet1";
    private final String EXCEL_SUFFIX = ".xlsx";

    public void insertByMasterId(String activityId, String activityName, String actionId, AuthoredUser athenaUser, String masterId, int i, List<ImportBatchRecord> importBatchRecords) {

        ImportStatisticsPO importStatisticsPO = new ImportStatisticsPO();
        importStatisticsPO.setSucceededNum(0);
        importStatisticsPO.setProcessingNum(i);
        importStatisticsPO.setFailedNum(0);
        importStatisticsPO.setErrorNum(0);
        importStatisticsPO.setMasterId(masterId);
        importStatisticsPO.setActivityId(activityId);
        importStatisticsPO.setActivityName(activityName);
        importStatisticsPO.setActionId(actionId);
        if (!StringUtils.isEmpty(MDC.get(GlobalConstant.ROUTER_KEY))) {
            importStatisticsPO.setRouterKey(MDC.get(GlobalConstant.ROUTER_KEY));
        }
        String locale = LocaleContextHolder.getLocale().toString();
        importStatisticsPO.setLocale(locale == null ? "zh_CN" : locale);
        importStatisticsPO.setUserId(String.valueOf(athenaUser.getSid()));
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        importStatisticsPO.setUserToken(securityToken);
        Date now = new Date();
        importStatisticsPO.setCreateTime(now);
        importStatisticsPO.setUpdateTime(now);
        List<ImportBatchRecordPO> importBatchRecordPOS = importStatisticsFactory.getBatchRecordPOS(importBatchRecords);
        //importStatisticsPO.setImportBatchRecords(importBatchRecordPOS);
        //冗余用户对象
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        importStatisticsPO.setUserJson(JsonUtils.objectToString(simpleUser));
        importStatisticsPO.setRepublished(0);
        importStatisticsRepositoryFacade.save(importStatisticsPO);
        importBatchRecordRepositoryFacade.saveBatch(importBatchRecordPOS);
    }

    public void insertByMasterIdNew(UploadParamDTO uploadParam, String activityName, int i, List<ImportBatchRecord> importBatchRecords, Date now) {

        ImportStatisticsPO importStatisticsPO = new ImportStatisticsPO();
        importStatisticsPO.setId(SnowflakeIdWorker.getInstance().newId());
        importStatisticsPO.setSucceededNum(0);
        importStatisticsPO.setProcessingNum(i);
        importStatisticsPO.setFailedNum(0);
        importStatisticsPO.setErrorNum(0);
        importStatisticsPO.setMasterId(uploadParam.getMasterId());
        importStatisticsPO.setActivityId(uploadParam.getActivityId());
        importStatisticsPO.setActivityName(activityName);
        importStatisticsPO.setActionId(uploadParam.getActionId());
        //设置文件url
        importStatisticsPO.setFileUrl(uploadParam.getFileUrl());
        if (!StringUtils.isEmpty(MDC.get(GlobalConstant.ROUTER_KEY))) {
            importStatisticsPO.setRouterKey(MDC.get(GlobalConstant.ROUTER_KEY));
        }
        String locale = LocaleContextHolder.getLocale().toString();
        importStatisticsPO.setLocale(locale == null ? "zh_CN" : locale);
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        //如果上下文中没有用户信息，则使用上传参数中的用户信息
        if (athenaUser == null) {
            athenaUser = uploadParam.getAuthoredUser();
        }
        importStatisticsPO.setUserId(String.valueOf(athenaUser.getSid()));
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        //如果上下文中没有token，则使用上传参数中的token
        if (securityToken == null) {
            securityToken = uploadParam.getSecurityToken();
        }
        importStatisticsPO.setUserToken(securityToken);
//        Date now = new Date();
        importStatisticsPO.setCreateTime(now);
        importStatisticsPO.setUpdateTime(now);
        List<ImportBatchRecordPO> importBatchRecordPOS = importStatisticsFactory.getBatchRecordPOS(importBatchRecords);
        //importStatisticsPO.setImportBatchRecords(importBatchRecordPOS);
        //冗余用户对象
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        importStatisticsPO.setUserJson(JsonUtils.objectToString(simpleUser));
        importStatisticsPO.setRepublished(0);
        if (null != uploadParam.getActionInfo()) {
            importStatisticsPO.setActionInfo(JsonUtils.objectToString(uploadParam.getActionInfo()));
        }
        importStatisticsRepositoryFacade.save(importStatisticsPO);
        importBatchRecordRepositoryFacade.saveBatch(importBatchRecordPOS);
    }

    public ImportStatistics getByMasterId(String masterId) {
        ImportStatisticsPO importStatisticsPO = importStatisticsRepositoryFacade.getByMasterId(masterId);
        return null == importStatisticsPO ? null : importStatisticsFactory.getImportStatistics(importStatisticsPO);
    }

    public void updateById(ImportStatistics importStatistics) {
        if (null == importStatistics) {
            throw new RuntimeException("统计数据为空");
        }
        ImportStatisticsPO importStatisticsPO = importStatisticsFactory.getImportStatisticsPO(importStatistics);
        importStatisticsRepositoryFacade.updateById(importStatisticsPO);
    }

    public void updateThisAndBatchRecordsById(ImportStatistics importStatistics) {
        if (null == importStatistics) {
            throw new RuntimeException("统计数据为空");
        }
        ImportStatisticsPO importStatisticsPO = importStatisticsFactory.getImportStatisticsPO(importStatistics);
        List<ImportBatchRecordPO> importBatchRecordPOS = importStatisticsFactory.getBatchRecordPOS(importStatistics.getImportBatchRecords());
        importStatisticsRepositoryFacade.updateById(importStatisticsPO);
        importBatchRecordRepositoryFacade.updateBatch(importBatchRecordPOS);
    }

    public void setRepublishedFlag(String masterId) {
        ImportStatisticsPO importStatisticsPO = importStatisticsRepositoryFacade.getByMasterId(masterId);
        if (null == importStatisticsPO) {
            throw new RuntimeException("统计数据为空");
        }
        importStatisticsPO.setRepublished(1);
        importStatisticsRepositoryFacade.updateById(importStatisticsPO);
    }

    public List<ImportStatistics> getRecordsByUserId(String userId, String tenantId, String locale, String activityName, String startTime, String endTime, String type, Integer state, Integer offset, Integer getRecordsNum) {
        final String loc_default = "default";
        List<ImportStatisticsPO> importStatisticsPOS = importStatisticsRepositoryFacade.getRecordsByUserId(userId, getRecordsNum, activityName, startTime, endTime, type, state, offset);
        Integer countRecord = importStatisticsRepositoryFacade.countRecord(userId, activityName, startTime, endTime, type, state);
        importStatisticsPOS.forEach(e -> e.setQueryPageTotal(countRecord));
        List<ImportStatistics> importStatisticsList = importStatisticsFactory.getImportStatisticsList(importStatisticsPOS);
        Iterator<ImportStatistics> importStatisticsIterator = importStatisticsList.iterator();
        while (importStatisticsIterator.hasNext()) {
            ImportStatistics item = importStatisticsIterator.next();
            // 防止activityName为null，导致NPE
            if (item.getActivityName() == null) {
                continue;
            }
            String name;
            Map<String, String> localeMap = JsonUtils.jsonToObject(item.getActivityName(), Map.class);
            if (!StringUtils.isEmpty(locale)) {
                name = null == localeMap.get(locale) ? localeMap.get(loc_default) : localeMap.get(locale);
                item.setActivityName(name);
            } else {
                name = localeMap.get(loc_default);
                item.setActivityName(name);
            }

            if (StringUtils.isEmpty(item.getUserJson())) {
                continue;
            }

            Map<String, Object> userJsonMap = JsonUtils.jsonToObject(item.getUserJson(), Map.class);
            if (CollectionUtils.isEmpty(userJsonMap) || StringUtils.isEmpty(String.valueOf(userJsonMap.get("tenantId")))) {
                continue;
            }

            // 只查询当前租户下的导入记录
//            if(!tenantId.equals(String.valueOf(userJsonMap.get("tenantId")))){
//                importStatisticsIterator.remove();
//            }
        }
        return importStatisticsList;
    }

    public UserStatistics getProcessingNum(String userId, String tenantId) {
        UserStatistics userStatistics = new UserStatistics();
        userStatistics.setUserId(userId);

        List<ImportStatisticsPO> importStatisticsPOS = importStatisticsRepositoryFacade.getProcessingRecordsByUserId(userId);
        if (CollectionUtils.isEmpty(importStatisticsPOS)) {
            userStatistics.setProcessingNum(0);
            return userStatistics;
        }

        Iterator<ImportStatisticsPO> importStatisticsIterator = importStatisticsPOS.iterator();
        while (importStatisticsIterator.hasNext()) {
            ImportStatisticsPO item = importStatisticsIterator.next();
            if (StringUtils.isEmpty(item.getUserJson())) {
                continue;
            }

            Map<String, Object> userJsonMap = JsonUtils.jsonToObject(item.getUserJson(), Map.class);
            if (CollectionUtils.isEmpty(userJsonMap) || StringUtils.isEmpty(String.valueOf(userJsonMap.get("tenantId")))) {
                continue;
            }

            // 只查询当前租户下的导入记录
            if (!tenantId.equals(String.valueOf(userJsonMap.get("tenantId")))) {
                importStatisticsIterator.remove();
            }
        }

        // 过滤授权应用
        List<String> activityIds = importStatisticsPOS.stream().map(ImportStatisticsPO::getActivityId).distinct().collect(Collectors.toList());
        List<String> hasPermissionActivityCodeList = appPermissionUtil.handleAppPermission(activityIds);
        importStatisticsPOS = importStatisticsPOS.stream().filter(x ->
                hasPermissionActivityCodeList.contains(x.getActivityId())).collect(Collectors.toList());

        userStatistics.setProcessingNum(importStatisticsPOS.size());
        return userStatistics;
    }

    public ActivityStatistics getActivityStatistics(String activityCode, String userId) {
        List<ImportStatisticsPO> importStatisticsPOS = importStatisticsRepositoryFacade.getActivityStatistics(activityCode, userId);
        List<ImportStatistics> importStatisticsList = new LinkedList<>();
        if (!CollectionUtils.isEmpty(importStatisticsPOS)) {
            importStatisticsPOS.forEach(item -> {
                ImportStatistics importStatistics = new ImportStatistics();
                BeanUtils.copyProperties(item, importStatistics);
                importStatisticsList.add(importStatistics);
            });
        }
        ActivityStatistics activityStatistics = new ActivityStatistics();
        activityStatistics.setImportStatisticsList(importStatisticsList);
        return activityStatistics;
    }

    public ImportBatchRecord getBatchRecordByPIdAndSeq(String masterId, int batchNum) {
        ImportBatchRecordPO importBatchRecordPO = importBatchRecordRepositoryFacade.selectByPIdAndBatchNum(masterId, batchNum);
        if (null == importBatchRecordPO) {
            throw new RuntimeException("统计数据为空");
        }
        ImportBatchRecord importBatchRecord = importStatisticsFactory.getImportBatchRecord(importBatchRecordPO);
        return importBatchRecord;
    }

    public byte[] handleDownloadBaseData(String locale, List<String> keyList, Map<String, String> headers, Map<String, CellTypeContainer> cellTypeContainerMap,
                                         List<Map<String, Object>> tableList, String sheetName) throws UnsupportedEncodingException {
        byte[] fileBytes = new byte[0];
        Workbook wb = new XSSFWorkbook();
        int rowIndex = 2;
        List<CellTypeContainer> businessKeyContainer = excelHelper.getBusinessKeyContainer(new ArrayList<>(cellTypeContainerMap.values()));
        excelHelper.createDataExcel(sheetName, locale, rowIndex, keyList, cellTypeContainerMap, headers, tableList, wb, businessKeyContainer, 0, null, null);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            wb.write(bos);
            fileBytes = bos.toByteArray();
            return fileBytes;
        } catch (Exception e) {
            log.error("导出异常数据写入文件异常", e);
        } finally {
            if (null != wb) {
                try {
                    wb.close();
                } catch (IOException e) {
                    log.error(e.toString());
                }
            }
        }
        return fileBytes;
    }


    private String getSHEET_NAME() {

        //超过29个字符添加省略号...
        return null;
    }

    @Transactional
    public void saveImportStatisticsAndRecord(UploadParamDTO uploadParam, String activityName, int processingNum,
                                              List<ImportBatchRecord> importBatchRecords, Date createTime) {
        if (CollectionUtils.isEmpty(importBatchRecords)) {
            return;
        }
        List<ImportBatchRecordPO> importBatchRecordPOS = ImportBatchRecordCovert.INSTANCE.toPo(importBatchRecords);

        ImportStatisticsPO importStatisticsPO = new ImportStatisticsPO();
        importStatisticsPO.setId(SnowflakeIdWorker.getInstance().newId());
        importStatisticsPO.setSucceededNum(0);
        importStatisticsPO.setProcessingNum(processingNum);
        importStatisticsPO.setFailedNum(0);
        importStatisticsPO.setErrorNum(0);
        importStatisticsPO.setMasterId(uploadParam.getMasterId());
        importStatisticsPO.setActivityId(uploadParam.getActivityId());
        importStatisticsPO.setActivityName(activityName);
        importStatisticsPO.setActionId(uploadParam.getActionId());
        //设置文件url
        importStatisticsPO.setFileUrl(uploadParam.getFileUrl());
        importStatisticsPO.setFileUid(uploadParam.getFileUid());

        String locale = LocaleContextHolder.getLocale().toString();
        importStatisticsPO.setLocale(locale == null ? "zh_CN" : locale);
        AuthoredUser athenaUser = AppAuthContextHolder.getContext().getAuthoredUser();
        //如果上下文中没有用户信息，则使用上传参数中的用户信息
        if (athenaUser == null) {
            athenaUser = uploadParam.getAuthoredUser();
        }
        importStatisticsPO.setRouterKey(athenaUser.getTenantId());

        importStatisticsPO.setUserId(String.valueOf(athenaUser.getSid()));
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        //如果上下文中没有token，则使用上传参数中的token
        if (securityToken == null) {
            securityToken = uploadParam.getSecurityToken();
        }
        importStatisticsPO.setUserToken(securityToken);

        importStatisticsPO.setCreateTime(createTime);
        importStatisticsPO.setUpdateTime(createTime);
        //冗余用户对象
        SimpleUser simpleUser = new SimpleUser();
        simpleUser.setTenantId(athenaUser.getTenantId());
        simpleUser.setTenantSid(athenaUser.getTenantSid());
        simpleUser.setUserId(athenaUser.getUserId());
        simpleUser.setUserSid(athenaUser.getSid());
        importStatisticsPO.setUserJson(JsonUtils.objectToString(simpleUser));
        importStatisticsPO.setRepublished(0);
        if (null != uploadParam.getActionInfo()) {
            importStatisticsPO.setActionInfo(JsonUtils.objectToString(uploadParam.getActionInfo()));
        }
        importStatisticsRepositoryFacade.save(importStatisticsPO);
        importBatchRecordRepositoryFacade.saveBatch(importBatchRecordPOS);
    }

    @Transactional
    public void updateImportStatisticsAndRecord(String masterId, DataEntryTask dataEntryTask) {
        ImportStatistics importStatistics = this.getByMasterId(masterId);
        if (null == importStatistics) {
            throw new RuntimeException("统计数据为空");
        }
        List<DataEntryTask.BatchInfo> batchInfos = dataEntryTask.getBatchInfos();
        Date now = new Date();
        List<ImportBatchRecord> importBatchRecords = new ArrayList<>();
        batchInfos.forEach(item -> {
            ImportBatchRecord importBatchRecord = this.getBatchRecordByPIdAndSeq(masterId, item.getBatchNum());
            importStatistics.setSucceededNum(importStatistics.getSucceededNum() + item.getTotalDataSize() - item.getTotalDataSize());
            importStatistics.setFailedNum(importStatistics.getFailedNum() + item.getTotalDataSize());
            importStatistics.setProcessingNum(importStatistics.getProcessingNum() - item.getTotalDataSize());
            importStatistics.setUpdateTime(now);
            importBatchRecord.setHandleFlag(1);
            importBatchRecord.setUpdateTime(now);
            importBatchRecords.add(importBatchRecord);
        });

        ImportStatisticsPO importStatisticsPO = importStatisticsFactory.getImportStatisticsPO(importStatistics);
        importStatisticsRepositoryFacade.updateById(importStatisticsPO);
        List<ImportBatchRecordPO> batchRecordPOS = importStatisticsFactory.getBatchRecordPOS(importBatchRecords);
        importBatchRecordRepositoryFacade.updateBatch(batchRecordPOS);
    }

    public ImportStatistics queryImportStatisticsByMasterId(String masterId) {
        ImportStatisticsPO po = importStatisticsRepositoryFacade.getByMasterId(masterId);
        ImportStatistics stats = ImportStatisticsCovert.INSTANCE.to(po);

        if (stats == null) {
            log.error("未找到对应数据masterId:{}", masterId);
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0060.getErrCode(), MessageUtil.getMessage("delivery.dataNotFound"));
        }
        return stats;
    }

    public List<ImportBatchRecord> queryImportBatchRecordsByMasterId(String masterId) {
        List<ImportBatchRecordPO> pos = importBatchRecordRepositoryFacade.selectListByPId(masterId);
        List<ImportBatchRecord> records = ImportBatchRecordCovert.INSTANCE.toDto(pos);

        if (CollectionUtils.isEmpty(records)) {
            log.error("未找到对应批次数据masterId:{}", masterId);
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0060.getErrCode(), MessageUtil.getMessage("delivery.dataNotFound"));
        }
        return records;
    }

    public ImportStatistics queryImportStatisticsByFileUid(String fileUid) {
        List<ImportStatisticsPO> po = importStatisticsRepositoryFacade.queryImportStatisticsByFileUid(fileUid);
        if (CollectionUtils.isEmpty(po)) {
            return null;
        }
        return ImportStatisticsCovert.INSTANCE.to(po.get(0));
    }

    @Transactional
    public void updateImportDb(ImportStatistics importStatistics, List<ImportBatchRecord> importBatchRecords, ImportCounters counters) {
        if (null == importStatistics) {
            log.error("当前导入记录为空");
            return;
        }
        Date now = new Date();
        // 更新统计信息
        importStatistics.setFailedUrl(counters.getFailUrl());
        importStatistics.setProcessingNum(counters.getProcessingNum());
        importStatistics.setFailedNum(counters.getFailedNum());
        importStatistics.setErrorNum(counters.getErrorNum());
        importStatistics.setSucceededNum(counters.getSucceededNum());
        importStatistics.setUpdateTime(now);
        importStatisticsRepositoryFacade.updateById(ImportStatisticsCovert.INSTANCE.to(importStatistics));
        if (CollectionUtils.isEmpty(importBatchRecords)) {
            return;
        }
        // 更新批次记录
        for (ImportBatchRecord record : importBatchRecords) {
            record.setHandleFlag(1);
            record.setUpdateTime(now);
        }
        List<Integer> batchSeqs = importBatchRecords.stream().map(ImportBatchRecord::getBatchSeq).collect(Collectors.toList());
        log.info("此次更新状态的批次：{}", batchSeqs);
        importBatchRecordRepositoryFacade.updateBatch(ImportBatchRecordCovert.INSTANCE.toPo(importBatchRecords));
    }
}
