package com.digiwin.athena.abt.application.service.abt.migration.inout;

import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspBody;
import com.digiwin.athena.abt.application.dto.migration.abt.esp.EspResponse;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportBatchRecord;
import com.digiwin.athena.abt.application.dto.migration.abt.inout.ImportStatistics;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ImportBatchRecordPO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ImportStatisticsPO;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.*;

/**
 * @ClassName ImportStatisticsFactory
 * @Description 导入数据工厂类
 * @Author zhuangli
 * @Date 2021/4/7 9:35
 * @Version 1.0
 **/
@Service
public class ImportStatisticsFactory {

    private final List<ImportStatistics> emptyImportStatistics = Collections.emptyList();

    public ImportStatistics getImportStatistics(ImportStatisticsPO importStatisticsPO) {
        if (null == importStatisticsPO) {
            return null;
        }
        ImportStatistics importStatistics = new ImportStatistics();
        BeanUtils.copyProperties(importStatisticsPO, importStatistics);
        return importStatistics;
    }

    public ImportStatisticsPO getImportStatisticsPO(ImportStatistics importStatistics) {
        if (null == importStatistics) {
            return null;
        }
        ImportStatisticsPO importStatisticsPO = new ImportStatisticsPO();
        BeanUtils.copyProperties(importStatistics, importStatisticsPO);
        return importStatisticsPO;
    }

    public List<Map<String, Object>> parseResponse(String tableKey, EspResponse response) {
        //TODO 根据定义结构解析返回结果
        EspBody espBody = (EspBody) response.getData();
        if (null == espBody) {
            return Collections.EMPTY_LIST;
        }
        List<Map<String, Object>> table = (List<Map<String, Object>>) espBody.getStd_data().getParameter().get(tableKey);
        return table;
    }

    public void calBySucceededNum(int succeededNum, ImportStatistics importStatistics, ImportBatchRecord importBatchRecord) {
        Date now = new Date();
        importStatistics.setSucceededNum(importStatistics.getSucceededNum() + succeededNum);
        importStatistics.setProcessingNum(importStatistics.getProcessingNum() - succeededNum);
        importStatistics.setUpdateTime(now);
        importBatchRecord.setHandleFlag(1);
        importBatchRecord.setUpdateTime(now);
        importStatistics.setImportBatchRecords(Arrays.asList(importBatchRecord));
    }

    public void calByTotalAndFailNum(int totalNum, int failedNum, ImportStatistics importStatistics, ImportBatchRecord importBatchRecord) {
        Date now = new Date();
        importStatistics.setSucceededNum(importStatistics.getSucceededNum() + totalNum - failedNum);
        importStatistics.setFailedNum(importStatistics.getFailedNum() + failedNum);
        importStatistics.setProcessingNum(importStatistics.getProcessingNum() - totalNum);
        importStatistics.setUpdateTime(now);
        importBatchRecord.setHandleFlag(1);
        importBatchRecord.setUpdateTime(now);
        importStatistics.setImportBatchRecords(Arrays.asList(importBatchRecord));
    }

    public void calErrorNum(int errorNum, ImportStatistics importStatistics, ImportBatchRecord importBatchRecord) {
        Date now = new Date();
        importStatistics.setProcessingNum(importStatistics.getProcessingNum() - errorNum);
        importStatistics.setErrorNum(importStatistics.getErrorNum() + errorNum);
        importStatistics.setUpdateTime(now);
        importBatchRecord.setHandleFlag(1);
        importBatchRecord.setUpdateTime(now);
        importStatistics.setImportBatchRecords(Arrays.asList(importBatchRecord));
    }

    public List<ImportStatistics> getImportStatisticsList(List<ImportStatisticsPO> importStatisticsPOS) {
        if (CollectionUtils.isEmpty(importStatisticsPOS)) {
            return emptyImportStatistics;
        }
        List<ImportStatistics> importStatisticsList = new LinkedList<>();
        importStatisticsPOS.forEach(item->{
            ImportStatistics importStatistics = new ImportStatistics();
            BeanUtils.copyProperties(item, importStatistics);
            LocalDateTime startTime = importStatistics.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            LocalDateTime endTime = importStatistics.getUpdateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (importStatistics.getProcessingNum()>0) {
                endTime = LocalDateTime.now();
            }
            // 计算消耗时间 如果为0的话改为1
            String consumeTime = String.valueOf(Duration.between(startTime, endTime).getSeconds());
            if ("0".equals(consumeTime)) {
                consumeTime = "1";
            }
            importStatistics.setConsumeTime(consumeTime);
            importStatisticsList.add(importStatistics);
        });
        return importStatisticsList;
    }

    public List<ImportBatchRecord> produce(List<DataEntryTask> productBatch) {
        Date now = new Date();
        List<ImportBatchRecord> importBatchRecords = new LinkedList<>();
        productBatch.forEach(item ->{
            ImportBatchRecord importBatchRecord = new ImportBatchRecord();
            importBatchRecord.setBatchSeq(item.getBatchNum());
            importBatchRecord.setPId(item.getMasterId());
            importBatchRecord.setHandleFlag(0);
            importBatchRecord.setCreateTime(now);
            importBatchRecord.setUpdateTime(now);
            importBatchRecords.add(importBatchRecord);
        });
        return importBatchRecords;
    }

    public List<ImportBatchRecordPO> getBatchRecordPOS(List<ImportBatchRecord> importBatchRecords) {
        List<ImportBatchRecordPO> importBatchRecordPOS = new LinkedList<>();
        importBatchRecords.forEach(item -> {
            ImportBatchRecordPO importBatchRecordPO = new ImportBatchRecordPO();
            BeanUtils.copyProperties(item, importBatchRecordPO);
            importBatchRecordPO.setId(SnowflakeIdWorker.getInstance().newId());
            importBatchRecordPOS.add(importBatchRecordPO);
        });
        return importBatchRecordPOS;
    }

    public ImportBatchRecord getImportBatchRecord(ImportBatchRecordPO importBatchRecordPO) {
        if (null == importBatchRecordPO) {
            return null;
        }
        ImportBatchRecord importBatchRecord = new ImportBatchRecord();
        BeanUtils.copyProperties(importBatchRecordPO, importBatchRecord);
        return importBatchRecord;
    }
}
