package com.digiwin.athena.abt.application.service.abt.migration.inout.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.athena.abt.application.dto.migration.abt.api.GetRecordsParamDTO;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ExportStatisticsRepositoryFacade;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ExportStatisticsMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ExportStatisticsPO;
import com.google.common.collect.Lists;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName ExportStatisticsRepositoryImpl
 * @Description 导出数据统计仓储实现类
 * @Author lisheng
 * @Date 2023/9/20 18:04
 * @Version 1.0
 **/
@Repository
public class ExportStatisticsRepositoryImpl implements ExportStatisticsRepositoryFacade {
    @Autowired
    ExportStatisticsMapper exportStatisticsMapper;

    @Override
    public int save(ExportStatisticsPO exportStatisticsPO) {
        return exportStatisticsMapper.insert(exportStatisticsPO);
    }

    @Override
    public ExportStatisticsPO getByMasterId(String masterId) {
        return exportStatisticsMapper.selectOne(new QueryWrapper<ExportStatisticsPO>().eq("master_id", masterId));
    }

    @Override
    public void updateById(ExportStatisticsPO exportStatisticsPO) {
        exportStatisticsMapper.updateById(exportStatisticsPO);
    }

    @Override
    public List<ExportStatisticsPO> getRecordsByUserId(String userId, String tenantId, Integer getRecordsNum, GetRecordsParamDTO param) {
        Integer start = (param.getOffset() - 1) * getRecordsNum;
        Integer end = param.getOffset() * getRecordsNum;
        // 查询的多个类型，优先使用“types”，“types”为空时，仍然使用type
        List<String> types = param.getTypes();
        String type = param.getType();
        if (CollectionUtils.isEmpty(types) && StringUtils.isNotBlank(type)) {
            types = Lists.newArrayList(type);
        }
        List<ExportStatisticsPO> exportStatisticsPOS = exportStatisticsMapper.getRecordsByUserId(userId, tenantId, end, param.getState(), types, param.getStartTime(), param.getEndTime(), param.getActivityName(), start, param.getFileName());
        return exportStatisticsPOS;
    }

    @Override
    public Integer countRecord(String userId, String tenantId, GetRecordsParamDTO param) {
        // 查询的多个类型，优先使用“types”，“types”为空时，仍然使用type
        List<String> types = param.getTypes();
        String type = param.getType();
        if (CollectionUtils.isEmpty(types) && StringUtils.isNotBlank(type)) {
            types = Lists.newArrayList(type);
        }
        return exportStatisticsMapper.countRecord(userId, tenantId, param.getState(), types, param.getStartTime(), param.getEndTime(), param.getActivityName());
    }

    @Override
    public List<ExportStatisticsPO> getProcessingRecords() {
        List<ExportStatisticsPO> exportStatisticsPOS = exportStatisticsMapper.selectList(
                new QueryWrapper<ExportStatisticsPO>().eq("state", ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING));
        return exportStatisticsPOS;
    }

    @Override
    public List<ExportStatisticsPO> getProcessingRecordsByUserId(String userId, String tenantId, String type, List<String> types) {
        // 查询的多个类型，优先使用“types”，“types”为空时，仍然使用type
        if (CollectionUtils.isEmpty(types) && StringUtils.isNotBlank(type)) {
            types = Lists.newArrayList(type);
        }
        List<ExportStatisticsPO> exportStatisticsPOS = exportStatisticsMapper.getProcessingRecordsByUserId(userId, tenantId, ImportAndExportStatisticsConstants.EXPROT_STATE_PROCESSING, types);
        return exportStatisticsPOS;
    }

    @Override
    public void updateRetryDownloadStateById(String masterId) {
        LambdaUpdateWrapper<ExportStatisticsPO> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(ExportStatisticsPO::getMasterId, masterId).set(ExportStatisticsPO::getHasBeenReExported, 1);
        JaLog.info(" retry export start ");
        exportStatisticsMapper.update(null, wrapper);
        JaLog.info(" has been re-exported");
    }

    @Override
    public void updateByStateAndId(ExportStatisticsPO exportStatisticsPO, Long id, Integer state) {
        LambdaUpdateWrapper<ExportStatisticsPO> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(ExportStatisticsPO::getId, id)
               .eq(ExportStatisticsPO::getState, state);
        JaLog.info(" retry export start ");
        exportStatisticsMapper.update(exportStatisticsPO, wrapper);
        JaLog.info(" has been re-exported");
    }

}
