package com.digiwin.athena.abt.application.service.abt.migration.inout.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportBatchRecordMapperService;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportBatchRecordRepositoryFacade;
import com.digiwin.athena.abt.core.meta.enums.ErrorCodeEnum;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ImportBatchRecordMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ImportBatchRecordPO;
import com.digiwin.athena.appcore.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName ImportBatchRecordRepositoryImpl
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/5/6 10:20
 * @Version 1.0
 **/
@Repository
public class ImportBatchRecordRepositoryImpl implements ImportBatchRecordRepositoryFacade {

    @Autowired
    ImportBatchRecordMapperService importBatchRecordMapperService;
    @Autowired
    ImportBatchRecordMapper importBatchRecordMapper;

    @Override
    public void saveBatch(List<ImportBatchRecordPO> importBatchRecordPOS) {
        if(!importBatchRecordMapperService.saveBatch(importBatchRecordPOS)){
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0081.getErrCode(),"保存导入批次失败");
        }
    }

    @Override
    public ImportBatchRecordPO selectByPIdAndBatchNum(String masterId, int batchNum) {
        return importBatchRecordMapper.selectOne(new QueryWrapper<ImportBatchRecordPO>().eq("p_id", masterId).eq("batch_seq", batchNum));
    }

    @Override
    public void updateBatch(List<ImportBatchRecordPO> importBatchRecordPOS) {
        if (!importBatchRecordMapperService.updateBatchById(importBatchRecordPOS)) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0082.getErrCode(),"更新导入批次失败");
        }
    }

    @Override
    public List<ImportBatchRecordPO> selectListByPId(String pId) {
        return importBatchRecordMapper.selectList(new QueryWrapper<ImportBatchRecordPO>().eq("p_id", pId).eq("handle_flag", 0));
    }
}
