package com.digiwin.athena.abt.application.service.abt.migration.inout.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.service.abt.migration.inout.ImportStatisticsRepositoryFacade;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.abt.ImportStatisticsMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.abt.ImportStatisticsPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName ImportStatisticsRepositoryImpl
 * @Description 导入数据统计仓储实现类
 * @Author zhuangli
 * @Date 2021/4/6 18:04
 * @Version 1.0
 **/
@Repository
public class ImportStatisticsRepositoryImpl implements ImportStatisticsRepositoryFacade {
    @Autowired
    ImportStatisticsMapper importStatisticsMapper;

    @Override
    public void save(ImportStatisticsPO importStatisticsPO) {
        importStatisticsMapper.insert(importStatisticsPO);
    }

    @Override
    public ImportStatisticsPO getByMasterId(String masterId) {
        return importStatisticsMapper.selectOne(new QueryWrapper<ImportStatisticsPO>().eq("master_id", masterId));
    }

    @Override
    public void updateById(ImportStatisticsPO importStatisticsPO) {
        importStatisticsMapper.updateById(importStatisticsPO);
    }

    @Override
    public List<ImportStatisticsPO> getRecordsByUserId(String userId, Integer getRecordsNum, String activityName, String startTime, String endTime, String type, Integer state, Integer offset) {
        Integer start = (offset - 1) * getRecordsNum;
        Integer end = offset * getRecordsNum;
        List<ImportStatisticsPO> importStatisticsPOS = importStatisticsMapper.getRecordsByUserId(userId, end, activityName, startTime, endTime, type, state, start);
        return importStatisticsPOS;
    }

    @Override
    public Integer countRecord(String userId, String activityName, String startTime, String endTime, String type, Integer state) {
        return importStatisticsMapper.countRecord(userId, activityName, startTime, endTime, type, state);
    }

    @Override
    public List<ImportStatisticsPO> getProcessingRecords() {
        List<ImportStatisticsPO> importStatisticsPOS = importStatisticsMapper.selectList(
                new QueryWrapper<ImportStatisticsPO>().ne("processing_num", 0));
        return importStatisticsPOS;
    }

    @Override
    public List<ImportStatisticsPO> getProcessingRecordsByUserId(String userId) {
        List<ImportStatisticsPO> importStatisticsPOS = importStatisticsMapper.selectList(
                new QueryWrapper<ImportStatisticsPO>().eq("user_id", userId).gt("processing_num", 0));
        return importStatisticsPOS;
    }

    @Override
    public Long getProcessingNum(String userId) {
        return importStatisticsMapper.selectCount(new QueryWrapper<ImportStatisticsPO>().eq("user_id", userId).gt("processing_num", 0));
    }

    @Override
    public List<ImportStatisticsPO> getActivityStatistics(String activityCode, String userId) {
        return importStatisticsMapper.selectList(new QueryWrapper<ImportStatisticsPO>()
                .eq("user_id", userId).eq("activity_id", activityCode).ne("processing_num", 0));
    }

    @Override
    public List<ImportStatisticsPO> queryImportStatisticsByFileUid(String fileUid ) {
        return importStatisticsMapper.selectList(new QueryWrapper<ImportStatisticsPO>()
                .eq("file_uid", fileUid).orderByDesc("create_time"));
    }

}
