package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.Map;
import java.util.Set;

/**
 * 布尔验证器
 *
 * @author wzq
 */
public abstract class AbstractValidator implements Validator {
    private static final String ERROR_CODE = "upload.miss.filed.error";

    @Override
    public String doValidate(Object data, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        Map.Entry<String, Object> cellEntry = (Map.Entry<String, Object>) data;

        //校验必填项
        String requiredMsg = requiredValidator(cellEntry, requiredFiled, locale);
        if (StringUtils.isNotEmpty(requiredMsg)) {
            return requiredMsg;
        }

        //校验格式
        return formatValidator(requiredFiled, container, locale, cellEntry);
    }

    private String formatValidator(Set<String> requiredFiled, CellTypeContainer container, String locale, Map.Entry<String, Object> cellEntry) {
        String errorMsg = null;
        if (null == container) {
            return errorMsg;
        }
        Object cellValue = cellEntry.getValue();
        // 校验数据格式时，如果单元格值为空，则不进行校验
        if (null == cellValue || (cellValue instanceof String && ((String) cellValue).isEmpty())) {
            return errorMsg;
        }
        return validate(cellValue, requiredFiled, container, locale);
    }

    public String requiredValidator(Map.Entry<String, Object> cellEntry, Set<String> requiredFiled, String locale) {
        String errorMsg = null;
        if (CollectionUtils.isEmpty(requiredFiled) || !requiredFiled.contains(cellEntry.getKey())) {
            return errorMsg;
        }

        if (null == cellEntry.getValue()) {
            return MessageUtil.getMessageByLocale(ERROR_CODE, locale);
        }

        if (cellEntry.getValue() instanceof String && ((String) cellEntry.getValue()).trim().isEmpty()) {
            return MessageUtil.getMessageByLocale(ERROR_CODE, locale);
        }
        return errorMsg;
    }

    public String validate(Object data, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        return null;
    }
}