package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

/**
 * 布尔验证器
 *
 * @author wzq
 */
public class BooleanValidator extends AbstractValidator {
    private static final String BOOLEAN_VALIDATOR_ERROR_CODE = "excel.select.content.selectCorrect";

    @Override
    public Boolean supportKey(CellTypeContainer cellTypeContainer) {
        return null != cellTypeContainer && MetaDataType.BOOLEAN.getName().equals(cellTypeContainer.getProtoType().getName());
    }

    @Override
    public String validate(Object cellValue, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        String superErrorMsg = super.validate(cellValue, requiredFiled, container, locale);
        if (!(cellValue instanceof Boolean)) {
            List<String> enumList = Arrays.asList(container.getListEnum());
            if (!enumList.contains(cellValue)) {
                superErrorMsg = MessageUtil.getMessageByLocale(BOOLEAN_VALIDATOR_ERROR_CODE, locale, enumList.toString());
            }
        }
        return superErrorMsg;
    }
}