package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.utils.ExcelUtil;
import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;

import java.util.Set;

/**
 * 日期时间验证器
 *
 * @author wzq
 */
public class DateTimeValidator extends AbstractValidator {
    private static final String DATETIME_VALIDATOR_ERROR_CODE = "excel.date.content.enterCorrect";

    @Override
    public Boolean supportKey(CellTypeContainer cellTypeContainer) {
        return null != cellTypeContainer && (MetaDataType.TIME.getName().equals(cellTypeContainer.getProtoType().getName())
                || MetaDataType.DATETIME.getName().equals(cellTypeContainer.getProtoType().getName())
                || MetaDataType.DATE.getName().equals(cellTypeContainer.getProtoType().getName()));
    }

    @Override
    public String validate(Object cellValue, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        String superErrorMsg = super.validate(cellValue, requiredFiled, container, locale);
        if (!ExcelUtil.isValidDate(cellValue.toString(), container.getDateFormat())) {
            superErrorMsg = MessageUtil.getMessageByLocale(DATETIME_VALIDATOR_ERROR_CODE, locale, container.getDateFormat());
        }
        return superErrorMsg;
    }
}