package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/**
 * 枚举验证器
 *
 * @author wzq
 */
public class EnumValidator extends AbstractValidator {
    private static final String ENUM_VALIDATOR_ERROR_CODE = "excel.select.content.selectCorrect";

    @Override
    public Boolean supportKey(CellTypeContainer cellTypeContainer) {
        return null != cellTypeContainer && MetaDataType.ENUM.getName().equals(cellTypeContainer.getProtoType().getName());
    }

    @Override
    public String validate(Object cellValue, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        String superErrorMsg = super.validate(cellValue, requiredFiled, container, locale);
        if (null != container.getListEnum() && container.getListEnum().length != 0) {
            List<String> enumList = Arrays.asList(container.getListEnum());
            List<String> enumCodes = getEnumCodes(enumList);
            if (!enumCodes.contains(cellValue)) {
                superErrorMsg = MessageUtil.getMessageByLocale(ENUM_VALIDATOR_ERROR_CODE, locale, enumList.toString());
            }
        }
        return superErrorMsg;
    }

    /**
     * 获取枚举code
     *
     * @param enumList
     * @return
     */
    private List<String> getEnumCodes(List<String> enumList) {
        List<String> enumCodes = new ArrayList<>();
        for (String enumStr : enumList) {
            int index = enumStr.lastIndexOf(".");
            String code;
            if (index > 0) {
                code = enumStr.substring(0, index);
            } else {
                code = enumStr;
            }
            enumCodes.add(code);
        }
        return enumCodes;
    }
}