package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;

import java.util.Set;

/**
 * 数字验证器
 *
 * @author wzq
 */
public class NumberValidator extends AbstractValidator {
    private static final String NUMBER_VALIDATOR_ERROR_CODE = "excel.number.content.isNumber";

    @Override
    public Boolean supportKey(CellTypeContainer cellTypeContainer) {
        return null != cellTypeContainer && MetaDataType.NUMBER.getName().equals(cellTypeContainer.getProtoType().getName());
    }

    @Override
    public String validate(Object cellValue, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        String superErrorMsg = super.validate(cellValue, requiredFiled, container, locale);
        if (!(cellValue instanceof Number)) {
            superErrorMsg = MessageUtil.getMessageByLocale(NUMBER_VALIDATOR_ERROR_CODE, locale);
        }
        return superErrorMsg;
    }
}