package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.application.utils.MessageUtil;
import com.digiwin.athena.abt.core.ie.excel.convert.StringConversionUtils;
import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;
import com.digiwin.athena.abt.core.meta.enums.MetaDataType;

import java.util.Set;

/**
 * 数值型验证器
 *
 * @author wzq
 */
public class NumericValidator extends AbstractValidator {
    private static final String NUMERIC_VALIDATOR_ERROR_CODE = "excel.number.content.isNumber";

    @Override
    public Boolean supportKey(CellTypeContainer cellTypeContainer) {
        return null != cellTypeContainer && MetaDataType.NUMERIC.getName().equals(cellTypeContainer.getProtoType().getName());
    }

    @Override
    public String validate(Object cellValue, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        String superErrorMsg = super.validate(cellValue, requiredFiled, container, locale);
        if (cellValue instanceof String) {
            String stringValue = (String) cellValue;
            if (!StringConversionUtils.isNumericBigDecimal(stringValue)) {
                superErrorMsg = MessageUtil.getMessageByLocale(NUMERIC_VALIDATOR_ERROR_CODE, locale);
            }
        }
        return superErrorMsg;
    }
}