package com.digiwin.athena.abt.application.service.abt.migration.inout.validate;

import com.digiwin.athena.abt.core.meta.dto.CellTypeContainer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * 验证器加载器
 *
 * @author wzq
 */
public class ValidatorLoader {
    private static List<Validator> validators;

    static {
        initAllValidator();
    }

    private static void initAllValidator() {
        validators = new ArrayList<>();
        validators.add(new StringValidator());
        validators.add(new NumberValidator());
        validators.add(new NumericValidator());
        validators.add(new DateTimeValidator());
        validators.add(new DateTimeValidator());
        validators.add(new DateTimeValidator());
        validators.add(new BooleanValidator());
        validators.add(new EnumValidator());

        validators.add(new DefaultValidator());
    }

    public static String valid(Object cellData, Set<String> requiredFiled, CellTypeContainer container, String locale) {
        for (Validator t : validators) {
            if (t.supportKey(container)) {
                return t.doValidate(cellData, requiredFiled, container, locale);
            }
        }
        return null;
    }
}