package com.digiwin.athena.abt.application.service.abt.migration.lock;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

/**
 * @ClassName LockPool
 * @Description 锁池
 * @Author zhuangli
 * @Date 2023/3/13 13:31
 * @Version 1.0
 **/
@Component
public class LockPool {

    private ConcurrentHashMap<Integer, ReentrantLock> mappedLockPool;
    @Value("${data-entry.lock-pool.size:9}")
    private int poolSize;

    @PostConstruct
    public void init(){
        mappedLockPool = new ConcurrentHashMap<>();
        for (int i = 0; i < poolSize; i++) {
            mappedLockPool.put(i + 1, new ReentrantLock());
        }
    }

    public int getPoolSize() {
        return poolSize;
    }

    public ReentrantLock getLockById(int id) {
        if (id > poolSize) {
            throw new IndexOutOfBoundsException("id cannot be larger than pool size");
        }
        return mappedLockPool.get(id);
    }

}
