package com.digiwin.athena.abt.application.service.abt.migration.mq;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

@Slf4j
public class ConfirmCallbackService implements RabbitTemplate.ConfirmCallback {
    @Override
    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        if (!ack) {
            log.error("消息发送异常!correlationData={}, ack={}, cause={}", correlationData, ack, cause);
        } else {
            log.info("发送者已经收到确认，correlationData={}, ack={}, cause={}", correlationData, ack, cause);
        }
    }
}
