package com.digiwin.athena.abt.application.service.abt.migration.mq;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventInterface;
import com.digiwin.athena.abt.application.service.abt.migration.sendmsg.TaskOperateSendMsgMqService;
import com.digiwin.athena.abt.core.meta.constants.EventModelConstants;
import com.digiwin.athena.abt.core.meta.constants.EventMqConstants;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

/**
 * 发送消息通知
 */
@Slf4j
@Service
public class TaskOperateSendMsgModel extends EventBaseService implements EventInterface {


    @Autowired
    private TaskOperateSendMsgMqService taskOperateSendMsgMqService;

    /**
     * 支持消息类型
     *
     * @return
     */
    @Override
    public String modelType() {
        return EventModelConstants.TASK_OPERATE_SEND_MSG_MODEL;
    }

    /**
     * 分发消息
     *
     * @param
     * @param data
     */
    @Override
    public void distributeMessages(String data) {
        log.info("[taskOperateSendMsg] distributeMessages, data = {}", data);
        rabbitTemplate.convertAndSend(EventMqConstants.EVENT_MQ_EXCHANGE_NAME, EventMqConstants.EVENT_MQ_TASK_OPREATE_SEND_MSG_ROUTING, data);
    }

    /**
     * 消费消息
     *
     * @param data
     */
    @Override
    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = EventMqConstants.EVENT_MQ_TASK_OPERATE_SEND_MSG_QUEUE, durable = "true", autoDelete = "false"),
            exchange = @Exchange(value = EventMqConstants.EVENT_MQ_EXCHANGE_NAME, type = ExchangeTypes.TOPIC),
            key = EventMqConstants.EVENT_MQ_TASK_OPREATE_SEND_MSG_ROUTING
    ), concurrency = "#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('" + EventMqConstants.EVENT_MQ_TASK_OPERATE_SEND_MSG_QUEUE + "')}")
    @RabbitRetry(beforeHandler = "ptmMqBeforeHandler", successHander = "ptmMqSuccessHandler", failureHandler = "ptmMqFailureHandler")
    public void consumeMessage(String data, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag, @Header(value = "retry-count", required = false) Integer retryCount) {
        log.info("[taskOperateSendMsg] consumeMessage, queue = {}, data = {}", EventMqConstants.EVENT_MQ_TASK_OPERATE_SEND_MSG_QUEUE, data);
        super.receiveOrder(data, EventMqConstants.EVENT_MQ_TASK_OPERATE_SEND_MSG_QUEUE, channel, tag, retryCount);
    }

    /**
     * 重写：处理mq消息
     */
    @Override
    public void processMessage(String data, EventListenerDTO mqMessageDTO) {
        try{
            AuthoredUser user = super.getUser(mqMessageDTO);
            log.info("[taskOperateSendMsg] start, param = {}", data);
            LogDto logDto = new LogDto("【taskOperateSendMsg】任务操作消息开始处理，消息类型：" + mqMessageDTO.getType().getValue(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + mqMessageDTO.getType().getValue());
            log.info(logDto.toString());
            if (EventMqTypeEnum.backlog.equals(mqMessageDTO.getType())) {
                log.info("[taskOperateSendMsg] task overdue , param = {}", data);
                taskOperateSendMsgMqService.processBacklogOverDueMessage(data, user);
            } else if (EventMqTypeEnum.dataConsistency.equals(mqMessageDTO.getType())) {
                log.info("[taskOperateSendMsg] task add , param = {}", data);
                taskOperateSendMsgMqService.processWorkItemAddMessage(data, user);
            }
        }
        catch(Exception e){
            log.warn("SendMessageNoticeModel error");
        }

    }
}
