package com.digiwin.athena.abt.application.service.abt.migration.mqtt;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.TaskCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.PtmProjectChangeEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.PtmTaskChangeEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.PtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.ptm.PtmProjectTransformService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCard;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.framework.mq.retry.exception.RetryMQException;
import com.google.common.eventbus.AsyncEventBus;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class BacklogMqttService {

    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    private PtmTransformService ptmTransformService;

    @Autowired
    private PtmProjectTransformService ptmProjectTransformService;

    @Autowired
    private AsyncEventBus localEventBus;

    public void processMessage(String data, AuthoredUser user) {
        log.debug("接收ptm消息_处理消息_PTM待办mqtt消息_开始");
        PtmBacklogMessageDTO backlogMessageDTO = JsonUtils.jsonToObject(data, PtmBacklogMessageDTO.class);
        if (checkBacklogMsg(backlogMessageDTO)) {
            log.debug("接收ptm消息_处理消息_PTM待办mqtt消息_结束");
            return;
        }
        PtmBacklogMessageDTO.Backlog ptmBacklog = backlogMessageDTO.getData().getBacklog();

        try {
            //发送项目卡变更事件，当任务变更时，项目也会变更
            PtmProjectCard projectCard = commonPtmTransformService.getProjectInfo(ptmBacklog.getProjectCardId());

            ProjectCardDTO projectCardDTO = ptmProjectTransformService.translateProjectCardForMQTT(projectCard, ptmBacklog.getPerformerId());
            PtmProjectChangeEvent ptmProjectChangeEvent = new PtmProjectChangeEvent();
            ptmProjectChangeEvent.setProject(projectCardDTO);
            ptmProjectChangeEvent.setOperation(PtmMqOperation.CHANGE);
            ptmProjectChangeEvent.setAuthoredUser(user);
            ptmProjectChangeEvent.setPtmMqType(backlogMessageDTO.getType());
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmProjectChangeEvent_入参:ptmProjectChangeEvent={}", JSON.toJSONString(ptmProjectChangeEvent));
            localEventBus.post(ptmProjectChangeEvent);
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmProjectChangeEvent_结束");
            log.info("【processProjectCardMessage-projectCardDTO】：{}", projectCardDTO);
        } catch (Exception ex) {
            if (ex instanceof RetryMQException){
                throw ex;
            }
            log.warn("processProjectCardMessage-projectCardDTO:{}", ex);
        }

        try {
            //从PTM获取任务详情
            PtmBacklog backlogNew = commonPtmTransformService.getBacklogForCard(ptmBacklog.getBacklogId());
            backlogNew.setHide(convertHidden(ptmBacklog.getHidden()));
            log.info("【processBacklogMessage-backlog】：{}", JsonUtils.objectToString(backlogNew));
            TaskCardDTO taskCardDTO = ptmTransformService.translateBacklogForMQTT(backlogNew);
            PtmTaskChangeEvent ptmTaskChangeEvent = new PtmTaskChangeEvent();
            ptmTaskChangeEvent.setOperation(backlogMessageDTO.getOperation());
            ptmTaskChangeEvent.setAuthoredUser(user);
            ptmTaskChangeEvent.setTaskCardDTO(taskCardDTO);
            ptmTaskChangeEvent.setTaskDefCode(ptmBacklog.getTaskDefCode());
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_入参:ptmTaskChangeEvent={}", JSON.toJSONString(ptmTaskChangeEvent));
            localEventBus.post(ptmTaskChangeEvent);
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_结束");
            log.info("【processBacklogMessage-taskCardDTO】：{}", taskCardDTO);
        } catch (Exception ex) {
            log.warn("processBacklogMessage-taskCardDTO:{}", ex);
        }
        log.debug("接收ptm消息_处理消息_PTM待办mqtt消息_结束");
    }

    public boolean checkBacklogMsg(PtmBacklogMessageDTO message) {
        PtmBacklogMessageDTO.Backlog backlog = message.getData().getBacklog();
        if (PtmMqOperation.CLOSE.equals(message.getOperation())
                && null == backlog.getBacklogId()) {
            // 目前有backlogId为空的消息 这种消息不消费 ，记录日志
            log.debug("接收ptm消息_处理消息_PTM待办消息_关闭操作_backlogId为空:message={}", JSON.toJSONString(message));
            return true;
        }
        return false;
    }

    private Integer convertHidden(Boolean hidden) {
        if (null == hidden) {
            return 0;
        }
        return hidden ? 1 : 0;
    }

}
