package com.digiwin.athena.abt.application.service.abt.migration.mqtt;

import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventBaseService;
import com.digiwin.athena.abt.application.service.abt.migration.event.EventInterface;
import com.digiwin.athena.abt.core.meta.constants.EventModelConstants;
import com.digiwin.athena.abt.core.meta.constants.EventMqConstants;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

/**
 * 任务卡、项目卡  发送mqtt
 */
@Slf4j
@Service
public class EventProjectCardMqttMessageModel extends EventBaseService implements EventInterface {

    @Autowired
    private BacklogMqttService backlogMqttService;

    @Autowired
    private ProjectCardMqttService projectCardMqttService;

    /**
     * 支持消息类型
     *
     * @return
     */
    @Override
    public String modelType() {
        return EventModelConstants.CARD_MQTT_MODEL;
    }

    /**
     * 分发消息
     *
     * @param
     * @param data
     */
    @Override
    public void distributeMessages(String data) {
        rabbitTemplate.convertAndSend(EventMqConstants.EVENT_MQ_EXCHANGE_NAME, EventMqConstants.EVENT_CARD_MQTT_ROUTING, data);
    }

    /**
     * 消费消息
     *
     * @param data
     */
    @Override
    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = EventMqConstants.EVENT_CARD_MQTT_QUEUE, durable = "true", autoDelete = "false"),
            exchange = @Exchange(value = EventMqConstants.EVENT_MQ_EXCHANGE_NAME, type = ExchangeTypes.TOPIC),
            key = EventMqConstants.EVENT_CARD_MQTT_ROUTING
    ), concurrency = "#{@'athena.mq.concurrency-com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties'.getConcurrency('" + EventMqConstants.EVENT_CARD_MQTT_QUEUE + "')}")
    @RabbitRetry(beforeHandler = "ptmMqBeforeHandler", successHander = "ptmMqSuccessHandler", failureHandler = "ptmMqFailureHandler")
    public void consumeMessage(String data, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag, @Header(value = "retry-count", required = false) Integer retryCount) {
        super.receiveOrder(data, EventMqConstants.EVENT_CARD_MQTT_QUEUE, channel, tag, retryCount);
    }

    /**
     * 重写：处理mq消息
     */
    @Override
    public void processMessage(String data, EventListenerDTO mqMessageDTO) {
        AuthoredUser user = super.getUser(mqMessageDTO);
        LogDto logDto = new LogDto("【cardMqttModel】处理群聊消息，消息类型：" + mqMessageDTO.getType().getValue(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + mqMessageDTO.getType().getValue());
        log.info(logDto.toString());
        if (EventMqTypeEnum.backlog.equals(mqMessageDTO.getType())) {
            backlogMqttService.processMessage(data, user);
        } else if (EventMqTypeEnum.projectCard.equals(mqMessageDTO.getType())) {
            projectCardMqttService.processMessage(data, user);
        }
    }
}
