package com.digiwin.athena.abt.application.service.abt.migration.mqtt;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardDataDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmProjectCardMessageDTO;

import com.digiwin.athena.abt.application.dto.migration.atmc.event.PtmProjectChangeEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;

import com.digiwin.athena.abt.application.service.atmc.migration.ptm.PtmProjectTransformService;

import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmProjectCardMapper;

import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCard;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.eventbus.AsyncEventBus;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
@Slf4j
public class ProjectCardMqttService {
    @Autowired
    private PtmProjectCardMapper ptmProjectCardMapper;

    @Autowired
    private PtmProjectTransformService ptmProjectTransformService;

    @Autowired
    private AsyncEventBus localEventBus;

    public void processMessage(String data, AuthoredUser user) {
        PtmProjectCardMessageDTO message = JsonUtils.jsonToObject(data, PtmProjectCardMessageDTO.class);
        PtmProjectCardDataDTO cardDataDTO = message.getData();
        PtmProjectCardDTO cardDTO = cardDataDTO.getProjectCard();
        try {
            log.debug("接收ptm消息_处理消息_项目卡消息_mqtt_结束开始，cardDTO：{}", data);
            PtmProjectCard projectCard = ptmProjectCardMapper.selectById(cardDTO.getId());
            ProjectCardDTO projectCardDTO = ptmProjectTransformService.translateProjectCardForMQTT(projectCard, cardDTO.getPersonInCharge());
            PtmProjectChangeEvent ptmProjectChangeEvent = new PtmProjectChangeEvent();
            ptmProjectChangeEvent.setProject(projectCardDTO);
            ptmProjectChangeEvent.setOperation(message.getOperation());
            ptmProjectChangeEvent.setAuthoredUser(user);
            ptmProjectChangeEvent.setPtmMqType(message.getType());
            log.debug("接收ptm消息_处理消息_项目卡消息_event发送_PtmProjectChangeEvent_入参:ptmProjectChangeEvent={}", JSON.toJSONString(ptmProjectChangeEvent));
            localEventBus.post(ptmProjectChangeEvent);
            log.debug("接收ptm消息_处理消息_项目卡消息_event发送_PtmProjectChangeEvent_结束");
            log.debug("接收ptm消息_处理消息_项目卡消息_mqtt_结束");
        } catch (Exception ex) {
            log.warn("processProjectCardMessage-projectCardDTO:{}", ex);
        }
    }

}
