package com.digiwin.athena.abt.application.service.abt.migration.mqtt;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.PtmProjectChangeEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmMqType;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.BacklogBatchQueryBusinessDataService;
import com.digiwin.athena.abt.application.service.atmc.migration.project.ProjectHandleService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.abt.core.meta.enums.PageCode;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.core.meta.enums.VerifyAppPermissionEnum;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmProjectCardITraceDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionReq;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionResp;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.*;

@Component
@Slf4j
public class PtmProjectChangedSubscriber {
    public static final String TASK_ON_OFF = "taskOnOff";

    public static final String TASK_ON_OFF_V2 = "taskOnOffV2";
    @Autowired
    private AimService aimService;

    @Autowired
    private UserService userService;

    @Autowired
    protected EocService eocService;

    @Autowired
    private AtmcService atmcService;

    @Autowired
    private ProjectHandleService projectHandleService;

    @Autowired
    private BacklogBatchQueryBusinessDataService backlogBatchQueryBusinessDataService;

    @Autowired
    private PtmService ptmService;

    /**
     * 人工关卡开始的事件订阅
     *
     * @param event
     */
    @Subscribe
    @AllowConcurrentEvents
    public void handleEvent(PtmProjectChangeEvent event) {
        try {
            log.info("【PtmProjectChangedSubscriber-event】：{}", event);
            processEvent(event);
        } catch (Exception ex) {
            log.warn(ex.getMessage(), ex);
        }
    }

    private void processEvent(PtmProjectChangeEvent event) throws JsonProcessingException {
        ProjectCardDTO projectCardDTO = event.getProject();
        if (projectCardDTO == null) {
            return;
        }
        AuthoredUser authoredUser = event.getAuthoredUser();

        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        LogDto logDto = new LogDto("PTM项目有变更,实时刷新项目卡，项目卡id:" + projectCardDTO.getId(), authoredUser.getTenantId() == null ? "" : authoredUser.getTenantId() + LogConstant.TRACE_SEPARATOR + projectCardDTO.getId());
        log.info(logDto.toString());

        sendProjectChangeMessageToClient(event.getOperation(), projectCardDTO, projectCardDTO.getPersonInCharge(), authoredUser, event.getPtmMqType());
    }

    public void sendProjectChangeMessageToClient(PtmMqOperation operation, ProjectCardDTO projectCardDTO, String targetUserId, AuthoredUser authoredUser, EventMqTypeEnum ptmMqType) throws JsonProcessingException {
        if (PtmMqType.projectCard.equals(ptmMqType)) {
            log.debug("接收ptm消息_处理消息_项目卡消息_event发送_PtmProjectChangeEvent_实时刷新项目卡_入参:operation={},projectCardDTO={}", JSON.toJSONString(operation), JSON.toJSONString(projectCardDTO));
        } else {
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmProjectChangeEvent_实时刷新项目卡_入参:operation={},projectCardDTO={}", JSON.toJSONString(operation), JSON.toJSONString(projectCardDTO));
        }
        // 应用授权信息
        VerifyAppPermissionResp resp = verifyAppPermission(projectCardDTO.getId(), targetUserId);
        if (null != resp) {
            projectCardDTO.setAppCode(resp.getAppCode());
            projectCardDTO.setAppName(resp.getAppName());
            projectCardDTO.setHasAppPermission(resp.getHasAppPermission());
        }

        if (atmcService.verifyConfig(TASK_ON_OFF, "true")
                || atmcService.verifyConfig(TASK_ON_OFF_V2, "true")) {
            if (PtmMqType.projectCard.equals(ptmMqType)) {
                log.debug("接收ptm消息_处理消息_项目卡消息_event发送_PtmProjectChangeEvent_实时刷新项目卡_执行addDataFieldsV2");
            } else {
                log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmProjectChangeEvent_实时刷新项目卡_执行addDataFieldsV2");
            }
            projectHandleService.addDataFieldsV2(Collections.singletonList(projectCardDTO), authoredUser, "project-card");
        }
        backlogBatchQueryBusinessDataService.setBusinessMessageForProject(Collections.singletonList(projectCardDTO), authoredUser, PageCode.PROJECT_CARD.getValue());
        if (PtmMqType.projectCard.equals(ptmMqType)) {
            log.debug("接收ptm消息_处理消息_项目卡消息_event发送_PtmProjectChangeEvent_实时刷新项目卡_执行setBusinessMessageForProject");
        } else {
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmProjectChangeEvent_实时刷新项目卡_执行setBusinessMessageForProject");
        }

        //调用ptm获取卡片来源
        List<Long> projectCards = new ArrayList<>();
        projectCards.add(projectCardDTO.getId());
        List<PtmProjectCardITraceDTO> traceList = ptmService.queryProjectCardTrace(projectCards, targetUserId);
        if (CollectionUtils.isNotEmpty(traceList)) {
            PtmProjectCardITraceDTO traceDTO = traceList.get(0);
            //设置卡片来源状态和人员信息、创建时间
            setSourceInfo(projectCardDTO, traceDTO);
        }
        MessageDO messageDO = new MessageDO();
        messageDO.setJsonContent(this.parseMessageJsonContent(projectCardDTO, targetUserId, authoredUser.getTenantId(), authoredUser.getToken()));
        // bug-156254 项目卡转派，交接场景 mqtt消息Category=EDIT导致前端不刷新。改为ADD。
        // bug-156254 创建项目卡 场景会有两条mqtt消息，第一条Category=ADD,第二条Category=EDIT
        if (BooleanUtils.isTrue(projectCardDTO.getReassign()) || BooleanUtils.isTrue(projectCardDTO.getHandover())) {
            messageDO.setCategory(PtmMqOperation.ADD.getValue());
        } else {
            messageDO.setCategory(operation.getMqttCategory());
        }
        messageDO.setSendDate(LocalDateTime.now());
        messageDO.setGid(UUID.randomUUID().toString());
        messageDO.setTenantId(authoredUser.getTenantId());
        messageDO.setUserId(targetUserId);
        messageDO.setType("Project");
        List<String> users = new ArrayList<>();
        users.add(targetUserId);
        aimService.sendMessageToClient(authoredUser.getToken(), authoredUser.getTenantId(), users, messageDO);
        if (PtmMqType.projectCard.equals(ptmMqType)) {
            log.debug("接收ptm消息_处理消息_项目卡消息_event发送_PtmProjectChangeEvent_实时刷新项目卡_执行aim用户通知");
        } else {
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmProjectChangeEvent_实时刷新项目卡_执行aim用户通知");
        }
        log.info("【PtmProjectChangedSubscriber】projectCardId：{}，token：{}，tenantId：{}，users：{}，message：{}",projectCardDTO.getId(), authoredUser.getToken(), authoredUser.getTenantId(), users, JsonUtils.objectToString(messageDO));

        //获取代理用户
        ProxyUserResp proxyUserResp = eocService.getProxyUser(projectCardDTO.getPersonInCharge(), authoredUser.getToken());
        if (proxyUserResp != null && proxyUserResp.getUserId() != null) {
            // 应用授权信息
            VerifyAppPermissionResp proxyResp = verifyAppPermission(projectCardDTO.getId(), proxyUserResp.getUserId());
            if (null != resp) {
                projectCardDTO.setAppCode(proxyResp.getAppCode());
                projectCardDTO.setAppCode(proxyResp.getAppName());
                projectCardDTO.setHasAppPermission(proxyResp.getHasAppPermission());
            }
            projectCardDTO.setIsOwner(false);
            messageDO.setJsonContent(this.parseMessageJsonContent(projectCardDTO, proxyUserResp.getUserId(), authoredUser.getTenantId(), authoredUser.getToken()));
            users.clear();
            users.add(proxyUserResp.getUserId());
            LogDto logDtoProxy = new LogDto("请求aim发送新消息给代理用户", authoredUser.getTenantId());
            log.info(logDtoProxy.toString());
            aimService.sendMessageToClient(authoredUser.getToken(), authoredUser.getTenantId(), users, messageDO);
            if (PtmMqType.projectCard.equals(ptmMqType)) {
                log.debug("接收ptm消息_处理消息_项目卡消息_event发送_PtmProjectChangeEvent_实时刷新项目卡_执行aim代理用户通知");
            } else {
                log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmProjectChangeEvent_实时刷新项目卡_执行aim代理用户通知");
            }
            log.info("【PtmProjectChangedSubscriber】projectCardId：{}，token：{}，tenantId：{}，users：{}，message：{}", projectCardDTO.getId(),authoredUser.getToken(), authoredUser.getTenantId(), users, messageDO);
        }
        if (PtmMqType.projectCard.equals(ptmMqType)) {
            log.debug("接收ptm消息_处理消息_项目卡消息_event发送_PtmProjectCardEvent_实时刷新项目卡_结束");
        } else {
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmProjectCardEvent_实时刷新项目卡_结束");
        }
    }

    /**
     * 设置项目卡来源信息和状态
     *
     * @param projectCardDTO
     * @param traceDTO
     */
    private void setSourceInfo(ProjectCardDTO projectCardDTO, PtmProjectCardITraceDTO traceDTO) {
        //设置来源信息和状态
        projectCardDTO.setOldPerformerId(traceDTO.getOldPerformerId());
        projectCardDTO.setOldPerformerName(traceDTO.getOldPerformerName());
        if (null != traceDTO.getCreateTime()) {
            projectCardDTO.setCreateTime(traceDTO.getCreateTime());
        }
        Integer type = traceDTO.getType();//ptm查询到的项目状态
        switch (type) {
            case 0://系统新增
                break;
            case 1://转派
                projectCardDTO.setReassign(true);
                break;
            case 3://交接
                projectCardDTO.setHandover(true);
                break;
            default:
                break;
        }
    }

    private String parseMessageJsonContent(ProjectCardDTO projectCardDTO, String receiverUserId, String tenantId, String token) throws JsonProcessingException {
        if (StringUtils.isBlank(projectCardDTO.getWithName()) && StringUtils.isBlank(projectCardDTO.getProjectDefWithName())) {
            return JsonUtils.createObjectMapper().writeValueAsString(projectCardDTO);
        }

        String lang = getUserLang(token, receiverUserId, tenantId);
        log.info("发送mqtt消息通知客户新增项目卡获取用户语言别是：userId: {}, tenantId: {}, lang: {}", receiverUserId, tenantId, lang);

        if (StringUtils.isNotBlank(lang)) {
            Map<Object, Object> map = JsonUtils.createObjectMapper().convertValue(projectCardDTO, new TypeReference<Map<Object, Object>>() {
            });

            map.put("withName", null);
            map.put("projectDefWithName", null);

            map.put("name", MessageUtils.getMessageByLanguage(projectCardDTO.getWithName(), lang));
            map.put("projectName", MessageUtils.getMessageByLanguage(projectCardDTO.getProjectDefWithName(), lang));
            return JsonUtils.createObjectMapper().writeValueAsString(map);
        } else {
            return JsonUtils.createObjectMapper().writeValueAsString(projectCardDTO);
        }
    }

    /**
     * 获取用户语言别设置
     *
     * @param token
     * @param userId
     * @return
     */
    private String getUserLang(String token, String userId, String tenantId) {
        String lang;
        try {
            lang = userService.getUserLangNameByUserId(userId, tenantId, token);
        } catch (Exception ex) {
            log.info("发送mqtt消息通知客户新增项目卡获取用户语言别发生异常，userId: {}, tenantId: {}, ex:", userId, tenantId, ex);
            lang = null;
        }
        return lang;
    }

    private VerifyAppPermissionResp verifyAppPermission(Long ptmProjectCardId, String userId) {
        VerifyAppPermissionReq req = new VerifyAppPermissionReq();
        req.setType(VerifyAppPermissionEnum.PROJECT.getValue());
        req.setBusinessId(ptmProjectCardId);
        req.setUserId(userId);
        return atmcService.verifyAppPermission(req);
    }
}
