package com.digiwin.athena.abt.application.service.abt.migration.mqtt;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.TaskCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.PtmTaskChangeEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.BacklogBatchQueryBusinessDataService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.core.meta.enums.AtmcErrorCodeEnum;
import com.digiwin.athena.abt.core.meta.enums.PageCode;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.core.meta.enums.VerifyAppPermissionEnum;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmTaskCardITraceDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionReq;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionResp;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.RetryableAction;
import com.digiwin.athena.appcore.util.RetryableOperationToolkit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.*;

@Component
@Slf4j
public class PtmTaskChangedSubscriber {
    public static final String TASK_ON_OFF = "taskOnOff";

    public static final String TASK_ON_OFF_V2 = "taskOnOffV2";

    public static final String TASK_CARD_WHITE_LIST = "taskCardWhiteList";
    @Autowired
    private AimService aimService;

    @Autowired
    private UserService userService;

    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    @Autowired
    protected EocService eocService;

    @Autowired
    private AtmcService atmcService;

    @Autowired
    private BacklogBatchQueryBusinessDataService backlogBatchQueryBusinessDataService;

    @Autowired
    private PtmService ptmService;


    /**
     * 人工关卡开始的事件订阅
     *
     * @param event
     */
    @Subscribe
    @AllowConcurrentEvents
    public void activityStartedHandle(PtmTaskChangeEvent event) {
        try {
            log.info("【PtmTaskChangedSubscriber-event】：{}", JsonUtils.objectToString(event));
        } catch (Exception ex) {
            log.warn(ex.getMessage(), ex);
        }
        try {
            processEvent(event);
        } catch (Exception ex) {
            log.warn(ex.getMessage(), ex);
        }
    }

    private void processEvent(PtmTaskChangeEvent event) {
        log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_入参:event={}", JSON.toJSONString(event));
        TaskCardDTO taskCardDTO = event.getTaskCardDTO();
        if (taskCardDTO == null) {
            return;
        }
        int maxRetryTimes = 5;
        RetryableOperationToolkit.operate(maxRetryTimes, new RetryableAction<PtmBacklog>() {
            @Override
            public PtmBacklog active(int retryTime) {
                // 获取入库结果
                return ptmBacklogMapper.selectById(taskCardDTO.getBacklogId());
            }

            @Override
            public boolean needRetry(PtmBacklog ptmBacklog) {
                //任务入库后，进行消息发送
                if (ptmBacklog != null) {
                    sendAppMsg(event);
                    return false;
                }
                try {
                    Thread.sleep(500);
                } catch (InterruptedException e) {
                    log.warn("【PtmTaskChangedSubscriber】exception:{}", e);
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                log.info("【PtmTaskChangedSubscriber】 has no ptmBacklog mysqlData:{}", event.getTaskCardDTO().getBacklogId());
                return true;
            }
        });
        log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_结束");
    }

    private String parseMessageJsonContent(TaskCardDTO taskCardDTO, String receiverUserId, String tenantId, String token) throws JsonProcessingException {
        if (StringUtils.isBlank(taskCardDTO.getWithName())) {
            return JsonUtils.createObjectMapper().writeValueAsString(taskCardDTO);
        }

        String lang = null;
        try {
            lang = userService.getUserLangNameByUserId(receiverUserId, tenantId, token);
        } catch (Exception ex) {
            log.info("发送mqtt消息通知客户新增任务卡获取用户语言别发生异常，userId: {}, tenantId: {}, ex:", receiverUserId, tenantId, ex);
            lang = null;
        }

        if (StringUtils.isNotBlank(lang)) {
            Map<Object, Object> map = JsonUtils.createObjectMapper().convertValue(taskCardDTO, new TypeReference<Map<Object, Object>>() {
            });

            map.put("withName", null);
            map.put("tmActivityWithName", null);

            map.put("name", MessageUtils.getMessageByLanguage(taskCardDTO.getWithName(), lang));
            map.put("tmActivityName", MessageUtils.getMessageByLanguage(taskCardDTO.getTmActivityWithName(), lang));
            return JsonUtils.createObjectMapper().writeValueAsString(map);
        } else {
            return JsonUtils.createObjectMapper().writeValueAsString(taskCardDTO);
        }
    }

    private void sendAppMsg(PtmTaskChangeEvent event) {
        try {
            TaskCardDTO taskCardDTO = event.getTaskCardDTO();
            sendTaskChangeMessageToClient(event.getOperation(), taskCardDTO, taskCardDTO.getOwnerUserId(), event.getAuthoredUser());
        } catch (JsonProcessingException e) {
            throw AtmcErrorCodeEnum.ATMC_JSON_PROCESSING_EX.getBusinessException();
        } finally {
            //AppAuthContextHolder.getContext().setAuthoredUser(null);
        }
    }

    public void sendTaskChangeMessageToClient(PtmMqOperation operation, TaskCardDTO taskCardDTO, String targetUserId, AuthoredUser authoredUser) throws JsonProcessingException {
        log.info("init taskCard Data: {}", taskCardDTO);
        // 应用授权信息
        VerifyAppPermissionResp resp = getAppPermission(taskCardDTO.getBacklogId(), targetUserId);
        Map<Long, Object> dataFieldsMap = new HashMap<>();
        Boolean taskCardWhiteList = atmcService.verifyConfig(TASK_CARD_WHITE_LIST, taskCardDTO.getTenantId());
        Boolean authoreUsertaskCardWhiteList = atmcService.verifyConfig(TASK_CARD_WHITE_LIST, authoredUser.getTenantId());
        Boolean taskOnOff = atmcService.verifyConfig(TASK_ON_OFF, "true");
        Boolean taskOnOffV2 = atmcService.verifyConfig(TASK_ON_OFF_V2,"true");
        if (taskCardWhiteList || taskOnOff) {
            try {
                log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_获取任务卡配置_入参:backlogId={},tmActivityId={}", taskCardDTO.getBacklogId(), taskCardDTO.getTmActivityId());
                dataFieldsMap = backlogBatchQueryBusinessDataService.addDataFieldsByBacklogId(taskCardDTO.getBacklogId(), taskCardDTO.getTmActivityId(), AppAuthContextHolder.getContext().getAuthoredUser());
                log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_获取任务卡配置_出参:dataFieldsMap={}", JSON.toJSONString(dataFieldsMap));

                log.info("【processBacklogMessage-dataFieldsMap】：{}", dataFieldsMap);
                Map data = (Map) dataFieldsMap.get(taskCardDTO.getBacklogId());
                taskCardDTO.setGroup((Map<String, String>) data.get("group"));
                taskCardDTO.setLabels((List<Map<String, Object>>) data.get("label"));
                taskCardDTO.setColumns((List<Map<String, Object>>) data.get("columns"));
                taskCardDTO.setOrder((Map<String, Integer>) data.get("order"));
            } catch (Exception e) {
                log.error("get business data failure: {}, :{}", e.getMessage(), taskCardDTO.getBacklogId());
            }
        }

        if (null != resp) {
            taskCardDTO.setAppCode(resp.getAppCode());
            taskCardDTO.setAppName(resp.getAppName());
            taskCardDTO.setHasAppPermission(resp.getHasAppPermission());
        }
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        String tenantId = StringUtils.isNotEmpty(taskCardDTO.getTargetTenantId()) ? taskCardDTO.getTargetTenantId() : taskCardDTO.getTenantId();
        log.info(" processed taskCard Data: {}", taskCardDTO);
        boolean flag = false;

        if (authoreUsertaskCardWhiteList) {
            flag = true;
            try {
                log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_补充任务卡配置_入参:taskCardDTO={}", JSON.toJSONString(taskCardDTO));
                backlogBatchQueryBusinessDataService.addDataFields(Collections.singletonList(taskCardDTO), authoredUser);
                log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_补充任务卡配置_出参:taskCardDTO={}", JSON.toJSONString(taskCardDTO));
            } catch (Exception ex) {
                log.error("add data fields failure: {}, :{}", ex.getMessage(), taskCardDTO.getBacklogId());
            }
        }

        if (!authoreUsertaskCardWhiteList && taskOnOff) {
            flag = true;
            try {
                log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_补充任务卡配置_入参:taskCardDTO={}", JSON.toJSONString(taskCardDTO));
                backlogBatchQueryBusinessDataService.addDataFields(Collections.singletonList(taskCardDTO), authoredUser);
                log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_补充任务卡配置_出参:taskCardDTO={}", JSON.toJSONString(taskCardDTO));
            } catch (Exception ex) {
                log.error("add data fields failure: {}, :{}", ex.getMessage(), taskCardDTO.getBacklogId());
            }
        }

        if (!flag && taskOnOffV2) {
            try {
                log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_补充任务卡配置V2_入参:taskCardDTO={},pageCode={}", JSON.toJSONString(taskCardDTO), "task-card");
                backlogBatchQueryBusinessDataService.addDataFieldsV2(Collections.singletonList(taskCardDTO), authoredUser, "task-card");
                log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_补充任务卡配置V2_出参:taskCardDTO={}", JSON.toJSONString(taskCardDTO));
            } catch (Exception ex) {
                log.error("add data fieldsV2 failure: {}, :{}", ex.getMessage(), taskCardDTO.getBacklogId());
            }
        }

        try {
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_设置BusinessMessage_入参:taskCardDTO={},pageCode={}", JSON.toJSONString(taskCardDTO), "task-card");
            backlogBatchQueryBusinessDataService.setBusinessMessage(taskCardDTO, authoredUser, PageCode.TASK_CARD.getValue());
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_设置BusinessMessage_出参:taskCardDTO={}", JSON.toJSONString(taskCardDTO));
        } catch (Exception ex) {
            log.error("set business message failure: {}, :{}", ex.getMessage(), taskCardDTO.getBacklogId());
        }
        //调用ptm获取卡片来源
        List<Long> taskCards = new ArrayList<>();
        taskCards.add(taskCardDTO.getBacklogId());
        List<PtmTaskCardITraceDTO> traceList = ptmService.queryTaskCardTrace(taskCards, authoredUser.getUserId());
        if (CollectionUtils.isNotEmpty(traceList)) {
            PtmTaskCardITraceDTO traceDTO = traceList.get(0);
            //设置卡片来源状态和人员信息、创建时间
            setSourceInfo(taskCardDTO, traceDTO);
        }
        MessageDO messageDO = new MessageDO();
        messageDO.setJsonContent(this.parseMessageJsonContent(taskCardDTO, targetUserId, tenantId, authoredUser.getToken()));
        messageDO.setCategory(operation.getMqttCategory());
        messageDO.setSendDate(LocalDateTime.now());
        messageDO.setGid(UUID.randomUUID().toString());
        messageDO.setTenantId(tenantId);
        messageDO.setUserId(targetUserId);
        messageDO.setType("Task");
        messageDO.setSubType(taskCardDTO.getTmActivityId());
        List<String> users = new ArrayList<>();
        users.add(targetUserId);
        log.info(" messageDo data: {}", messageDO);
        log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_发送消息给用户_入参:token={}, tenantId={}, userIdList={}, message={}", authoredUser.getToken(), tenantId, users, messageDO);
        aimService.sendMessageToClient(authoredUser.getToken(), tenantId, users, messageDO);
        log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_发送消息给用户_结束");

        log.info("【PtmTaskChangedSubscriber-sendmqtt-1】backlogId：{}，token：{}，tenantId：{}，users：{}，message：{}", taskCardDTO.getBacklogId(), authoredUser.getToken(), tenantId, users, JsonUtils.objectToString(messageDO));

        //获取代理用户
        ProxyUserResp proxyUserResp = eocService.getProxyUser(taskCardDTO.getOwnerUserId(), authoredUser.getToken());
        if (proxyUserResp != null && proxyUserResp.getUserId() != null) {
            // 应用授权信息
            VerifyAppPermissionResp proxyResp = getAppPermission(taskCardDTO.getBacklogId(), proxyUserResp.getUserId());
            if (null != resp) {
                taskCardDTO.setAppCode(proxyResp.getAppCode());
                taskCardDTO.setAppName(proxyResp.getAppName());
                taskCardDTO.setHasAppPermission(proxyResp.getHasAppPermission());
            }
            taskCardDTO.setIsOwner(false);
            users.clear();
            users.add(proxyUserResp.getUserId());
            messageDO.setJsonContent(this.parseMessageJsonContent(taskCardDTO, proxyUserResp.getUserId(), tenantId, authoredUser.getToken()));
            LogDto logDto = new LogDto("请求aim发送新消息给代理用户", tenantId);
            log.info(logDto.toString());
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_发送消息给代理人_入参:token={}, tenantId={}, userIdList={}, message={}", authoredUser.getToken(), tenantId, users, messageDO);
            aimService.sendMessageToClient(authoredUser.getToken(), tenantId, users, messageDO);
            log.debug("接收ptm消息_处理消息_PTM待办消息_event发送_PtmTaskChangeEvent_发送MQTT消息_发送消息给代理人_结束");
            log.info("【PtmTaskChangedSubscriber-sendmqtt-2】backlogId：{}，{}，tenantId：{}，users：{}，message：{}", taskCardDTO.getBacklogId(), authoredUser.getToken(), tenantId, users, messageDO);
        }
    }

    /**
     * 设置来源信息和状态
     *
     * @param taskCardDTO
     * @param traceDTO
     */
    private void setSourceInfo(TaskCardDTO taskCardDTO, PtmTaskCardITraceDTO traceDTO) {
        //设置来源信息和状态
        taskCardDTO.setOldPerformerId(traceDTO.getOldPerformerId());
        taskCardDTO.setOldPerformerName(traceDTO.getOldPerformerName());
        if (null != traceDTO.getCreateTime()) {
            taskCardDTO.setCreateTime(traceDTO.getCreateTime());
        }
        Integer type = traceDTO.getType();//ptm查询到的任务状态
        switch (type) {
            case 0://系统新增
                break;
            case 1://转派
                taskCardDTO.setReassign(true);
                break;
            case 2://退回重签
                taskCardDTO.setReexecute(true);
                break;
            case 3://退回重办
                taskCardDTO.setReexecute(true);
                break;
            case 4://加签
                taskCardDTO.setAddTask(true);
                break;
            case 9://撤回
                taskCardDTO.setRecall(true);
                break;
            case 10://交接
                taskCardDTO.setApprovalStateCode("handover");
                break;
            default:
                break;
        }
    }

    private VerifyAppPermissionResp getAppPermission(Long backlogId, String userId) {
        VerifyAppPermissionReq req = new VerifyAppPermissionReq();
        req.setType(VerifyAppPermissionEnum.TASK.getValue());
        req.setBusinessId(backlogId);
        req.setUserId(userId);
        return atmcService.verifyAppPermission(req);
    }

}
