package com.digiwin.athena.abt.application.service.abt.migration.ptm;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.dto.migration.abt.event.EventListenerDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.*;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.TaskWorkItemMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmSpecialBacklogDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.TaskWorkitemMessageHandler;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.utils.ActivityUtils;
import com.digiwin.athena.abt.core.meta.enums.EventMqTypeEnum;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.core.meta.enums.TmPageName;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskWorkitemMessageMapper;
import com.digiwin.athena.abt.application.utils.BacklogAbstractUtil;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskWorkitemMessage;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author wuzq
 * @Date 2023/6/29 15:22
 * @Description: 卡片处理类
 * @Version 1.0
 */
@Slf4j
@Service
public class PtmMqCardMessageService {

    public static final String PTM_BACKLOG = "ptmBacklog";
    public static final String ADD = "add";
    public static final String PTM_PROJECT = "ptmProject";

    @Autowired
    private TaskWorkitemMessageHandler taskWorkitemMessageHandler;

    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    @Autowired
    private TaskWorkitemMessageMapper taskWorkitemMessageMapper;

    @Autowired
    private PtmService ptmService;

    @Autowired
    private BacklogAbstractUtil backlogAbstractUtil;

    /**
     * 保存辅助执行者、跨租户的任务卡的业务数据
     *
     * @Author：SYQ
     * @Date：2022/11/11 10:34
     */
    public void processSpecialBacklogMessage(AuthoredUser user, String data) {
        PtmBacklogMessageDTO backlogMessageDTO = JsonUtils.jsonToObject(data, PtmBacklogMessageDTO.class);
        // 判断backlog是否已经入库，若没有则将消息重新放入mq内，防止backlog没入库查询失败
        PtmBacklogMessageDTO.Backlog backlog = backlogMessageDTO.getData().getBacklog();
        LogDto logDto = new LogDto("保存辅助执行者、跨租户的任务卡的摘要、资讯和搜索数据开始，卡片id：" + backlog.getBacklogId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + backlog.getBacklogId());
        log.info(logDto.toString());
        if (backlog != null && ptmBacklogMapper.selectById(backlog.getBacklogId()) == null) {
            throw BusinessException.create("backlog is null");
        }
        if (!PtmMqOperation.ADD.equals(backlogMessageDTO.getOperation())) {
            return;
        }
        // 如果任务卡类型为辅助执行者或者跨租户，则保存其业务数据信息
        if (backlog != null && (backlog.getType() == 1 || backlog.getType() == 2)) {
            log.info("PTM-saveSpecialBacklogMessage-backlog:{}", backlog);
            TaskWorkItemMessageDTO model = new TaskWorkItemMessageDTO();
            model.setCardType(PTM_BACKLOG);
            model.setWorkItemId(backlog.getWorkItemId());
            model.setCardId(backlog.getBacklogId());
            model.setActivityId(backlog.getActivityId());
            model.setTenantId(backlog.getTenantId());
            model.setAuthoredUser(user);
            log.info("PTM-saveSpecialBacklogMessage-model:{}", model);
            taskWorkitemMessageHandler.process(model);
        }
    }

    /**
     * 查询任务卡是否已存在message数据
     *
     * @Author：SYQ
     * @Date：2022/11/11 13:30
     */
//    private List<TaskWorkitemMessage> findMessage(Long backlogId, String tenantId) {
//        QueryWrapper<TaskWorkitemMessage> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("card_id", backlogId);
//        queryWrapper.eq("tenant_id", tenantId);
//        queryWrapper.eq("card_type", PTM_BACKLOG);
//        return taskWorkitemMessageMapper.selectList(queryWrapper);
//    }

    /**
     * 处理项目卡消息
     *
     * @param data
     * @param user
     */
    public void processProjectCardMessage(AuthoredUser user, String data) {

        PtmProjectCardMessageDTO ptmProjectCardMessageDTO = JsonUtils.jsonToObject(data, PtmProjectCardMessageDTO.class);
        PtmProjectCardDataDTO cardDataDTO = ptmProjectCardMessageDTO.getData();
        PtmProjectCardDTO cardDTO = cardDataDTO.getProjectCard();
        LogDto logDto = new LogDto("处理项目卡摘要、资讯和搜索数据开始，卡片id：" + cardDTO.getId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + cardDTO.getId());
        log.info(logDto.toString());
        TaskWorkItemMessageDTO model = new TaskWorkItemMessageDTO();
        model.setCardId(cardDTO.getId());
        model.setCardType(PTM_PROJECT);
//        model.setOptType(ADD);
        model.setAuthoredUser(user);
        taskWorkitemMessageHandler.process(model);
    }

    /**
     * 处理 PTM 项目卡和任务卡的业务数据
     *
     * @param data
     */
    public void processCardMessage(AuthoredUser user, String data) {
        PtmDataConsistencyMessageDTO message = ActivityUtils.convertPtmDataConsistencyMsg(data);
        try {
            PtmDataConsistencyMessageDTO.MqData mqData = message.getData();
            List<PtmDataConsistencyMessageDTO.WorkItem> workItemList = mqData.getWorkItem();
            log.info("PTM-saveBacklogMessage-workItem:{}", workItemList);
            if (CollectionUtils.isNotEmpty(workItemList)) {
                PtmDataConsistencyMessageDTO.WorkItem workItem = workItemList.get(0);
                LogDto logDto = new LogDto("处理任务卡摘要、资讯和搜索数据开始，卡片id：" + workItem.getBacklogId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + workItem.getBacklogId());
                log.info(logDto.toString());
                if(BooleanUtils.isTrue(mqData.getMinSplit()) && workItemList.size()>1){
                    log.info("处理最小化多个代办事项生成摘要开始");
                    processMinCardMessage(user,workItemList);
                    log.info("处理最小化多个代办事项生成摘要结束");
                    return;
                }
                TaskWorkItemMessageDTO model = createWorkItemMsg(user, workItem,null);
                log.info("PTM-saveBacklogMessage-model:{}", model);
                taskWorkitemMessageHandler.process(model);

                // 查询是否有辅助执行者或者跨租户的任务卡，更新其业务数据信息
                log.info("PTM-saveSpecialBacklogMessageByWorkitem-workItem:{}", workItem);
                saveSpecialBacklogMessageByWorkitem(user, workItem,null);
            }
        } catch (Exception e) {
            log.warn("PtmMqCardMessageServiceImpl-error:{}", e.getMessage());
        }

    }

    private void processMinCardMessage(AuthoredUser user,List<PtmDataConsistencyMessageDTO.WorkItem> workItemList){
        Map<Long,List<PtmDataConsistencyMessageDTO.WorkItem>> backLogToWorkItemList = Maps.newHashMap();
        for (PtmDataConsistencyMessageDTO.WorkItem workItem : workItemList) {
            List<PtmDataConsistencyMessageDTO.WorkItem> workItems = backLogToWorkItemList.computeIfAbsent(workItem.getBacklogId(), e -> new ArrayList<>());
            workItems.add(workItem);
        }
        backLogToWorkItemList.forEach((k,v)->{
            PtmDataConsistencyMessageDTO.WorkItem workItem = v.get(0);
            List<Long> workItemIds = v.stream().map(PtmDataConsistencyMessageDTO.WorkItem::getId).collect(Collectors.toList());
            TaskWorkItemMessageDTO model = createWorkItemMsg(user, workItem,workItemIds);
            log.info("PTM-saveBacklogMessage-model:{}", model);
            taskWorkitemMessageHandler.process(model);
            // 查询是否有辅助执行者或者跨租户的任务卡，更新其业务数据信息
            saveSpecialBacklogMessageByWorkitem(user, workItem,workItemIds);
        });
    }
    private TaskWorkItemMessageDTO createWorkItemMsg(AuthoredUser user,PtmDataConsistencyMessageDTO.WorkItem workItem,List<Long> workItemIds){
        TaskWorkItemMessageDTO model = new TaskWorkItemMessageDTO();
        // 查询任务卡是否已存在
        // 判断新增数据还是修改数据
        model.setCardType(PTM_BACKLOG);
        model.setWorkItemId(workItem.getId());
        model.setWorkItemIds(workItemIds);
        model.setCardId(workItem.getBacklogId());
        model.setAuthoredUser(user);
        model.setActivityId(workItem.getActivityId());
        return model;
    }

    /**
     * 推送workitem消息时，查询是否有辅助执行者或者跨租户的任务卡，更新其业务数据信息
     *
     * @Author：SYQ
     * @Date：2022/11/11 14:27
     */
    private void saveSpecialBacklogMessageByWorkitem(AuthoredUser user, PtmDataConsistencyMessageDTO.WorkItem workItem,List<Long> workItemIds) {
        //设置token
        AppAuthContext appAuthContext = new AppAuthContext();
        appAuthContext.setAuthoredUser(user);
        AppAuthContextHolder.setContext(appAuthContext);
        List<PtmSpecialBacklogDTO> specialBacklogList = new ArrayList<>();
        try{
            log.info("PTM-saveSpecialBacklogMessageByWorkitem-work_item_id:{}, user:{}", workItem.getId(), JsonUtils.objectToString(user));
             specialBacklogList = ptmService.getSpecialBacklog(Collections.singletonList(workItem.getId()));
            log.info("PTM-saveSpecialBacklogMessageByWorkitem-ptmBacklogList:{}", specialBacklogList);
        }
        catch (Exception e){
            log.warn(e.getMessage(), e);
        }
        finally {
            AppAuthContextHolder.clearContext();
            LocaleContextHolder.resetLocaleContext();
        }

        if (CollectionUtils.isEmpty(specialBacklogList)) {
            return;
        }
        for (PtmSpecialBacklogDTO ptmBacklog : specialBacklogList) {
            TaskWorkItemMessageDTO model = new TaskWorkItemMessageDTO();
            model.setCardType(PTM_BACKLOG);
            model.setWorkItemId(workItem.getId());
            model.setWorkItemIds(workItemIds);
            model.setCardId(ptmBacklog.getBacklogId());
            model.setTenantId(ptmBacklog.getTenantId());
            model.setAuthoredUser(user);
            log.info("PTM-saveSpecialBacklogMessageByWorkitem-model:{}", model);
            taskWorkitemMessageHandler.process(model);
        }
    }

    /**
     * 流程引擎任务卡
     * @param user
     * @param data
     */
    public void processFlowMessage(AuthoredUser user, String data) {
        try {
            TaskWorkItemMessageDTO model = JsonUtils.jsonToObject(data, TaskWorkItemMessageDTO.class);
            model.setAuthoredUser(user);
            log.info("FLOW-processFlowMessage-model:{}", model);
            String cardId = String.valueOf(model.getCardId() == null ? 0L : model.getCardId());
            LogDto logDto = new LogDto("处理流程引擎任务卡摘要、资讯和搜索数据开始，卡片id：" + cardId, user.getTenantId() + LogConstant.TRACE_SEPARATOR + cardId);
            log.info(logDto.toString());
            taskWorkitemMessageHandler.process(model);
        } catch (Exception e) {
            log.warn("FLOW-processFlowMessage-error:{}", e.getMessage());
        }

    }

    /**
     * 删除已关闭卡的BusinessMessage
     *
     * @param user         用户信息
     * @param data         mq消息
     * @param mqMessageDTO mq消息对象
     */
    public void removeCloseBusinessMessage(AuthoredUser user, String data, EventListenerDTO mqMessageDTO) {
        try {
            if (!PtmMqOperation.CLOSE.equals(mqMessageDTO.getOperation())) {
                return;
            }
            removeBusinessMessageInner(user, data, mqMessageDTO);
        } catch (Exception e) {
            log.warn("RemoveCloseBusinessMessage fail: {}", ExceptionUtil.getSimpleMessage(e));
        }
    }

    private void removeBusinessMessageInner(AuthoredUser user, String data, EventListenerDTO mqMessageDTO) {
        String pageCode;
        EventMqTypeEnum type = mqMessageDTO.getType();
        if (EventMqTypeEnum.projectCard.equals(type)) {
            pageCode = TmPageName.PROJECT_CARD_NAME.getValue();
            PtmProjectCardMessageDTO ptmProjectCardMessageDTO = JsonUtils.jsonToObject(data, PtmProjectCardMessageDTO.class);
            PtmProjectCardDataDTO cardDataDTO = ptmProjectCardMessageDTO.getData();
            PtmProjectCardDTO cardDTO = cardDataDTO.getProjectCard();
            backlogAbstractUtil.removeBusinessMessage(Lists.newArrayList(cardDTO.getId()), user.getTenantId(), pageCode);
        } else if (EventMqTypeEnum.backlog.equals(type)) {
            pageCode = TmPageName.TASK_CARD_NAME.getValue();
            PtmDataConsistencyMessageDTO message = ActivityUtils.convertPtmDataConsistencyMsg(data);
            PtmDataConsistencyMessageDTO.MqData mqData = message.getData();
            List<PtmDataConsistencyMessageDTO.WorkItem> workItemList = mqData.getWorkItem();
            if(CollectionUtils.isEmpty(workItemList)){
                Set<Long> cardIds = new HashSet<>();
                for (PtmDataConsistencyMessageDTO.WorkItem workItem : workItemList) {
                    cardIds.add(workItem.getBacklogId());
                }
                backlogAbstractUtil.removeBusinessMessage(cardIds, user.getTenantId(), pageCode);
            }
        }
    }

}
