package com.digiwin.athena.abt.application.service.abt.migration.ptm;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.dto.migration.abt.groupteam.*;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.*;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.*;
import com.digiwin.athena.abt.application.service.abt.migration.groupteam.TeamMemberService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.im.ImService;
import com.digiwin.athena.abt.core.meta.enums.ImTeamType;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivity;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.base.Joiner;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @Author wuzq
 * @Date 2023/7/11 15:42
 * @Description: ptm消息任务处理类
 * @Version 1.0
 */
@Service
@Slf4j
public class PtmMqGroupTeamService {

    @Autowired
    private PtmTaskDeleteGroupHandler ptmTaskDeleteGroupHandler;

    @Autowired
    private PtmProjectCardDeleteGroupHandler ptmProjectCardDeleteGroupHandler;

    @Autowired
    private PtmProjectCardCreateGroupHandler ptmProjectCardCreateGroupHandler;

    @Autowired
    private PtmBacklogCreateGroupHandler ptmBacklogCreateGroupHandler;

    @Autowired
    private PtmProjectUpdateImHandler ptmProjectUpdateImHandler;

    @Autowired
    private TeamMemberService teamMemberService;

    @Autowired
    private ImService imService;

    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    @Autowired
    private BacklogMapper backlogMapper;

    public void processTaskDeleteGroupMessage(String data, AuthoredUser user) {
        PtmMqTaskMessageDTO message = JsonUtils.jsonToObject(data, PtmMqTaskMessageDTO.class);
        PtmMqTaskMessageDTO.Task task = message.getData().getTask();
        LogDto logDto = new LogDto("处理删除群聊消息，taskId：" + task.getId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + task.getId());
        log.info(logDto.toString());
        PtmTaskDeleteGroupDTO model = new PtmTaskDeleteGroupDTO();
        BeanUtils.copyProperties(task, model);
        model.setOperation(message.getOperation());
        model.setAuthoredUser(user);
        ptmTaskDeleteGroupHandler.process(model);
    }

    public void processProjectCardGroupMessage(String data, AuthoredUser user) {
        PtmProjectCardMessageDTO message = JsonUtils.jsonToObject(data, PtmProjectCardMessageDTO.class);
        PtmProjectCardDataDTO cardDataDTO = message.getData();
        PtmProjectCardDTO cardDTO = cardDataDTO.getProjectCard();
        String cardId = String.valueOf(cardDTO == null ? 0L : cardDTO.getId());
        LogDto logDto = new LogDto("处理项目卡群聊消息，项目卡id：" + cardId, user.getTenantId() + LogConstant.TRACE_SEPARATOR + cardId);
        log.info(logDto.toString());
        PtmProjectCardGroupDTO model = new PtmProjectCardGroupDTO();
        BeanUtils.copyProperties(cardDTO, model);
        model.setAuthoredUser(user);
        model.setOperation(message.getOperation());
        model.setProject(cardDataDTO.getProject());
        model.setRelatedUsers(cardDataDTO.getRelatedUsers());
        model.setImBusinessKey(cardDataDTO.getImBusinessKey());
        if (PtmMqOperation.CLOSE.equals(message.getOperation())) {
            ptmProjectCardDeleteGroupHandler.process(model);
        } else if (PtmMqOperation.ADD.equals(message.getOperation())) {
            ptmProjectCardCreateGroupHandler.process(model);
        }

    }

    public void processTaskCreateGroupMessage(String data, AuthoredUser user) {

        PtmBacklogMessageDTO message = JsonUtils.jsonToObject(data, PtmBacklogMessageDTO.class);
        PtmBacklogMessageDTO.Backlog ptmBacklog = message.getData().getBacklog();
        String backlogId = String.valueOf(ptmBacklog.getBacklogId() == null ? 0L : ptmBacklog.getBacklogId());
        LogDto logDto = new LogDto("处理创建群聊消息，待办id：" + backlogId, user.getTenantId() + LogConstant.TRACE_SEPARATOR + backlogId);
        log.info(logDto.toString());
        QueryWrapper<PtmBacklog> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("task_id", ptmBacklog.getTaskId());
        boolean canCreateTaskTeam = ptmBacklogMapper.selectCount(queryWrapper) <= 1;

        PtmBacklogCreateGroupDTO model = new PtmBacklogCreateGroupDTO();
        BeanUtils.copyProperties(ptmBacklog, model);
        model.setAuthoredUser(user);
        model.setCanCreateTaskTeam(canCreateTaskTeam);
        model.setOperation(message.getOperation());
        ptmBacklogCreateGroupHandler.process(model);
    }

    public void processFlowProjectCardGroupMessage(String data, AuthoredUser user) {
        PtmProjectCardGroupDTO message = JsonUtils.jsonToObject(data, PtmProjectCardGroupDTO.class);
        if (PtmMqOperation.CLOSE.equals(message.getOperation())) {
            removeFlowProjectCardGroup(user, message);
        } else if (PtmMqOperation.ADD.equals(message.getOperation())) {
            createFlowProjectCardGroup(user, message);
        }
    }

    private void createFlowProjectCardGroup(AuthoredUser user, PtmProjectCardGroupDTO message) {
        log.info("【createFlowProjectCardGroup】：{}", message);

        try {
            AppAuthContextHolder.clearContext();

            Task task = Task.builder()
                    .id(message.getId())
                    .mainTaskId(message.getMainTaskId())
                    .name(message.getName())
                    .startTime(message.getStartTime())
                    .endTime(message.getEndTime())
                    .personInCharge(message.getPersonInCharge())
                    .build();
            if (Boolean.FALSE.equals(message.getHasMainTask())) {
                teamMemberService.createTaskTeam(task, user, message.getRelatedUsers(), message.getBusinessKey());
            } else {//新增子流程，向已创建的项目群内添加成员
                teamMemberService.updateTeamMemberByFlow(task, user, message.getRelatedUsers());
            }
        } catch (Exception ex) {
            log.warn("流程引擎项目卡创建时,创建IM项目群 error:{}, stack:{}，event:{}", ex, ex.getStackTrace(), message);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void removeFlowProjectCardGroup(AuthoredUser user, PtmProjectCardGroupDTO message) {
        log.info("【removeFlowProjectCardGroup】：{}", message);
        try {
            AppAuthContextHolder.clearContext();

            //解散项目群
            imService.removeTeam(message.getId().toString(), 1, user);
            //解散pcc任务群
            log.info("解散项目群时解散pcc任务群：{}", message.getBusinessKey());
            if (StringUtils.isNotEmpty(message.getBusinessKey())) {
                imService.removeTeamByParam("", 2, "", message.getBusinessKey(), user);
            }
            //解散平台任务群
            List<String> bpmActivityIdIdList = backlogMapper.selectByBpmProcessSqlId(message.getBpmProcessId());
            if (CollUtil.isNotEmpty(bpmActivityIdIdList)) {
                for (String bpmActivityId : bpmActivityIdIdList) {
                    imService.removeTeam(bpmActivityId, 2, user);
                }
            }
            LogDto logDto = new LogDto("流程引擎项目卡结束时,解散IM项目群成功，流程id" + message.getBpmProcessId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + message.getBpmProcessId());
            log.info(logDto.toString());
        } catch (Exception ex) {
            log.warn("流程引擎项目卡结束时,解散IM项目群 error:{}, stack:{}，event:{}", ex, ex.getStackTrace(), message);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }

    public void processFlowBacklogGroupMessage(String data, AuthoredUser user) {
        EventFlowBacklogGroupDTO model = JsonUtils.jsonToObject(data, EventFlowBacklogGroupDTO.class);
        if (PtmMqOperation.CLOSE.equals(model.getOperation())) {
            removeFlowBacklogGroup(user, model);
        } else if (PtmMqOperation.ADD.equals(model.getOperation())) {
            createFlowBacklogGroup(user, model);
        }
    }

    private void createFlowBacklogGroup(AuthoredUser user, EventFlowBacklogGroupDTO model) {
        log.info("【createFlowBacklogGroup】：{}", model);
        try {
            AppAuthContextHolder.clearContext();

            if (model.getNeedCreateTeam()) {
                teamMemberService.addBpmActivityTeamMember(user, model.getBpmActivitySqlId(), model.getWorkitemList().stream().map(BpmActivityWorkitem::getPerformerId).collect(Collectors.toList()));
            } else {
                BpmActivity bpmActivity = new BpmActivity();
                bpmActivity.setId(model.getBpmActivitySqlId());
                bpmActivity.setTmActivityName(model.getTmActivityName());
                bpmActivity.setPlanEndTime(model.getPlanEndTime());
                teamMemberService.createBpmActivityTeam(bpmActivity, model.getIsBpmActivityStepEmpty(), model.getWorkitemList(),
                        user, model.getRelatedUserList(), model.getIsExternal(),
                        model.getPlan(), model.getTenantSid(), model.getTenantName(), model.getBusinessKey());
            }
        } catch (Exception ex) {
            log.warn("流程引擎任务卡创建时,创建IM项目群 error:{}, stack:{}，event:{}", ex, ex.getStackTrace(), model);
        } finally {
            AppAuthContextHolder.clearContext();
        }

    }

    /**
     * 解散任务群
     *
     * @param user
     * @param model
     */
    private void removeFlowBacklogGroup(AuthoredUser user, EventFlowBacklogGroupDTO model) {
        log.info("【removeFlowBacklogGroup】：{}", model);
        try {
            AppAuthContextHolder.clearContext();

            //获取pcc的任务群
            Map teamMap = null;
            if (StringUtils.isNotEmpty(model.getBusinessKey())) {
                teamMap = imService.getTeamInfo(user, model.getBusinessKey(), ImTeamType.TaskTeam.getValue(), "pcc");
            }
            //若能找到pcc的任务群，则在cardIds中关于当前卡片的bpmActivityId删掉；若找不到pcc的任务群，说明是平台的任务正常结束，则解散对应的任务群
            if (teamMap != null) {
                String cardIds = (teamMap.get("cardIds") != null) ? teamMap.get("cardIds").toString() : "";
                if (StringUtils.isNotEmpty(cardIds)) {
                    List<String> cardIdsList = Stream.of(cardIds.split(",")).collect(Collectors.toList());
                    String bpmActivityId = String.valueOf(model.getBpmActivitySqlId());
                    cardIdsList.remove(bpmActivityId);
                    String newCardIds = Joiner.on(",").join(cardIdsList);
                    String tId = teamMap.get("tId").toString();
                    imService.updateTeamInfo(user, tId, newCardIds);
                    LogDto logDto = new LogDto("流程引擎任务卡结束时,更新IM项目群成功，bpmActivitySqlId" + model.getBpmActivitySqlId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + model.getBpmActivitySqlId());
                    log.info(logDto.toString());
                }
            } else {
                imService.removeTeam(model.getBpmActivitySqlId().toString(), ImTeamType.TaskTeam.getValue(), user);
                LogDto logDto = new LogDto("流程引擎任务卡结束时,解散IM项目群成功，bpmActivitySqlId" + model.getBpmActivitySqlId(), user.getTenantId() + LogConstant.TRACE_SEPARATOR + model.getBpmActivitySqlId());
                log.info(logDto.toString());
            }
        } catch (Exception ex) {
            log.warn("流程引擎任务卡结束时,解散IM项目群 error:{}, stack:{}，event:{}", ex, ex.getStackTrace(), model);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }

    public void processProjectGroupMessage(String data, AuthoredUser user) {
        PtmProjectMessageDTO message = JsonUtils.jsonToObject(data, PtmProjectMessageDTO.class);
        PtmProjectDTO projectDTO = message.getData().getProject();
        LogDto logDto = new LogDto("处理项目群聊消息，项目id：" + projectDTO.getId(), user.getTenantId() + projectDTO.getId());
        log.info(logDto.toString());
        PtmProjectGroupDTO model = new PtmProjectGroupDTO();
        model.setAuthoredUser(user);
        model.setOperation(message.getOperation());
        model.setRelatedUsers(message.getData().getRelatedUsers());
        model.setProject(projectDTO);
        ptmProjectUpdateImHandler.process(model);
    }

    public void processFlowProjectGroupMessage(String data, AuthoredUser user) {
        PtmProjectCardGroupDTO message = JsonUtils.jsonToObject(data, PtmProjectCardGroupDTO.class);
        log.info("【FlowProjectGroup】：{}", message);
        try {
            AppAuthContextHolder.clearContext();

            Task task = Task.builder()
                    .id(message.getId())
                    .build();
            teamMemberService.transferTaskMemeber(user, task, message.getRelatedUsers());
            LogDto logDto = new LogDto("流程引擎项目添加群成员成功：" + message.getMainTaskId(), user.getTenantId() + message.getMainTaskId());
            log.info(logDto.toString());
        } catch (Exception ex) {
            log.warn("流程引擎项目添加群成员 error:{}, stack:{}，event:{}", ex, ex.getStackTrace(), message);
        } finally {
            AppAuthContextHolder.clearContext();
        }
    }
}
