package com.digiwin.athena.abt.application.service.abt.migration.ptm;

import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.TaskCardDTO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Route;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;

/**
 * @author lzw
 * @date 2024/4/26
 * @description:
 **/
public interface PtmTransformService {

    /**
     * 获取 PTM 项目或项目卡并 转换为 ATMC 项目
     * @param id
     * @return
     */
    Task translateProjectOrProjectCard(Long id);

    /**
     * 是否启用了PTM
     * @return
     */
    boolean enablePTM();

    /**
     * 获取项目中的任意一条路线
     * @param projectId
     * @return
     */
    Route getRouteByProjectId(Long projectId);

    /**
     * 任务MQTT专用方法
     * @param backlog
     * @return
     */
    TaskCardDTO translateBacklogForMQTT(PtmBacklog backlog);
}
