package com.digiwin.athena.abt.application.service.abt.migration.ptm;

import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.Map;

/**
 * @author lzw
 * @date 2024/4/26
 * @description:
 **/
public interface SendMessageService {
    /**
     * 发送强提醒-MQTT
     *
     * @Author：SYQ
     * @Date：2022/4/11 15:08
     */
    void sendMessageRemindToClient(String token, String tenantId, String userId, AppMessageDTO appMessageDTO);

    /**
     * 发送弱提醒-工作提醒
     *
     * @param authoredUser
     * @param message
     */
    void saveNewMessage(AuthoredUser authoredUser, MessageDO message);


    /**
     * 消息中心根据配置发送消息(web app email sms dingtalk weCom)
     * @param tenantId
     * @param appCode
     * @param data
     */
    void sendMsg4AllChannel(String token, String tenantId, String appCode, String sceneId, Map<String, Object> data);


    /**
     *  App 消息推波
     *
     * @param authoredUser
     * @param message
     */
    void sendToAppClient(AuthoredUser authoredUser, MessageDO message);

}
