package com.digiwin.athena.abt.application.service.abt.migration.ptm.impl;

import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageReceiverDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eoc.ProxyUserResp;
import com.digiwin.athena.abt.application.dto.migration.atmc.iam.UserDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.MqDataRemindService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.SendMessageService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.BacklogMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.ActivityDefine;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.ActivityDefineNewMapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lzw
 * @date 2024/4/28
 * @description:
 **/
@Service
@Slf4j
public class MqDataRemindServiceImpl implements MqDataRemindService {

    @Autowired
    private SendMessageService sendMessageService;

    @Autowired
    EocService eocService;

    @Autowired
    MessageUtils messageUtils;

    @Autowired
    UserService userService;

    @Autowired
    private PtmService ptmService;

    @Autowired
    BacklogMapper backlogMapper;

    @Autowired
    ActivityDefineNewMapper activityDefineNewMapper;

    @Override
    public void sendTaskChargerNewBacklog(Backlog backlog, Task task, AuthoredUser authoredUser) {
        log.info("【sendTaskChargerNewBacklog-start-task：{}】：",task);
        LogDto logDto = new LogDto("PTM任务实时工作提醒，发送消息给当责者，待办Id：" + backlog.getId(), authoredUser.getTenantId() + LogConstant.TRACE_SEPARATOR + backlog.getId());
        log.info(logDto.toString());
        UserDTO userDTO =  this.getTargetUser(task.getPersonInCharge(),authoredUser);
        if (userDTO ==null){
            return;
        }
        log.info("【sendTaskChargerNewBacklog-userDTO：{}】：",userDTO);
        String langName = userService.getUserLangMetadataAllTenant(userDTO.getId(), authoredUser.getToken());
        if(StringUtils.isEmpty(langName)){
            langName = "zh_TW";
        }
        log.info("【sendTaskChargerNewBacklog-langName：{}】：",langName);
        boolean isSendMsg= false;

        if((task.getImportance() >0 || task.getEmergency() >0) ){
            isSendMsg =true;
        }
//        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy/MM/dd");
//        SimpleDateFormat simpleDateFormat1=new SimpleDateFormat("MM/dd");
        String title= String.format("%s~%s%s", TimeUtils.format(task.getStartTime(),"yyyy/MM/dd"),TimeUtils.format(task.getEndTime(),"MM/dd"), MessageUtils.getMessageByLanguage(task.getTargetName(), langName));

        String msg = String.format("%s "+messageUtils.getMessageByLangName("backlog.status.executing",langName),  MessageUtils.getMessageByLanguage(backlog.getContentWithName(), langName));
        AppMessageDTO appMessageDTO = new AppMessageDTO();
        appMessageDTO.setSource("athena");
        appMessageDTO.setTitle( title);
        appMessageDTO.setType("task");

        appMessageDTO.setSubType(task.getTmTaskId());
        appMessageDTO.setAuthoredUser(authoredUser);
        appMessageDTO.setTask(task);
        appMessageDTO.setBacklog(backlog);
        appMessageDTO.setTargetUser(userDTO);
        appMessageDTO.setPush(isSendMsg);
        appMessageDTO.setCategoryKey("MessageCenter");
        appMessageDTO.setCreatorName("Athena");
        appMessageDTO.setDetailUrl("offline://detail/" + task.getId()); // 为啥塞入项目卡id
        appMessageDTO.setMsg(msg);
        Map<String,Object> map = new HashMap<>();
        map.put("id", task.getId().toString());
        map.put("title", title);
        map.put("startTime", task.getStartTime());
        map.put("endTime", task.getEndTime());
        map.put("name",  MessageUtils.getMessageByLanguage(task.getTargetName(), langName));
        map.put("msg",  msg);
        map.put("status",  0);
        appMessageDTO.setContent(map);
        AppMessageReceiverDTO appMessageReceiverDTO = new AppMessageReceiverDTO();
        appMessageReceiverDTO.setTenantSid(authoredUser.getTenantSid());
        appMessageReceiverDTO.setTenantId(authoredUser.getTenantId());
        appMessageReceiverDTO.setUserSid(userDTO.getSid());
        appMessageReceiverDTO.setUserId(userDTO.getId());

        List<AppMessageReceiverDTO> receiverList = new ArrayList<>();
        receiverList.add(appMessageReceiverDTO);
        appMessageDTO.setReceivers(receiverList);
        appMessageDTO.setEmailPush(Boolean.FALSE);
        log.info("【sendTaskChargerNewBacklog-appMessageDTO：{}】：",appMessageDTO);
        //发送WEB APP消息
        sendMessageService.sendMessageRemindToClient(authoredUser.getToken(),authoredUser.getTenantId(),userDTO.getId(),appMessageDTO);
    }

    @Override
    public void sendPerformerNewBacklog(Backlog backlog, Task task, AuthoredUser authoredUser) {
        LogDto logDto = new LogDto("PTM任务实时工作提醒，发送消息给执行者，待办Id：" + backlog.getId(), authoredUser.getTenantId() + LogConstant.TRACE_SEPARATOR + backlog.getId());
        log.info(logDto.toString());
        UserDTO userDTO =  this.getTargetUser(backlog.getPerformerId(),authoredUser);
        if (userDTO ==null){
            return;
        }
        String langName = userService.getUserLangMetadataAllTenant(userDTO.getId(), authoredUser.getToken());
        if(StringUtils.isEmpty(langName)){
            langName = "zh_TW";
        }
        log.info("【sendPerformerNewBacklog-langName：{}】：",langName);
        boolean isSendMsg= false;

        if(backlog.getImportance() >0 ){
            isSendMsg =true;
        }
        ActivityDefine activityDefine = activityDefineNewMapper.selectByBacklogId(backlog.getId());
        String subType = (activityDefine != null) ? activityDefine.getTmActivityId() : backlog.getActivityCode();
        String msg="";
        String backlogName = MessageUtils.getMessageByLanguage(!StringUtils.isEmpty(backlog.getWithName())?backlog.getWithName():backlog.getName(), langName);
        if (backlog.getImportance() > 0 ) {
            msg = String.format(messageUtils.getMessageByLangName("backlog.remind",langName), MessageUtils.getMessageByLanguage(backlogName, langName));
        } else {
            msg = String.format(messageUtils.getMessageByLangName("backlog.new",langName), MessageUtils.getMessageByLanguage(backlogName, langName));
        }
//        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy/MM/dd");
//        SimpleDateFormat simpleDateFormat1=new SimpleDateFormat("MM/dd");
        String title= String.format("%s~%s%s", TimeUtils.format(task.getStartTime(),"yyyy/MM/dd"),TimeUtils.format(task.getEndTime(),"MM/dd"), MessageUtils.getMessageByLanguage(task.getTargetName(), langName));

        //发送消息
        AppMessageDTO appMessageDTO = new AppMessageDTO();
        appMessageDTO.setSource("athena"); //目前固定义athena
//        String backlogName =MessageUtils.getMessageByLanguage(backlog.getName(), langName);
        appMessageDTO.setTitle(title);
        appMessageDTO.setType("activity");
        appMessageDTO.setPush(isSendMsg);
        appMessageDTO.setSubType(subType);
        appMessageDTO.setAuthoredUser(authoredUser);
        appMessageDTO.setTask(task);
        appMessageDTO.setTargetUser(userDTO);
        appMessageDTO.setBacklog(backlog);

        //历史发邮件是用backlog表的id来拼id，但是最新的已经是用workItem表的id
        Map mainWorkItem = backlogMapper.getBacklogDetail4BacklogId(backlog.getId(),true);
        Object backlogId = (mainWorkItem != null) ? mainWorkItem.get("id") : backlog.getId();
        Map<String,Object>  map = new HashMap<>();
        map.put("id",backlogId);
        map.put("title", backlogName);
        map.put("startTime", backlog.getStartTime());
        map.put("endTime", backlog.getEndTime());
        map.put("name",  MessageUtils.getMessageByLanguage(task.getTargetName(), langName));
        map.put("status",  0);
        map.put("msg", msg);
        appMessageDTO.setContent(map);
        AppMessageReceiverDTO appMessageReceiverDTO = new AppMessageReceiverDTO();
        appMessageReceiverDTO.setTenantSid(authoredUser.getTenantSid());
        appMessageReceiverDTO.setTenantId(authoredUser.getTenantId());
        appMessageReceiverDTO.setUserSid(userDTO.getSid());
        appMessageReceiverDTO.setUserId(userDTO.getId());

        List<AppMessageReceiverDTO> receiverList = new ArrayList<>();
        receiverList.add(appMessageReceiverDTO);
        appMessageDTO.setReceivers(receiverList);
        appMessageDTO.setEmailPush(Boolean.FALSE);
        //发送WEB APP消息
        sendMessageService.sendMessageRemindToClient(authoredUser.getToken(),authoredUser.getTenantId(),userDTO.getId(),appMessageDTO);
    }

    private UserDTO getTargetUser(String userId, AuthoredUser authoredUser) {
        return getTargetUser(userId, authoredUser.getToken());
    }

    private UserDTO getTargetUser(String userId, String token) {
        UserDTO targetUser = null;
        ProxyUserResp proxyUserResp = eocService.getProxyUser(userId, token);
        if (proxyUserResp != null
                && StringUtils.hasText(proxyUserResp.getUserId())) {

            targetUser = userService.query(proxyUserResp.getUserId(), token);
        }
        if (targetUser == null) {
            targetUser = userService.query(userId, token);
        }
        return targetUser;
    }
}
