package com.digiwin.athena.abt.application.service.abt.migration.ptm.impl;

import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.PtmBackLogMsgDto;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.PtmTaskTimelyMsgDto;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.WorkItemMessageDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.MqDataRemindService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.MqManageMsgService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.SendMessageService;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.WorkItemMessageService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.eoc.EocService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.core.meta.enums.PtmMqOperation;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmWorkItemRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Backlog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Task;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.MessageUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;


/**
 * @author lzw
 * @date 2024/4/26
 * @description:
 **/
@Service
@Slf4j
public class MqManageMsgServiceImpl implements MqManageMsgService {

    @Autowired
    private SendMessageService sendMessageService;

    @Autowired
    EocService eocService;

    @Autowired
    MessageUtils messageUtils;

    @Autowired
    UserService userService;

    @Autowired
    private PtmService ptmService;

    @Autowired
    private MqDataRemindService mqDataRemindService;

    @Autowired
    private WorkItemMessageService workItemMessageService;




//    @Autowired
//    ActivityDefineMapper activityDefineMapper;

    @Override
    public void excuteSendTaskTimelyRemindMsg(PtmTaskTimelyMsgDto ptmTaskTimelyMsgDto) {

        AuthoredUser authoredUser = ptmTaskTimelyMsgDto.getAuthoredUser();
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);

        Backlog backlog = ptmTaskTimelyMsgDto.getBacklog();
//        log.info("【PtmTaskTimelyRemindMsgSubscriber】：{}",ptmTaskTimelyMsgDto);
        Task task = ptmTaskTimelyMsgDto.getTask();
        if (task == null || backlog == null) {
            log.info("数据异常，mqtt发送消息失败");
            return;
        }

        //当是重要、紧急任务的时候，发送消息给当责者
        mqDataRemindService.sendTaskChargerNewBacklog(backlog, task, authoredUser);
        //PTM任务实时工作提醒，发送消息给执行者
        mqDataRemindService.sendPerformerNewBacklog( backlog, task,authoredUser);


    }

    @Override
    public void excutesendBackLogRemindMsg(PtmBackLogMsgDto ptmBackLogMsgDto) {
        if (ptmBackLogMsgDto == null || ptmBackLogMsgDto.getAuthoredUser() == null || ptmBackLogMsgDto.getBacklog() == null
                || (!PtmMqOperation.ADD.equals(ptmBackLogMsgDto.getOperation()))) {
            return;
        }

        AuthoredUser authoredUser = ptmBackLogMsgDto.getAuthoredUser();
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        log.info("[send new backlog message]");

        PtmBacklogMessageDTO.Backlog backlog = ptmBackLogMsgDto.getBacklog();

        PtmProjectRecordBO projectRecordDTO = ptmService.getProjectRecord(backlog.getProjectId());

        String projectName = StringUtils.isNotEmpty(projectRecordDTO.getProjectName()) ? projectRecordDTO.getProjectName() : projectRecordDTO.getProjectDefName();
        String backlogId = String.valueOf(backlog.getBacklogId() == null ? 0L : backlog.getBacklogId());
        LogDto logDto = new LogDto("PTM 待办创建/关闭后，处理给执行者发送的消息，待办Id：" + backlogId, authoredUser.getTenantId() + LogConstant.TRACE_SEPARATOR + backlogId);
        log.info(logDto.toString());

        WorkItemMessageDTO.Project project = WorkItemMessageDTO.Project.builder()
                .projectId(backlog.getProjectId())
                .projectCardId(backlog.getProjectCardId())
                .projectDefCode(projectRecordDTO.getProjectDefCode())
                .name(projectName)
                .startTime(projectRecordDTO.getStartTime())
                .endTime(projectRecordDTO.getEndTime())
                .emergency(projectRecordDTO.getEmergency())
                .personInCharge(projectRecordDTO.getPersonInCharge())
                .personInChargeName(projectRecordDTO.getPersonInChargeName())
                .engineType(projectRecordDTO.getEngine())
                .build();

        PtmTaskRecordBO taskRecordDTO = ptmService.getTaskRecord(backlog.getTaskId(),null);
        String backlogName = StringUtils.isNotBlank(taskRecordDTO.getTaskName()) ? taskRecordDTO.getTaskName() : taskRecordDTO.getTaskDefName();
        if(ptmBackLogMsgDto.isMinSplit() && StringUtils.isNotBlank(backlog.getName())){
            backlogName = backlog.getName();
        }
        WorkItemMessageDTO.Task task = WorkItemMessageDTO.Task.builder()
                .taskName(backlogName)
                .createTime(taskRecordDTO.getCreateTime())
                .planEndTime(taskRecordDTO.getPlanEndTime())
                .tmActivityId(taskRecordDTO.getTaskDefCode())
                .tmActivityName(taskRecordDTO.getTaskDefName())
                .hasException(taskRecordDTO.getHasException())
                .build();

        PtmWorkItemRecordBO workItemRecordDTO = ptmService.getWorkItemRecord(ptmBackLogMsgDto.getWorkItemId());
        WorkItemMessageDTO.WorkItem workItem = WorkItemMessageDTO.WorkItem.builder()
                .id(backlog.getBacklogId())
                .workItemId(ptmBackLogMsgDto.getWorkItemId())
                .performerId(backlog.getPerformerId())
                .performerName(backlog.getPerformerName())
                .createType(workItemRecordDTO.getCreateType())
                .fromWorkItemId(workItemRecordDTO.getFromWorkItemId())
                .build();

        WorkItemMessageDTO messageDTO = WorkItemMessageDTO.builder()
                .project(project)
                .minSplit(ptmBackLogMsgDto.isMinSplit())
                .task(task)
                .backlog(backlog)
                .workItemList(Collections.singletonList(workItem))
                .messageType(ptmBackLogMsgDto.getMessageType())
                .build();

        workItemMessageService.sendWorkItemMessage(messageDTO, authoredUser);


    }

}
