package com.digiwin.athena.abt.application.service.abt.migration.ptm.impl;

import com.digiwin.athena.abt.application.dto.migration.atmc.emc.AppMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.message.MessageDO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.SendMessageService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.AimService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.iam.UserService;
import com.digiwin.athena.abt.application.utils.NoticeMessageUtil;
import com.digiwin.athena.abt.core.meta.enums.EmailTemplateStateEnum;
import com.digiwin.athena.abt.core.meta.enums.TypeEnum;
import com.digiwin.athena.abt.core.meta.enums.message.CategoryEnum;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.EmailMapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author lzw
 * @date 2024/4/26
 * @description:
 **/
@Slf4j
@Service
public class SendMessageServiceImpl implements SendMessageService {

    private static final Logger logger = LoggerFactory.getLogger(SendMessageServiceImpl.class);

    @Autowired
    private UserService userService;

    @Autowired
    private NoticeMessageUtil noticeMessageUtil;

    @Autowired
    private AimService aimService;

    @Autowired
    private EmailMapper emailMapper;

    /**
     * 发送消息提醒
     *
     * @Author：SYQ
     * @Date：2022/4/11 15:08
     */
    @Override
    public void sendMessageRemindToClient(String token, String tenantId, String userId, AppMessageDTO appMessageDTO) {
        try {
            if (BooleanUtils.isTrue(appMessageDTO.getEmailPush())) {
                noticeMessageUtil.sendRemindNotice(appMessageDTO);
            }
        } catch (Exception e) {
            logger.warn("notice remind with sendMessageRemindToClient error", e);
        }

        boolean doNotDisturb = userService.getMessageDoNotDisturbUserId(userId, tenantId, token);
        if (doNotDisturb) {
            appMessageDTO.setPush(false);
        }
        aimService.sendMsgRemindToClient(token, tenantId, userId, appMessageDTO);
    }

    @Override
    public void saveNewMessage(AuthoredUser authoredUser, MessageDO message) {
        if (null == message.getState()) {
            message.setState(0);
        }
        // 默认发送通知给移动端APP
        if (null == message.getNoticeMobileApp()) {
            message.setNoticeMobileApp(true);
        }

        try {
            //检查用户是否设置了通过im或者mail接收消息提醒
            int checkResult = noticeMessageUtil.checkSendType(authoredUser.getTenantSid(), message.getUserId());
            logger.info("user set notice message with checkResult.{}", checkResult);
            if (checkResult != 0) {
                // 校验是否需要发送邮件 (如果邮件管理该任务已配置，则无需发送)
                if(checkWheatherSendEmail(authoredUser, message)){
                    noticeMessageUtil.sendNoticeWithMail(authoredUser, message);
                }
                //如果是仅发送邮件，则不需要再走im消息通知
                if (checkResult == 1) return;
            }
        } catch (Exception e) {
            //吃掉异常，防止因为消息提醒导致流程中断
            logger.warn("send message to user error.message content:{}", message, e);
        }
        logger.info("atmc产生im提醒:{}", message);

        aimService.message(authoredUser, message);
    }

    @Override
    public void sendMsg4AllChannel(String token, String tenantId, String appCode, String sceneId, Map<String, Object> data) {
        aimService.sendMsg4AllChannel(token,tenantId,appCode,sceneId,data);
    }

    @Override
    public void sendToAppClient(AuthoredUser authoredUser, MessageDO message) {
        aimService.sendToAppClient(authoredUser,message);
    }


    /**
     * 校验是否需要发送邮件 (如果该任务在邮件管理有配置，则不发平台邮件）
     * @param authoredUser
     * @param message
     * @return
     */
    private Boolean checkWheatherSendEmail(AuthoredUser authoredUser, MessageDO message){
        // 如果是任务新增，则需要判断该任务是否有配置邮件管理
        if(TypeEnum.ACTIVITY.getValue().equals(message.getType()) && CategoryEnum.NEW.name().equals(message.getCategory())){
            // 查询邮件管理
            Integer num = emailMapper.selectTemplatesNum(authoredUser.getTenantId(), EmailTemplateStateEnum.INUSE.getValue(),message.getSubType());
            log.info("selectTemplatesNum:{}", num);
            if(num > 0){
                // 该任务在邮件管理有配置，则不发平台邮件
                return false;
            }
        }
        return true;
    }

}
