package com.digiwin.athena.abt.application.service.abt.migration.ptm.impl;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.abt.application.dto.migration.abt.task.SharingTaskDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.share.dao.ShareCodeDao;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.ShareService;
import com.digiwin.athena.abt.application.service.atmc.migration.tenantToken.TenantTokenService;
import com.digiwin.athena.abt.application.utils.RandomUtil;
import com.digiwin.athena.abt.core.meta.constants.SharingTaskConstant;
import com.digiwin.athena.abt.core.meta.enums.SharingTaskTypeEnum;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import java.util.Locale;

import static com.digiwin.athena.abt.core.meta.constants.RedisKeyPrefixConstant.SHARING_CODE_CACHE_KEY_PREFIX;


@Service
public class ShareServiceImpl implements ShareService {


    @Autowired
    private TenantTokenService tenantTokenService;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private ShareCodeDao shareCodeDao;

    /**
     * 分享码有效期，默认为{@link SharingTaskConstant#SHARING_CODE_TTL}小时
     */
    @Value("${athena.sharingCode.ttl" + ":" + SharingTaskConstant.SHARING_CODE_TTL + "}")
    private long sharingCodeTtl;

    @Override
    public String createSharingCode(AuthoredUser authoredUser, String taskType, Long taskId) {
        // 检查taskType值是否正确
        SharingTaskTypeEnum.checkTaskTypeWithException(taskType);
        // 获取当前用户Token
        String token = authoredUser.getToken();
        SharingTaskDTO sharingTaskDTO = SharingTaskDTO.builder()
                .proxyToken(tenantTokenService.queryVirtualToken(authoredUser.getTenantId()))
                .taskType(taskType.toUpperCase(Locale.UK))
                .taskId(taskId)
                .build();
        // 生成分享码
        String sharingCode = shareCodeDao.addShareCodeCache(JsonUtils.objectToString(sharingTaskDTO), sharingCodeTtl,
                SharingTaskConstant.SHARING_CODE_TTL_TIME_UNIT);
        String proxyToken = AppAuthContextHolder.getContext().getProxyToken();
        //修改bug 15995 【E10 TEST 区】从mail里链接过去用供应商账号登录后，复制分享链接再打开链接就报错
        if(StringUtils.isNotBlank(proxyToken))
        {
            sharingCode = sharingCode + "&proxyToken=" + proxyToken;

        }
        return sharingCode;
    }

    @Override
    public String getShareCodeCache(String sharingCode) {
        return stringRedisTemplate.opsForValue().get(SHARING_CODE_CACHE_KEY_PREFIX + sharingCode);
    }
}
