package com.digiwin.athena.abt.application.service.abt.migration.quartz;

import com.digiwin.athena.abt.application.dto.migration.abt.quartz.CronSchedulerJob;
import org.quartz.Trigger;

import java.util.Map;

/**
 * JobManager Description
 *
 * @author majianfu
 * @date 2023/3/30
 * @since
 */
public interface JobManager {
    /**
     * 创建cron定时任务
     *
     * @param job
     */
    void createCronJob(CronSchedulerJob job);

    /**
     * 创建cron定时任务
     *
     * @param job
     * @param replace 若任已存在，是否替换
     */
    void createCronJob(CronSchedulerJob job, boolean replace);

    /**
     * 移除任务
     *
     * @param jobName
     * @param jobGroup
     * @return
     */
    boolean deleteJob(String jobName, String jobGroup);

    /**
     * 获取已存在任务的trigger
     *
     * @param jobName
     * @param <T>
     * @return
     */
    <T extends Trigger> T getJobTrigger(String jobName);

    /**
     * 检查任务是否存在
     *
     * @param jobName
     * @param jobGroup
     * @return
     */
    boolean exist(String jobName, String jobGroup);

    /**
     *  暂停任务
     * @param jobName
     * @param jobGroup
     */
    void pauseScheduleJob(String jobName, String jobGroup);

    /**
     * 恢复定时任务
     * @param jobName
     * @param jobGroup
     */
    void resumeScheduleJob(String jobName, String jobGroup);

    /**
     * 立即执行任务
     * @param jobName
     * @param jobGroup
     */
    void runOnce(String jobName, String jobGroup);

    Map<String,Object> getDetailJobData(String jobName, String jobGroup);
}
