package com.digiwin.athena.abt.application.service.abt.migration.repair.impl;

import com.digiwin.athena.abt.application.dto.migration.abt.api.NoticeAbtRepairDto;
import com.digiwin.athena.abt.application.dto.migration.abt.api.NoticeWaitRepairDataDto;
import com.digiwin.athena.abt.application.dto.migration.abt.bk.ActivityBusinessKeyDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.event.TaskEvent;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.ActivityUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.eventbus.DataUniformityMqDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.mongodb.MongodbService;
import com.digiwin.athena.abt.application.dto.migration.atmc.parser.ParserBo;
import com.digiwin.athena.abt.application.service.abt.migration.repair.NoticeRepairApcDataService;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BkTaskActivityService;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BusinessKeyService;
import com.digiwin.athena.abt.application.service.atmc.migration.parser.IParser;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmActivityRecordDTO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmProjectRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmTaskRecordBO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.digiwin.athena.abt.core.meta.constants.BkConstant.*;

/**
 * @author lzw
 * @date 2024/2/29
 * @description:
 **/
@Slf4j
@Service
public class NoticeRepairApcDataServiceImpl implements NoticeRepairApcDataService {

    @Autowired
    private BusinessKeyService businessKeySercvice;

    @Autowired
    private IParser iParser;

    @Autowired
    private BkTaskActivityService bkTaskActivityService;

    @Autowired
    private PtmService ptmService;

    @Autowired
    private MongodbService mongodbService;

    @Override
    public void repairApcData(NoticeAbtRepairDto dto, AuthoredUser user) {
        List<NoticeWaitRepairDataDto> list = dto.getList();
        String type = dto.getType();
        if (!CollectionUtils.isEmpty(list)){
            for (NoticeWaitRepairDataDto dataDto : list){
                //删除mongo中原有的bk
                deleteMongo(dataDto);
                //插入bk数据
                insertData(dataDto,user,type);
            }
        }
    }

    /**
     * 删除mongo
     * @param dataDto
     */
    private void deleteMongo(NoticeWaitRepairDataDto dataDto) {
        log.info("删除mongo数据：{}",dataDto);
        Query query = Query.query(Criteria.where("cardId").is(Long.parseLong(dataDto.getWorkItemId())));
        mongodbService.delete(query,dataDto.getTenantId());
    }

    private void insertData(NoticeWaitRepairDataDto dataDto,AuthoredUser authoredUser,String type) {
        Boolean hasInsertBkTaskActivity = false;
        Boolean hasInsertOriBk = false;
        ActivityBusinessKeyDTO businessKeyDTO = buildProcessWorkItem(dataDto,authoredUser);
        ActivityUniformityMqDTO activityDataUniformityMqDTO = buildActivityUniformity(businessKeyDTO);

        /*记录BK、项目卡的关联关系 start*/
        //是否存在数据一致性的bk，默认不存在
        boolean hasDataUniformityBk = false;
        //数据一致性的bk
        List<JSONObject> bkList = new ArrayList<>();
        try {
            //获取businessKey
            TaskEvent taskEvent = new TaskEvent(JSONObject.fromObject(activityDataUniformityMqDTO));
            List<ParserBo> parserBoList = iParser.parse(taskEvent, authoredUser);
            //将businessKey转为字符串
            if (!CollectionUtils.isEmpty(parserBoList)) {
                //存在数据一致性的bk
                hasDataUniformityBk = true;
                //获取bk内容
                for (ParserBo parserBo : parserBoList) {
                    bkList.add(parserBo.getBkInfo());
                }
                //记录BusinessKey和项目卡/任务卡的关联关系
                businessKeySercvice.insertBkTaskActivity(parserBoList, businessKeyDTO.getWorkitemId(), businessKeyDTO.getTenantId(), "workitem");
                hasInsertBkTaskActivity = true;
            }
        } catch (Exception e) {
            log.warn("【获取数据一致性bk失败】：{}, {}", businessKeyDTO.getWorkitemId(), e.getMessage());
        }

        //不存在数据一致性bk时，获取TM中定义的bk
        if (!hasDataUniformityBk) {
            try {
                //themMap中定义的bk值集合
                Map<String, Object> bkMap = bkTaskActivityService.getTmBusinessKeyNew(businessKeyDTO.getTmTaskId(), businessKeyDTO.getTmActivityId(), businessKeyDTO.getBpmData());
                //复杂结构的bk
                List<JSONObject> bkValueList = new ArrayList<>();
                if (bkMap.containsKey("complex")) {
                    bkValueList = JSONArray.fromObject(bkMap.get("complex"));
                }
                //简单结构的bk
                List<Object> bkObjectValueList = new ArrayList<>();
                if (bkMap.containsKey("simple")) {
                    bkObjectValueList = JSONArray.fromObject(bkMap.get("simple"));
                }
                //记录BusinessKey和项目卡/任务卡的关联关系
                bkTaskActivityService.insertOriBk(bkValueList, bkObjectValueList, businessKeyDTO.getWorkitemId(), businessKeyDTO.getTenantId(), "workitem");
                hasInsertOriBk = true;
            } catch (Exception e) {
                log.warn("【记录BusinessKey和项目卡/任务卡的关联关系失败】：{}, {}", businessKeyDTO.getWorkitemId(), e.getMessage());
            }

        }
        //如果上面两次插入操作都没执行成功，说明失败，存入mongo
       if (!hasInsertBkTaskActivity && !hasInsertOriBk){
           log.info("程序调用执行失败：{}",dataDto);
           //程序跑的类型入库
            if (OPRATION_BY_PROGRAM.equals(type)){
                List<Map> list = new ArrayList<>();
                list.add(dataDto.toMap());
                mongodbService.insert(list,NOTICE_ERROR_COLLECTION);
            }
       }else {
           log.info("手动调用执行成功：{}",dataDto);
           //如果上面两次插入执行成功了一次，并且是手动补充调用执行，则将库中失败集合中的对应失败数据去除掉，避免后面重复操作
           if (OPRATION_BY_HAND.equals(type)){
               Query query = Query.query(Criteria.where("workItemId").is(dataDto.getWorkItemId()).and("tenantId").is(dataDto.getTenantId()));
               mongodbService.delete(query,NOTICE_ERROR_COLLECTION);
           }
       }

    }


    private ActivityUniformityMqDTO buildActivityUniformity(ActivityBusinessKeyDTO businessKeyDTO) {
        DataUniformityMqDTO dataUniformityMqDTO = new DataUniformityMqDTO();
        dataUniformityMqDTO.setBusinessUnit(businessKeyDTO.getBusinessUnit());
        dataUniformityMqDTO.setProcessVar(businessKeyDTO.getData());

        ActivityUniformityMqDTO activityDataUniformityMqDTO = ActivityUniformityMqDTO.builder()
                .tenantId(businessKeyDTO.getTenantId())
                .state(businessKeyDTO.getState())
                .activityId(businessKeyDTO.getActivityId().toString())
                .activityTemplateId(businessKeyDTO.getTmActivityId())
                .subTaskTemplateId(businessKeyDTO.getTmTaskId())
                .subTaskId(businessKeyDTO.getSubTaskId().toString())
                .type("activity")
                .messageData(dataUniformityMqDTO)
                .build();
        return activityDataUniformityMqDTO;
    }

    /**
     * PTM任务bk
     * @param
     */
    private ActivityBusinessKeyDTO buildProcessWorkItem(NoticeWaitRepairDataDto dataDto, AuthoredUser user){
        PtmTaskRecordBO ptmTaskRecordBO = ptmService.getTaskRecord(dataDto.getTaskId(),Long.parseLong(dataDto.getWorkItemId()));
        PtmActivityRecordDTO ptmActivityRecordDTO = ptmService.getActivityRecord(dataDto.getActivityId());
        PtmProjectRecordBO ptmProjectRecordBO = ptmService.getProjectRecord(dataDto.getProjectId());

        ActivityBusinessKeyDTO activityBusinessKeyDTO = new ActivityBusinessKeyDTO();
        activityBusinessKeyDTO.setSubTaskId(ptmProjectRecordBO.getId());
        activityBusinessKeyDTO.setTenantId(ptmProjectRecordBO.getTenantId());
        activityBusinessKeyDTO.setTmTaskId(ptmProjectRecordBO.getProjectDefCode());
        activityBusinessKeyDTO.setState(ptmActivityRecordDTO.getState());
        activityBusinessKeyDTO.setActivityId(dataDto.getActivityId());
        activityBusinessKeyDTO.setBusinessUnit(JSONObject.fromObject(ptmTaskRecordBO.getBusinessUnit()));
        activityBusinessKeyDTO.setData(JSONObject.fromObject(ptmTaskRecordBO.getData()));
        activityBusinessKeyDTO.setTmActivityId(ptmTaskRecordBO.getTaskDefCode());
        activityBusinessKeyDTO.setBpmData(JSONObject.fromObject(ptmTaskRecordBO.getData()));
        activityBusinessKeyDTO.setWorkitemId(Long.parseLong(dataDto.getWorkItemId()));
        activityBusinessKeyDTO.setClosed(ptmActivityRecordDTO.getState() >= 3);
        activityBusinessKeyDTO.setAuthoredUser(user);
        return activityBusinessKeyDTO;
    }
}
