package com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.impl;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionReq;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.VerifyAppPermissionResp;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lzw
 * @date 2024/9/23
 * @description:
 **/
@Service
@Slf4j
public class AtmcServiceImpl implements AtmcService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    /**
     * 调用ATMC获取历史项目任务数据
     * @param paramMap
     * @return
     */
    @Override
    public List<Map<String,Object>> findTaskBacklogH(Map<String,Object> paramMap,String locale) {
        List<Map<String,Object>> list = null;
        String url = this.envProperties.getAtmcUri() + "api/atmc/v1/taskBacklog/history/findTaskBacklogH";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        String archiveRouteKey = MapUtils.getString(paramMap,"archiveRouteKey","");
        headers.add("archive-route-key", archiveRouteKey);
        if (StringUtils.isEmpty(locale)){
            locale="zh_CN";
        }
        headers.add("locale", locale);
        HttpEntity<?> httpEntity = new HttpEntity(paramMap, headers);
        ResponseEntity<BaseResultDTO<Map<String,Object>>> responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map<String,Object>>>() {
        }, paramMap);
        Map<String,Object> result = (Map<String,Object>) (responseEntity.getBody()).getResponseWithException("");

        if (result == null) {
            return new ArrayList();
        }
        if ( null == MapUtils.getObject(result,"records")) {
            return new ArrayList();
        }
        list = (List<Map<String,Object>>) MapUtils.getObject(result,"records");
        return list;
    }

    @Override
    public String getShareCode(String taskId, String taskType) {
        String url = envProperties.getAtmcUri() + "/api/atmc/v1/share/code?taskType=%s&taskId=%s";
        url = String.format(url, taskType, taskId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        JSONObject reqObject = JSONObject.fromObject(this);
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(reqObject, headers);
        try {
            log.info("请求ATMC获取分享码 入参:{}", JsonUtils.objectToString(httpEntity));
            ResponseEntity<BaseResultDTO<String>> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<String>>() {
                    });
            log.info("请求ATMC获取分享码，入参url：{}, 响应内容：{}", url, respEntity.getBody().getResponse());
            if (null != respEntity.getBody() && respEntity.getBody().isOK()) {
                return respEntity.getBody().getResponse();
            }
        } catch (BusinessException ex) {
            log.error("请求ATMC获取分享码报错，入参url：{}, ex：{}", url, ex);
        }
        return "";
    }

    private static final String VERIFY_APP_PERMISSION = "/api/atmc/v1/permission/verifyAppPermission";

    public static final String CONFIG = "api/atmc/v1/config/operationConfig";

    @Override
    public VerifyAppPermissionResp verifyAppPermission(VerifyAppPermissionReq verifyAppPermissionReq) {

        String url = envProperties.getAtmcUri() + VERIFY_APP_PERMISSION;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(BeanUtil.beanToMap(verifyAppPermissionReq), headers);
        ResponseEntity<BaseResultDTO<VerifyAppPermissionResp>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<VerifyAppPermissionResp>>() {
        });
        return respEntity.getBody().getResponseWithException("");
    }

    @Override
    public Boolean verifyConfig(String configName, String name) {
        String url = envProperties.getAtmcUri() + CONFIG;
        Map<String, Object> params = new HashMap<>();
        params.put("name", name);
        params.put("configName", configName);
        params.put("operation", 0);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(BeanUtil.beanToMap(params), headers);
        ResponseEntity<BaseResultDTO<Boolean>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Boolean>>() {
        });

        return respEntity.getBody().getResponseWithException("");
    }
}