package com.digiwin.athena.abt.application.service.abt.migration.restfull.cac.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.cac.BaseCacResult;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.cac.CacService;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.cac.sdk.meta.dto.response.UserAppDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;

@Slf4j
@Service("abtCacServiceImpl")
public class CacServiceImpl implements CacService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    MessageUtils messageUtils;

    @Value("${athena.auth.appToken}")
    private String appToken;


    @Override
    public List<UserAppDTO> qryUserApp() {

        String uri = envProperties.getIamCacUri() + "/api/cac/v4/authorizations/current/user/apps";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-auth-app", appToken);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseCacResult<List<UserAppDTO>>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                new ParameterizedTypeReference<BaseCacResult<List<UserAppDTO>>>() {
                });
            if (null != responseEntity.getBody() && String.valueOf(HttpStatus.OK.value()).equals(responseEntity.getBody().getCode())){
                return responseEntity.getBody().getData();
            }
        }
        catch (Exception e) {
            log.error("execute cac [/authorizations/current/user/apps] fail, message = {}", e.getMessage());
        }
        return null;
    }


}
