package com.digiwin.athena.abt.application.service.abt.migration.restfull.uibot.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.uibot.UibotService;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;


/**
 * @author xuhx
 * @date 2025/5/15
 */
@Service
@Slf4j
public class UibotServiceImpl implements UibotService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    /**
     * 根据任务ID和状态，获取数据
     *
     * @param paramMap
     * @return
     */
    @Override
    public Map<String, Object> dataByBacklogIdAndState(Map<String, Object> paramMap) {
        String baseUrl = this.envProperties.getUibotUri() + "api/ai/v1/data/query/task/dataByBacklogIdAndState";

        // 使用 UriComponentsBuilder 构建带参数的 URL
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl(baseUrl);
        paramMap.forEach((key, value) -> {
            if (value != null) {
                builder.queryParam(key, value);
            }
        });

        String url = builder.toUriString();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity(headers);
        ResponseEntity<BaseResultDTO<Map<String, Object>>> responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
        });
        return (responseEntity.getBody()).getResponseWithException("");

    }

}
