package com.digiwin.athena.abt.application.service.abt.migration.retry.constant;


/**
 * mq消费记录常量
 */

public interface MqRetryLogConstant {

    /**
     * mq重试次数
     */
    String MQ_RETRY_COUNT = "mqRetrycount";

    /**
     * 本地重试次数
     */
    String LOCAL_RETRY_COUNT = "localRetrycount";

    /**
     * 主键
     */
    String ID = "_id";

    /**
     * 消息id
     */
    String MESSAGE_ID = "messageId";

    /**
     * 业务id
     */
    String BIZ_ID = "bizId";

    /**
     * 消息类型
     */
    String TYPE = "type";

    /**
     * 消息操作类型
     */
    String OPERATION = "operation";

    /**
     * 状态 0-成功消费 1-消费中 2-消费失败
     */
    String STATUS = "status";

    /**
     * 状态 0-成功消费 1-消费中 2-消费失败
     */
    String PINPOINT_ID = "pinpointId";

    /**
     * 更新时间
     */
    String UPDATE_TIME = "updateTime";

    /**
     * 更新时间
     */
    String CREATE_TIME = "createTime";

    /**
     * 更新时间
     */
    String EXPIRE_TIME = "expireTime";

    /**
     * 异常原因
     */
    String ERROR_MSG = "errorMsg";

    /**
     * 异常详细信息
     */
    String ERROR_DETAIL = "errorDetail";

    /**
     * 来源
     */
    String SOURCE_ID = "sourceId";

    /**
     * 队列
     */
    String MQ_QUEUE = "mqQueue";

    /**
     * 表名
     */
    String MQ_RETRY_LOG = "mq_retry_log";

    /**
     * atmc
     */
    String SOURCE_ID_ATMC = "atmc";

    /**
     * abt
     */
    String SOURCE_ID_ABT = "abt";

    String V_HOST = "spring.rabbitmq.virtual-host";
    String EXPIRE_SUCCESS = "athena.mq.retry.expireSuccess";
    String EXPIRE_FAIL = "athena.mq.retry.expireFail";
    String MONITOR = "athena.mq.monitor.enable";
    String WEIXIN_KEY = "athena.mq.monitor.botKey";
    String ALARM_ERROR = "消费异常告警";
    String ALARM_REPEATE_CONSUME = "重复消息告警";

    String WECHAT_FAIL_NOTIFY_TEMPLATE =
            "【报警】Rabbitmq消息告警 \n" +
                    "环境：%s\n" +
                    "队列名称：%s\n" +
                    "消息id：%s\n" +
                    "消息类型：%s\n" +
                    "消息操作类型：%s\n" +
                    "报警项：%s\n" +
                    "本地重试次数：%s\n" +
                    "mq重试次数：%s\n" +
                    "错误信息：%s\n" +
                    "pinpointId：%s\n" +
                    "执行线程：%s\n" +
                    "报警时间：%s\n";
}
