package com.digiwin.athena.abt.application.service.abt.migration.retry.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.util.Date;

/**
 * mq消费记录实体类
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MqRetryLogBo implements Serializable {
    /**
     * 主键
     */
    @Id
    private String id;

    /**
     * 消息id
     */
    private String messageId;

    /**
     * 业务主键
     */
    private String bizId;

    /**
     * 消息类型
     */
    private String type;

    /**
     * 操作类型
     */
    private String operation;

    /**
     * 消息内容
     */
    private String data;

    /**
     * pinpointId
     */
    private String pinpointId;

    /**
     * mq重试次数
     */
    private Integer mqRetrycount;

    /**
     * 本地重试次数
     */
    private Integer localRetrycount;

    /**
     * 状态 0-成功消费 1-消费中 2-消费失败
     */
    private Integer status;

    /**
     * 异常原因
     */
    private String errorMsg;
    /**
     * 异常描述
     */
    private String errorDetail;

    /**
     * host
     */
    private String mqVirtualHost;

    /**
     * 交换机
     */
    private String mqExchange;

    /**
     * 路由key
     */
    private String mqRouteKey;

    /**
     * 队列
     */
    private String mqQueue;

    /**
     * 来源
     */
    private String sourceId;

    /**
     * 过期时间
     */
    private Date expireTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建时间
     */
    private Date updateTime;

}
