package com.digiwin.athena.abt.application.service.abt.migration.retry.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author Administrator
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class RetryLogQueryDTO {

    private String beginTime;

    private String endTime;

    /**
     * 消息id
     */
    private String messageId;

    /**
     * 业务主键
     */
    private List<String> bizIds;

    /**
     * 消息类型
     */
    private String type;

    /**
     * 操作类型
     */
    private String operation;

    /**
     * pinpointId
     */
    private String pinpointId;

    /**
     * mq重试次数
     */
    private Integer mqRetrycount;

    /**
     * 本地重试次数
     */
    private Integer localRetrycount;

    /**
     * 状态 0-成功消费 1-消费中 2-消费失败
     */
    private Integer status;

    /**
     * 来源
     */
    private String sourceId;

}
