package com.digiwin.athena.abt.application.service.abt.migration.retry.handler;

import com.digiwin.athena.abt.application.service.abt.migration.retry.constant.MqRetryLogTypeEnum;
import com.digiwin.athena.abt.application.service.abt.migration.retry.dto.MqRetryLogBo;
import com.digiwin.athena.abt.application.service.abt.migration.retry.service.MqRetryLogService;
import com.digiwin.athena.framework.mq.retry.RabbitMqRetryProperties;
import com.digiwin.athena.framework.mq.retry.context.MQRetryContextHolder;
import com.digiwin.athena.framework.mq.retry.exception.RejectMQException;
import com.digiwin.athena.framework.mq.retry.handler.BeforeHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import static com.digiwin.athena.abt.application.service.abt.migration.retry.constant.MqRetryLogConstant.ALARM_REPEATE_CONSUME;

@Slf4j
@Component("ptmMqBeforeHandler")
@ConditionalOnProperty(prefix = "athena.mq.retry", name = "enable", havingValue = "true")
public class PtmMqBeforeHandler implements BeforeHandler {
    private final MqRetryLogService mqRetryLogService;

    private final RabbitMqRetryProperties retryProperties;

    public PtmMqBeforeHandler(MqRetryLogService mqRetryLogService, RabbitMqRetryProperties retryProperties) {
        this.mqRetryLogService = mqRetryLogService;
        this.retryProperties = retryProperties;
    }

    @Override
    public void invokeHandler() {
        MQRetryContextHolder.MQRetryContext context = MQRetryContextHolder.getContext();
        MqRetryLogBo mqRetryLog = mqRetryLogService.getRetryLog(context.getQueueBinding().getMessage());

        if (checkConsumeSucess(mqRetryLog)) {
            mqRetryLogService.sendWeixin(context, mqRetryLog, ALARM_REPEATE_CONSUME);
            throw new RejectMQException("已经消费成功或者达到最大重试次数");
        }
    }

    private boolean checkConsumeSucess(MqRetryLogBo mqRetryLog) {
        if (MqRetryLogTypeEnum.SUCCESS.getType() == mqRetryLog.getStatus()) {
            return true;
        }
        if (mqRetryLog.getMqRetrycount() > retryProperties.getMaxMQRetryCount()) {
            return true;
        }
        return false;
    }
}