package com.digiwin.athena.abt.application.service.abt.migration.retry.handler;

import com.digiwin.athena.abt.application.service.abt.migration.retry.dto.MqRetryLogBo;
import com.digiwin.athena.abt.application.service.abt.migration.retry.service.MqRetryLogService;
import com.digiwin.athena.framework.mq.retry.context.MQRetryContextHolder;
import com.digiwin.athena.framework.mq.retry.exception.OverLimitException;
import com.digiwin.athena.framework.mq.retry.exception.RejectMQException;
import com.digiwin.athena.framework.mq.retry.handler.FailureHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import static com.digiwin.athena.abt.application.service.abt.migration.retry.constant.MqRetryLogConstant.ALARM_ERROR;


@Slf4j
@Component("ptmMqFailureHandler")
@ConditionalOnProperty(prefix = "athena.mq.retry", name = "enable", havingValue = "true")
public class PtmMqFailureHandler implements FailureHandler {

    private final MqRetryLogService mqRetryLogService;

    public PtmMqFailureHandler(MqRetryLogService mqRetryLogService) {
        this.mqRetryLogService = mqRetryLogService;
    }

    @Override
    public void invokeHandler() {
        MQRetryContextHolder.MQRetryContext context = MQRetryContextHolder.getContext();
        Object message = context.getQueueBinding().getMessage();
        MqRetryLogBo retryLog = mqRetryLogService.getRetryLog(message);

        if (!(context.getLastException() instanceof RejectMQException
                || context.getLastException() instanceof OverLimitException)) {
            mqRetryLogService.fail(retryLog, context.getLastException());
            mqRetryLogService.sendWeixin(context, retryLog, ALARM_ERROR);
        }
    }
}