package com.digiwin.athena.abt.application.service.abt.migration.retry.handler;

import com.digiwin.athena.abt.application.service.abt.migration.retry.service.MqRetryLogService;
import com.digiwin.athena.framework.mq.retry.context.MQRetryContextHolder;
import com.digiwin.athena.framework.mq.retry.handler.SuccessHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
@Slf4j
@Component("ptmMqSuccessHandler")
@ConditionalOnProperty(prefix = "athena.mq.retry", name = "enable", havingValue = "true")
public class PtmMqSuccessHandler implements SuccessHandler {

    private final MqRetryLogService mqRetryLogService;

    public PtmMqSuccessHandler(MqRetryLogService mqRetryLogService) {

        this.mqRetryLogService = mqRetryLogService;
    }

    @Override
    public void invokeHandler() {
        MQRetryContextHolder.MQRetryContext context = MQRetryContextHolder.getContext();
        Object message = context.getQueueBinding().getMessage();

        mqRetryLogService.success(mqRetryLogService.getRetryLog(message));
    }
}