package com.digiwin.athena.abt.application.service.abt.migration.route;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.RouteNewMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.Route;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author lzw
 * @date 2024/4/28
 * @description:
 **/
@Service
@Slf4j
public class RouteService {
    @Autowired
    private RouteNewMapper routeNewMapper;

    /**
     * 获取子项目其中一条路线
     * @Author：SYQ
     * @Date：2021/8/23 9:52
     */
    public Route getRouteByTaskId(Long taskId){
        if(taskId == null){
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("task_id",taskId);
        List<Route> routeList = routeNewMapper.selectList(queryWrapper);
        if(routeList == null || routeList.size() == 0){
            return null;
        }
        return routeList.get(0);
    }
}
