package com.digiwin.athena.abt.application.service.abt.migration.sendmsg;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmBacklogMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.mq.PtmDataConsistencyMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.sendmsg.TaskOperateSendMsgDTO;
import com.digiwin.athena.abt.application.service.abt.migration.event.handler.TaskOperateSendMsgHandler;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.utils.ActivityUtils;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmBacklogItemBO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Optional;

/**
 * @program: abt
 * @description:
 * @author: Hang Liu
 * @create: 2023-07-26 10:05
 */
@Service
@Slf4j
public class TaskOperateSendMsgMqService {


    @Resource
    private TaskOperateSendMsgHandler taskOperateSendMsgHandler;

    @Resource
    private PtmService ptmService;


    public void processBacklogOverDueMessage(String data, AuthoredUser user) {
        PtmBacklogMessageDTO backlogMessageDTO = JsonUtils.jsonToObject(data, PtmBacklogMessageDTO.class);
        PtmBacklogMessageDTO.Backlog backlog = backlogMessageDTO.getData().getBacklog();
        if (backlog.getHidden()) {
            return;
        }
        //处理发送消息
        TaskOperateSendMsgDTO taskOperateSendMsgDTO = new TaskOperateSendMsgDTO();
        taskOperateSendMsgDTO.setAuthoredUser(user);
        taskOperateSendMsgDTO.setSource("athena");
        taskOperateSendMsgDTO.setType("taskOverdue");
        taskOperateSendMsgDTO.setBacklogId(backlog.getBacklogId());
        taskOperateSendMsgDTO.setWorkItemId(backlog.getWorkItemId());
        taskOperateSendMsgDTO.setTaskName(backlog.getTaskName());
        taskOperateSendMsgDTO.setPerformerId(backlog.getPerformerId());
        taskOperateSendMsgDTO.setPerformerName(backlog.getPerformerName());
        log.info("[taskOperateSendMsg] send message, message = {}", JsonUtils.objectToString(taskOperateSendMsgDTO));
        taskOperateSendMsgHandler.process(taskOperateSendMsgDTO);

    }

    public void processWorkItemAddMessage(String data, AuthoredUser user) {
        PtmDataConsistencyMessageDTO message = ActivityUtils.convertPtmDataConsistencyMsg(data);
        PtmDataConsistencyMessageDTO.MqData mqData = message.getData();
        if(BooleanUtils.isTrue(mqData.getMinSplit())){
            log.info("最小化拆分不支持，且该场景已无应用使用");
            return;
        }
        List<PtmDataConsistencyMessageDTO.WorkItem> workItemList = message.getData().getWorkItem();
        if (CollectionUtil.isEmpty(workItemList)) {
            return;
        }
        PtmDataConsistencyMessageDTO.WorkItem workItem = workItemList.get(0);
        //处理发送消息
        TaskOperateSendMsgDTO taskOperateSendMsgDTO = new TaskOperateSendMsgDTO();
        taskOperateSendMsgDTO.setAuthoredUser(user);
        taskOperateSendMsgDTO.setSource("athena");
        taskOperateSendMsgDTO.setType("taskCreated");
        taskOperateSendMsgDTO.setBacklogId(workItem.getBacklogId());
        taskOperateSendMsgDTO.setWorkItemId(workItem.getId());
        // 获取任务名称，当责者
        List<PtmBacklogItemBO> ptmBacklogItemBOList = ptmService.getBacklogByBacklogId(workItem.getBacklogId());
        if (CollectionUtil.isNotEmpty(ptmBacklogItemBOList)) {
            Optional<PtmBacklogItemBO> optional = ptmBacklogItemBOList.stream().filter(ptmBacklogItemDTO -> ptmBacklogItemDTO.getWorkItemId().equals(workItem.getId())).findFirst();
            if (optional.isPresent()) {
                taskOperateSendMsgDTO.setTaskName(optional.get().getTaskName());
                taskOperateSendMsgDTO.setPerformerId(optional.get().getPerformerId());
                taskOperateSendMsgDTO.setPerformerName(optional.get().getPerformerName());
            }
        }
        log.info("[taskOperateSendMsg] send message, message = {}", JsonUtils.objectToString(taskOperateSendMsgDTO));
        taskOperateSendMsgHandler.process(taskOperateSendMsgDTO);
    }
}
