package com.digiwin.athena.abt.application.service.abt.migration.summary;

import com.digiwin.athena.abt.application.dto.migration.abt.api.RefreshCardDto;
import com.digiwin.athena.abt.application.dto.migration.abt.api.RefreshCardMessageCompensateDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.summary.*;

import java.util.List;

/**
 * RefreshCardMessageService Description
 *
 * @author majianfu
 * @date 2023/3/31
 * @since
 */
public interface RefreshCardMessageService {
    /**
     * 如果任务卡/项目卡刷新 message（summary、history_message、search_message）的定时任务不存在，则创建
     *
     * @param refreshCardMessageDTO
     * @return 是否创建成功
     */
    Boolean createRefreshCardMessageJobIfAbsent(RefreshCardMessageDTO refreshCardMessageDTO);

    /**
     * 删除为任务卡/项目卡创建的定时刷新 message（summary、history_message、search_message）的任务
     *
     * @param taskKeyName 任务id
     */
    void deleteRefreshCardMessageJob(String taskKeyName);
    void deleteJob(String jobName,String group);

    /**
     * 更新定时任务的数据
     *
     * @param refreshCardMessageDTO
     */
    void updateRefreshCardMessageJobData(RefreshCardMessageDTO refreshCardMessageDTO);

    /**
     * 刷新任务卡/项目卡的 message（summary、history_message、search_message）信息
     *
     * @param refreshCardMessageDTO
     */
    void refreshCardMessage(RefreshCardMessageDTO refreshCardMessageDTO);

    /**
     * 为指定的任务卡/项目卡列表补充刷新message的定时任务
     *
     * @param refreshCardMessageCompensateList
     */
    void compensateRefreshCardMessage(List<RefreshCardMessageCompensateDTO> refreshCardMessageCompensateList);

    String triggerManual(String jobName);

    void refreshCard(RefreshCardDto refreshCardDto);

    void settingSize(Integer size);

    Boolean createOrUpdateCardJob(CardJob cardJob);

    /**
     *  刷新卡片
     * @param cardTaskContext
     * @param cardJobData
     */
    void refreshTaskCard(CardTaskContext cardTaskContext, CardJobData cardJobData);

    void updateCardInfo(CardJob cardJob);

    void updateCardByBk(RefreshCardInfosDTO refreshCardInfos);

    void updateTaskWorkItemMessage(UpdateTaskWorkItemMessageDTO updateDTO);
}
