package com.digiwin.athena.abt.application.service.abt.migration.summary.executor;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardInfoDto;
import com.digiwin.athena.abt.application.service.abt.migration.quartz.JobManager;
import com.digiwin.athena.abt.application.service.atmc.migration.backlog.CommonBacklogAbstractService;
import com.digiwin.athena.abt.application.service.atmc.migration.project.CommonProjectHandleService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aim.TenantService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.ptm.PtmService;
import com.digiwin.athena.abt.application.utils.CommonUtils;
import com.digiwin.athena.abt.core.meta.constants.JobConstants;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.TaskWorkitemMessageMapper;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskWorkitemMessage;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * AbstractRefreshCardMessageExecutor Description
 *
 * @author majianfu
 * @date 2023/4/13
 * @since
 */
@Slf4j
public abstract class AbstractRefreshCardMessageExecutor implements RefreshCardMessageExecutor {
    @Autowired
    protected JobManager jobManager;

    @Autowired
    protected PtmService ptmService;

    @Autowired
    protected TenantService tenantService;

    @Autowired
    protected TaskWorkitemMessageMapper taskWorkItemMessageMapper;

    @Autowired
    protected CommonBacklogAbstractService backlogAbstractService;

    @Autowired
    protected CommonProjectHandleService commonProjectHandleService;

    /**
     * 更新任务卡/项目卡的message
     *
     * @param cardId
     * @param cardInfoDto
     * @return
     */
    protected int updateCardMessage(Long cardId, CardInfoDto cardInfoDto) {
        UpdateWrapper<TaskWorkitemMessage> wrapper = new UpdateWrapper();
        Map<String, Object> cardMessage = cardInfoDto.getCardInfo();
        String activityMessage = CommonUtils.getActivityMessageStr(cardInfoDto);
        wrapper.eq("card_id", cardId)
                .set("summary", MapUtils.getString(cardMessage,"summaryLayout",""))
                .set("history_message", MapUtils.getString(cardMessage,"historyMessage",""))
                .set("search_message", MapUtils.getString(cardMessage,"searchMessage",""))
                .set("activity_message", activityMessage)
                .set("modify_date", LocalDateTime.now());
        TaskWorkitemMessage taskMessage = TaskWorkitemMessage.builder()
                .cardId(cardId)
                .summary(MapUtils.getString(cardMessage,"summaryLayout",""))
                .historyMessage(MapUtils.getString(cardMessage,"historyMessage",""))
                .searchMessage(MapUtils.getString(cardMessage,"searchMessage",""))
                .activityMessage(activityMessage)
                .build();
        log.info("save card message:{}.{}, message:{}", cardId, JobConstants.REFRESH_MESSAGE_TASK_GROUP_NAME, taskMessage);
        return taskWorkItemMessageMapper.update(taskMessage, wrapper);
    }
}
