package com.digiwin.athena.abt.application.service.abt.migration.summary.executor;

import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardAbstractDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardInfoDto;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmProjectCardRecordDTO;
import com.digiwin.athena.abt.application.utils.AppAuthContextUtils;
import com.digiwin.athena.abt.core.meta.constants.ContainerConstant;
import com.digiwin.athena.abt.core.meta.constants.JobConstants;
import com.digiwin.athena.abt.core.meta.enums.CardTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * RefreshProjectCardMessageExecutor Description
 *
 * @author majianfu
 * @date 2023/4/13
 * @since
 */
@Slf4j
@Component
public class RefreshProjectCardMessageExecutor extends AbstractRefreshCardMessageExecutor {
    @Override
    public int cardType() {
        return CardTypeEnum.PROJECT_CARD.getType();
    }

    @Override
    public void execute(RefreshCardMessageDTO refreshCardMessage) {
        // 获取虚拟token
        JSONObject apiResult = tenantService.queryApiVirtualToken(refreshCardMessage.getTenantId());
        //如果api没有返回数据，则返回null对象
        if (apiResult.isEmpty() || !apiResult.containsKey("token")) {
            return;
        }
        String virtualToken = apiResult.getString("token");
        //将token放入线程内
        AuthoredUser authoredUser = AppAuthContextUtils.setAuthoredUserContext(virtualToken);
        // 调用ptm接口获取项目卡详情
        PtmProjectCardRecordDTO projectCardRecord = ptmService.getProjectCardRecord(refreshCardMessage.getId());

        String jobName = String.valueOf(refreshCardMessage.getId());
        String jobGroupName = JobConstants.REFRESH_MESSAGE_TASK_GROUP_NAME;
        // 项目卡不存在or已关闭，则移除定时任务
        if (null == projectCardRecord || (null != projectCardRecord.getState() && projectCardRecord.getState() >= 3)) {
            log.warn("project card not exist or closed, will delete refresh card message job:{}.{}", jobName, jobGroupName);
            this.jobManager.deleteJob(jobName, jobGroupName);
            return;
        }

        refreshProjectCardMessage(authoredUser,refreshCardMessage.getRefreshCardType(), refreshCardMessage.getId());
    }

    private void refreshProjectCardMessage(AuthoredUser authoredUser,String refreshCardType, Long projectCardId) {
        if(ContainerConstant.REFRESH_CARD_TYPE_BUSINESS.equals(refreshCardType)){
            commonProjectHandleService.saveProjectCardData(projectCardId);
            return;
        }
        // 请求ATMC生成summary、history_message、search_message等信息
        Map projectCardSelfAbstract = commonProjectHandleService.getProjectCardSelfAbstract(authoredUser, projectCardId,
                new CardAbstractDTO().setNeedHistoryInfo(true).setNeedBusinessMessage(true).setBusinessMessageSourceType(CardAbstractDTO.SOURCE_TYPE_API));
        if (null == projectCardSelfAbstract) {
            log.warn("query project card massage is null, job:{}.{}", projectCardId, JobConstants.REFRESH_MESSAGE_TASK_GROUP_NAME);
            return;
        }
        CardInfoDto cardInfoDto = new CardInfoDto();
        cardInfoDto.setCardInfo(projectCardSelfAbstract);
        updateCardMessage(projectCardId, cardInfoDto);
    }
}
