package com.digiwin.athena.abt.application.service.abt.migration.summary.executor;

import com.digiwin.athena.abt.application.dto.migration.abt.summary.RefreshCardMessageDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardAbstractDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogRecordDTO;
import com.digiwin.athena.abt.application.utils.AppAuthContextUtils;
import com.digiwin.athena.abt.core.meta.constants.ContainerConstant;
import com.digiwin.athena.abt.core.meta.constants.JobConstants;
import com.digiwin.athena.abt.core.meta.enums.CardTypeEnum;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * RefreshTaskCardMessageExecutor Description
 *
 * @author majianfu
 * @date 2023/4/13
 * @since
 */
@Slf4j
@Component
public class RefreshTaskCardMessageExecutor extends AbstractRefreshCardMessageExecutor {
    @Override
    public int cardType() {
        return CardTypeEnum.TASK_CARD.getType();
    }

    @Override
    public void execute(RefreshCardMessageDTO refreshCardMessage) {
        log.info("task run data:{}", JsonUtils.objectToString(refreshCardMessage));
        // 获取虚拟token
        JSONObject apiResult = tenantService.queryApiVirtualToken(refreshCardMessage.getTenantId());
        //如果api没有返回数据，则返回null对象
        if (apiResult.isEmpty() || !apiResult.containsKey("token")) {
            return;
        }
        String virtualToken = apiResult.getString("token");
        //将token放入线程内
        AuthoredUser authoredUser = AppAuthContextUtils.setAuthoredUserContext(virtualToken);
        authoredUser.setTenantId(apiResult.getString("tenantId"));
        // 请求ptm获取任务详情
        PtmBacklogRecordDTO backlogRecord = ptmService.getBacklogRecord(refreshCardMessage.getId());

        String jobName = String.valueOf(refreshCardMessage.getId());
        String jobGroupName = JobConstants.REFRESH_MESSAGE_TASK_GROUP_NAME;
        // 任务不存在或已关闭，则移除该定时任务
        if (null == backlogRecord || BooleanUtils.isTrue(backlogRecord.getClosed())) {
            log.warn("task card not exist or closed, will delete refresh card message job:{}.{}", jobName, jobGroupName);
            this.jobManager.deleteJob(jobName, jobGroupName);
            return;
        }

        // 刷新待办项的 message（summary、history_message、search_message）信息
        refreshTaskCardMessage(authoredUser, refreshCardMessage);
    }

    private void refreshTaskCardMessage(AuthoredUser authoredUser, RefreshCardMessageDTO refreshCardMessage) {
        long taskCardId = refreshCardMessage.getId();
        // 请求ATMC生成summary、history_message、search_message等信息
        if (ContainerConstant.REFRESH_CARD_TYPE_BUSINESS.equals(refreshCardMessage.getRefreshCardType())){ // 有这个属性代办只刷新业务字段
            log.info("执行刷新业务字段:{}",refreshCardMessage.getId());
            CardAbstractDTO cardAbstractDTO = new CardAbstractDTO().setCardId(taskCardId).setNeedHistoryInfo(false).setNeedBusinessMessage(true).setBusinessMessageSourceType(CardAbstractDTO.SOURCE_TYPE_API);
            backlogAbstractService.saveTaskSaveBusinessMessage(authoredUser,cardAbstractDTO);
            return;
        }
        Map backlogDTO = backlogAbstractService.getBacklogCardAbstractById(taskCardId, authoredUser,
                new CardAbstractDTO().setCardId(taskCardId).setNeedHistoryInfo(false).setNeedBusinessMessage(true).setBusinessMessageSourceType(CardAbstractDTO.SOURCE_TYPE_API),null);
        if (null == backlogDTO) {
            log.warn("query task card massage is null, job:{}.{}", taskCardId, JobConstants.REFRESH_MESSAGE_TASK_GROUP_NAME);
            return;
        }
        updateCardMessage(taskCardId, backlogAbstractService.getSummaryWorkItemLayout(taskCardId, authoredUser,
                new CardAbstractDTO().setCardId(taskCardId).setNeedHistoryInfo(false).setNeedBusinessMessage(true).setBusinessMessageSourceType(CardAbstractDTO.SOURCE_TYPE_API)));
    }
}
