package com.digiwin.athena.abt.application.service.abt.migration.worker;

import com.digiwin.athena.abt.application.configuration.DirectRabbitConfig;
import com.digiwin.athena.abt.application.dto.migration.abt.api.UploadParamDTO;
import com.digiwin.athena.abt.application.dto.migration.abt.worker.DataEntryTask;
import com.digiwin.athena.abt.core.meta.constants.ImportAndExportStatisticsConstants;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @ClassName DataEntryTaskFactory
 * @Description 数据录入任务工厂类
 * @Author zhuangli
 * @Date 2021/4/2 10:48
 * @Version 1.0
 **/
@Service
@Slf4j
public class DataEntryTaskFactory {

    private final int DEFAULT_BATCH_SIZE = 300;

    public List<DataEntryTask> produce(String actionId, AuthoredUser athenaUser, String tableKey, String masterId, List<String> keyList, List<List<Object>> data, String topic, String appToken) {
        List<List<List<Object>>> batches = Lists.partition(data, DEFAULT_BATCH_SIZE);
        List<DataEntryTask> dataEntryTasks = new LinkedList<>();
        AtomicInteger i = new AtomicInteger();
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        batches.forEach(item -> {
            DataEntryTask dataEntryTask = new DataEntryTask();
            String locale = LocaleContextHolder.getLocale().toString();
            dataEntryTask.setLocale(locale == null ? "zh_CN" : locale);
            dataEntryTask.setKeyList(keyList);
            dataEntryTask.setMasterId(masterId);
            dataEntryTask.setActionId(actionId);
            dataEntryTask.setUserToken(securityToken);
            dataEntryTask.setTenantId(athenaUser.getTenantId());
            dataEntryTask.setTableKey(tableKey);
            dataEntryTask.setTopic(topic);
            dataEntryTask.setData(item);
            dataEntryTask.setBatchNum(i.getAndIncrement());
            dataEntryTasks.add(dataEntryTask);
        });
        return dataEntryTasks;
    }

    public List<DataEntryTask> produceNew(UploadParamDTO uploadParam, String tableKey, List<String> keyList, List<Map> data) {
        List<List<Map>> batches = Lists.partition(data, DEFAULT_BATCH_SIZE);
        List<DataEntryTask> dataEntryTasks = new LinkedList<>();
        AtomicInteger i = new AtomicInteger();
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        //异步处理如果当前上下文没有token尝试从参数中获取
        if (securityToken == null) {
            securityToken = uploadParam.getSecurityToken();
        }
        String finalSecurityToken = securityToken;
        batches.forEach(item -> {
            DataEntryTask dataEntryTask = new DataEntryTask();
            String locale = LocaleContextHolder.getLocale().toString();
            dataEntryTask.setLocale(locale == null ? "zh_CN" : locale);
            dataEntryTask.setKeyList(keyList);
            dataEntryTask.setMasterId(uploadParam.getMasterId());
            dataEntryTask.setActionId(uploadParam.getActionId());
            dataEntryTask.setUserToken(finalSecurityToken);
            //异步处理如果当前上下文没有tenantId尝试从参数中获取
            dataEntryTask.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser()==null? uploadParam.getAuthoredUser().getTenantId():AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            dataEntryTask.setTableKey(tableKey);
            dataEntryTask.setTopic(DirectRabbitConfig.QUEUE_NAME);
            dataEntryTask.setDataList(item);
            dataEntryTask.setBatchNum(i.getAndIncrement());
            dataEntryTask.setActionInfo(uploadParam.getActionInfo());
            dataEntryTask.setApplication(uploadParam.getApplication());
            dataEntryTask.setActivityId(uploadParam.getActivityId());
            //设置文件url
            dataEntryTask.setFileUrl(uploadParam.getFileUrl());
            dataEntryTask.setType(ImportAndExportStatisticsConstants.EXPORT_FILE_TYPE_BUSINESS_DATA);
            dataEntryTasks.add(dataEntryTask);
        });
        return dataEntryTasks;
    }
}
