package com.digiwin.athena.abt.application.service.atmc.migration.atdm.impl;

import com.digiwin.athena.abt.application.configuration.EnvProperties;
import com.digiwin.athena.abt.application.dto.migration.atmc.action.SubmitExecuteContext;
import com.digiwin.athena.abt.application.service.atmc.migration.atdm.AtdmService;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.QueryResult;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.QueryResultSet;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;

import com.jugg.agile.biz.digiwin.config.biz.DwBizConfig;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;


@Service
@Slf4j
public class AtdmServiceImpl implements AtdmService {
    /**
     * 根据数据源获取应用业务数据
     */
    public static final String WITH_META_DATA= "api/atdm/v1/data/query/by/backlog/withmetadata";

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    MessageUtils messageUtils;

    @Override
    public QueryResultSet getResultSet(Map map, AuthoredUser authoredUser) {
        Map<String, Object> executeContext = (Map<String, Object>) map.get("executeContext");
        String actionId = null;
        String tmActivityId = executeContext.get("tmActivityId").toString();
        Long backlogId = Long.parseLong(executeContext.get("backlogId").toString());
        Map<String, Object> taskWithBacklogData = (Map<String, Object>) executeContext.get("taskWithBacklogData");
        String processSerialNumber = taskWithBacklogData.get("processSerialNumber").toString();
        Map<String, Object> dataSourceSet = (Map<String, Object>) map.get("dataSourceSet");
        List<Map<String, Object>> dataSourceList = (List<Map<String, Object>>) dataSourceSet.get("dataSourceList");
        if (!dataSourceList.isEmpty()) {
            actionId = dataSourceList.get(0).get("actionId").toString();
        }

        String application = Objects.nonNull(executeContext.get("application")) ? executeContext.get("application").toString() : null;
        SubmitExecuteContext submitExecuteContext = new SubmitExecuteContext();
        submitExecuteContext.setAuthoredUser(authoredUser);
        submitExecuteContext.setTmActivityId(tmActivityId);
        submitExecuteContext.setBacklogId(backlogId);
        submitExecuteContext.setProcessSerialNumber(processSerialNumber);
        submitExecuteContext.setApplication(application);

        String url = getAtdmUri() + WITH_META_DATA;
        url = appendTraceInfo(url, submitExecuteContext, actionId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        Map<String, Object> body = new HashMap<>();
        body.put("dataSourceSetDTO", map.get("dataSourceSet"));
        body.put("executeContext", map.get("executeContext"));
        body.put("parameter", map.get("parameter"));
        body.put("dataViewQuery", null);

        HttpEntity requestEntity = new HttpEntity<>(body, headers);

        ResponseEntity<BaseResultDTO<QueryResultSet>> apiResultDTO = restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                new ParameterizedTypeReference<BaseResultDTO<QueryResultSet>>() {
                });

        QueryResultSet queryResultSet = apiResultDTO.getBody().getResponseWithException("");

        Map<String, List<QueryResult>> group = queryResultSet.getQueryResults().stream().collect(Collectors.groupingBy(QueryResult::getDataSourceName));
        for (Map.Entry<String, List<QueryResult>> groupItem : group.entrySet()) {
            // add for 50243:全局参数没有dataKey等信息，也不需要设置重新设置主数据源
            if ("".equals(groupItem.getKey())) {
                continue;
            }
            List<QueryResult> resultList = groupItem.getValue();
            if (resultList.size() > 1) {
                QueryResult qr = resultList.get(0);
                for (int i = 1; i < resultList.size(); i++) {
                    qr.getData().addAll(resultList.get(i).getData());
                    qr.getDataKeyIndex().putAll(resultList.get(i).getDataKeyIndex());
                    //有可能第一个 QueryResult 没有查到数据，所以需要根据条件更新 DataKeys 和 ApiMetadataCollection
                    if (org.apache.commons.collections4.CollectionUtils.isEmpty(qr.getDataKeys()) && org.apache.commons.collections4.CollectionUtils.isNotEmpty(resultList.get(i).getDataKeys())) {
                        qr.setDataKeys(resultList.get(i).getDataKeys());
                    }
                    queryResultSet.getQueryResults().remove(resultList.get(i));
                }
            }
        }
        return queryResultSet;
    }

    private String getAtdmUri() {
        return DwBizConfig.AaskDomainConfig.Sai.getAtdmUri();
    }

    static String appendTraceInfo(String url, SubmitExecuteContext executeContext, String actionId) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (executeContext != null) {
            if (executeContext.getTmActivityId() != null) {
                stringBuilder.append(String.format("&TmActivityId=%s", executeContext.getTmActivityId()));
            }
            if (executeContext.getBacklogId() != null) {
                stringBuilder.append(String.format("&BacklogId=%s", executeContext.getBacklogId()));
            }
            if (executeContext.getAuthoredUser() != null) {
                stringBuilder.append(String.format("&author=%s-%s", executeContext.getAuthoredUser().getTenantId(), executeContext.getAuthoredUser().getUserId()));
            }
            if (executeContext.getProcessSerialNumber() != null) {
                stringBuilder.append(String.format("&processSerialNumber=%s", executeContext.getProcessSerialNumber()));
            }
        }
        if (actionId != null) {
            stringBuilder.append(String.format("&actionId=%s", actionId));
        }

        if (stringBuilder.length() > 0) {
            if (url.contains("?")) {
                return url + stringBuilder.substring(1);
            } else {
                return url + "?" + stringBuilder.substring(1);
            }
        } else {
            return url;
        }
    }
}
