package com.digiwin.athena.abt.application.service.atmc.migration.backlog;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.abt.application.dto.migration.atmc.bpm.BpmTaskApprovePreviousActivityDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.bpm.BpmTaskPreApproveRequestDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.ptm.PtmBacklogTransformService;
import com.digiwin.athena.abt.application.dto.migration.atmc.thememap.TmActivityResponseDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.atmc.migration.bk.BusinessKeyService;
import com.digiwin.athena.abt.application.service.atmc.migration.bpm.BpmWorkitemAppendixService;
import com.digiwin.athena.abt.application.service.atmc.migration.bpm.TaskEngineService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.core.meta.constants.ApiExecuteErrorConstant;
import com.digiwin.athena.abt.core.meta.constants.BpmConstant;
import com.digiwin.athena.abt.core.meta.constants.GlobalConstant;
import com.digiwin.athena.abt.core.meta.enums.*;
import com.digiwin.athena.abt.core.uiils.PatternCategoryUtil;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.PtmBacklogMapper;
import com.digiwin.athena.abt.infrastructure.mapper.biz.migration.atmc.SignInformMapper;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.ActivityDataBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmBacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.PtmWorkItemRecordBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmActivityWorkitem;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.BpmWorkitemAppendix;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.PtmBacklog;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.SignInform;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class BacklogActionCreateService extends BacklogActionCreateParentService {


    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    @Autowired
    private BusinessKeyService businessKeyService;

    @Autowired
    private BpmWorkitemAppendixService bpmWorkitemAppendixService;

    @Autowired
    private PtmBacklogTransformService ptmBacklogTransformService;

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private TaskEngineService taskEngineService;

    @Autowired
    private SignInformMapper signInformMapper;

    /**
     * @param authoredUser AuthoredUser
     * @param workitemId   long
     * @param isHistory    Boolean
     * @return Map<String, Object>
     * @description 默认方法
     */
    public Map<String, Object> getEditActions(AuthoredUser authoredUser, long workitemId,List<Long> workItemIds,Boolean isHistory) {
        return getEditActions(authoredUser, workitemId,workItemIds, isHistory, null);
    }

    public Map<String, Object> getEditActions(AuthoredUser authoredUser, long workitemId,Boolean isHistory) {
        return getEditActions(authoredUser, workitemId,null, isHistory, null);
    }




    /**
     * @param workitemId
     * @param workitemId          long
     * @param isHistory           Boolean
     * @param ptmWorkItemRecordBO
     * @return
     * @description 传递ptmWorkItemRecordDTO
     */
    public Map<String, Object> getEditActions(AuthoredUser authoredUser, long workitemId,List<Long> workItemIds, Boolean isHistory, PtmWorkItemRecordBO ptmWorkItemRecordBO) {

        ActivityDataBO backLogMap = null;
        List<ActivityDataBO> list = commonPtmTransformService.getActivityDataByBacklogId(workitemId,workItemIds, isHistory, ptmWorkItemRecordBO);
        // 为空抛异常
        if (CollectionUtils.isEmpty(list)) {
            throw AtmcErrorCodeEnum.ACTIVITY_CAN_NOT_FIND.getBusinessExceptionWithArgs(workitemId);
        }
        // todo:缺少ptm数据一致性逻辑
        /*如果是数据一致性的异常排除任务卡则查询其原任务卡的数据*/
        backLogMap = list.get(0);
        // 判断是否为逾时任务卡
        if (backLogMap.getOverdueWorkitemId() != null && backLogMap.getOverdueWorkitemId() > 0) {
            backLogMap.setTmTaskId(ApiExecuteErrorConstant.TM_TASK_ID);
            backLogMap.setTmActivityId(GlobalConstant.OVERDUE_WORKITEM_ACTIVITY_CODE);
            backLogMap.setTmPattern(GlobalConstant.OVERDUE_WORKITEM_PATTER);
            backLogMap.setTmCategory(GlobalConstant.OVERDUE_WORKITEM_CATEGORY);
            backLogMap.setTmShowFlow(false);
            backLogMap.setTmActivityName(GlobalConstant.OVERDUE_BACKLOG_NAME);
            backLogMap.setBacklogName(GlobalConstant.OVERDUE_BACKLOG_NAME);
            //逾时任务卡永远不用代理token
            backLogMap.setProxyToken(null);
        }

        for (ActivityDataBO activityDataBO : list) {
            if (backLogMap.getType() == 89) {
                activityDataBO.setBacklogName(GlobalConstant.DATA_UNIFORMITY_BACKLOG_NAME);
                activityDataBO.setPlanEndTime(null);
            }
        }

        Map<String, Object> map = getActions(list);
        map.put(BpmConstant.DATA_FROM_NAME, backLogMap.getDataFrom());

        processSolve(workitemId, backLogMap, map);
        processApproval(workitemId, backLogMap, map);
        processReplyInvite(workitemId, backLogMap.getTmCategory(), map);
        processApprove(backLogMap, map);
        // 增加签核知会信息
        processSignInform(workitemId, map);

        //添加退回重签信息
        map.put("reapprovalInfo", commonPtmTransformService.getReapprovalInfoById(workitemId, ptmWorkItemRecordBO));

        /*获取异动数据 start*/
        List<Long> workitemIdList = list.stream().map(ActivityDataBO::getWorkItemId).collect(Collectors.toList());
        List<Map> differentDataList = businessKeyService.queryDifferentDataByWorkitemId(authoredUser.getTenantId(), workitemIdList);
        List<BpmActivityWorkitem> dataUniformifyTask = businessKeyService.queryDataUniformifyTasks(workitemId);
        map.put("abnormalData", differentDataList);
        //异动数据主卡链接异动数据卡
        map.put("abnormalCards", dataUniformifyTask);
        /*获取异动数据 end*/
        map.put("type", backLogMap.getType());
        map.put("abnormalWorkitemId", workitemId);
        //获取唯一提交标识
        map.put("submitId", this.getSubmitId(workitemId));
        return map;
    }

    /**
     * 回复型任务注册邀请
     *
     * @param workitemId
     * @param tmCategory
     * @param map
     */
    private void processReplyInvite(long workitemId, String tmCategory, Map<String, Object> map) {
        if (Objects.equals(tmCategory, TmTaskCategoryEnum.REPLY.getValue())) {
            BpmWorkitemAppendix appendix = bpmWorkitemAppendixService.getByPtmBacklogId(workitemId);
            if (appendix != null && !Objects.equals(appendix.getErrorCode(), WorkitemAppendixType.ReSend.getValue())) {
                Map appendixMap = new HashMap();
                appendixMap.put("backlogId", appendix.getId());
                appendixMap.put("errorCode", appendix.getErrorCode());
                appendixMap.put("email", appendix.getEmail());
                appendixMap.put("supplierName", appendix.getSupplierName());

                List tasks = (List) map.get("tasks");
                if (!CollectionUtils.isEmpty(tasks)) {
                    Map task = (Map) tasks.get(0);
                    task.put("replyInvite", appendixMap);
                }
            }
        }
    }

    private void processSolve(long workitemId, ActivityDataBO backLogMap, Map<String, Object> map) {
        if (Objects.equals(TmTaskPatternEnum.BUSINESS.getValue(), backLogMap.getTmPattern())
                && Objects.equals(TmTaskCategoryEnum.SOLVE.getValue(), backLogMap.getTmCategory())) {
            //异常排除的，检查是否可以撤回
            JSONArray jsonArray = new JSONArray();
            Map<String, List<String>> startApproveMap = new HashMap<>();
            List<Map> actList = ptmBacklogTransformService.selectNoFinishedListByOriginBacklogIdForSolve(workitemId);
            for (Map m : actList) {
                JSONObject dataJson = JSONObject.fromObject(m.get("data"));
                if (!dataJson.containsKey("originalQueryVariableName")) {
                    continue;
                }
                String detailField = null;
                if (dataJson.containsKey("detailField") && dataJson.get("detailField") != null) {
                    detailField = dataJson.getString("detailField");
                }
                String tmTaskId = m.get("tm_task_id").toString();
                String tmActivityId = m.get("tm_activity_id").toString();
                List<String> startApproveIdList = null;
                if (startApproveMap.containsKey(tmActivityId)) {
                    //任务id相同，定义相同
                    startApproveIdList = startApproveMap.get(tmActivityId);
                } else {
                    startApproveIdList = getStartApproveActivity(tmTaskId, tmActivityId);
                    startApproveMap.put(tmActivityId, startApproveIdList);
                }

                if (!CollectionUtils.isEmpty(startApproveIdList) && startApproveIdList.contains(backLogMap.getTmActivityId())) {
                    //能撤回,如果是审核关卡，且审核关卡的发起任务ID是当前任务，能撤回
                    Map<String, Object> terminateMap = new HashMap<>();
                    terminateMap.put("serialNumber", m.get("processSerialNumber"));
                    terminateMap.put("performerId", m.get("personInCharge"));
                    terminateMap.put("performerType", 0);
                    terminateMap.put("comment", "");

                    JSONArray dataKeys = dataJson.getJSONArray(dataJson.getString("originalQueryVariableName"));
                    List<JSONObject> detailAllDataKeys = getDetailAllDataKeys(dataKeys, detailField);
                    for (int i = 0; i < dataKeys.size(); i++) {
                        JSONObject dkJson = dataKeys.getJSONObject(i);
                        if (detailField != null && dkJson.containsKey(detailField)) {
                            JSONArray subKeys = dkJson.getJSONArray(detailField);
                            for (Object o : subKeys) {
                                JSONObject kv = new JSONObject();
                                kv.put("dataKey", o);
                                kv.put("processParameter", terminateMap);
                                kv.put("allKey", detailAllDataKeys);
                                jsonArray.add(kv);
                            }
                        } else {
                            JSONObject kv = new JSONObject();
                            kv.put("dataKey", dkJson);
                            kv.put("processParameter", terminateMap);
                            kv.put("allKey", dataKeys);
                            jsonArray.add(kv);
                        }
                    }
                }
            }

            if (!CollectionUtils.isEmpty(jsonArray)) {
                List tasks = (List) map.get("tasks");
                if (!CollectionUtils.isEmpty(tasks)) {
                    tasks.forEach(task -> {
                        Map taskMap = (Map) task;
                        taskMap.put("abortDataKeys", jsonArray);
                    });
                }
            }
        }
    }


    /**
     * 获取签核信息
     *
     * @param backLogMap
     * @param map
     */
    private void processApprove(ActivityDataBO backLogMap, Map<String, Object> map) {
        if (backLogMap == null || StringUtils.isEmpty(backLogMap.getWorkitemList())
                || !PatternCategoryUtil.isApproval(backLogMap.getTmCategory())) {
            return;
        }

        //只处理签核
        JSONArray jsonArray = JSONArray.fromObject(backLogMap.getWorkitemList());
        String workItemId = jsonArray.getJSONObject(0).getString("workitemId");
        if (StringUtils.isEmpty(workItemId)) {
            return;
        }
        //是否已签核
        if (CollectionUtils.isEmpty(this.getPreApproveList(workItemId).getActivities())) {
            return;
        }
        map.put("hasApprove", true);
    }

    private Map<String, Object> getActions(List<ActivityDataBO> list) {
        if (CollectionUtils.isEmpty(list) || list.get(0) == null) {
            return null;
        }
        Map<String, Object> root = new HashMap<>();

        ActivityDataBO activityDataBO = list.get(0);
        Map<String, Object> project = new HashMap<>();
        root.put("project", project);
        project.put("projectId", activityDataBO.getTaskId());
        project.put("tmProjectId", activityDataBO.getTmTaskId());
        project.put("chargeId", activityDataBO.getChargeId());
        project.put("chargeName", activityDataBO.getChargeName());
        project.put("tenantId", activityDataBO.getTenantId());
        project.put("startTime", activityDataBO.getTaskStartTime());
        project.put("endTime", activityDataBO.getTaskEndTime());
        project.put("projectName", activityDataBO.getTaskName());
        project.put("processCreateTime", activityDataBO.getProcessCreateTime());
        project.put("projectBpmData", activityDataBO.getProjectBpmData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getProjectBpmData(), Map.class));
        // 项目卡id
        project.put("projectCardId", activityDataBO.getProjectCardId());
        // 项目卡状态
        project.put("projectCardState", activityDataBO.getProjectCardState());

        if (!StringUtils.isEmpty(activityDataBO.getTaskSourceIds())) {
            List<String> ids = new ArrayList<>();
            for (String item : activityDataBO.getTaskSourceIds().split(",")) {
                ids.add(item);
            }
            project.put("sourceIds", ids);
        }

        List<String> processSerialNumberList = new ArrayList<>();
        for (ActivityDataBO dataDTO : list) {
            String key = getBacklogKey(dataDTO);
            if (!processSerialNumberList.contains(key)) {
                processSerialNumberList.add(key);
            }
        }


        List<Map<String, Object>> tasks = new ArrayList<>();
        root.put("tasks", tasks);
        //性能优化，批量查submitid,避免重复查询
        Set<Long> ptmBacklogIdList = list.stream()
                .filter(obj -> Objects.nonNull(obj.getBacklogId()))
                .map(ActivityDataBO::getPtmBacklogId)
                .collect(Collectors.toSet());
        Map<Long, Integer> backlogSubmitIdMap = backLogSubmitIds(ptmBacklogIdList);
        for (String processSerialNumber : processSerialNumberList) {
            List<ActivityDataBO> activities = list.stream().filter(x -> getBacklogKey(x).equals(processSerialNumber)).sorted((o1, o2) -> {
                if (o1.getBacklogId() != null && o2.getBacklogId() != null) {
                    return o2.getBacklogId().compareTo(o1.getBacklogId());
                } else {
                    return o2.getBpmActivitySqlId().compareTo(o1.getBpmActivitySqlId());
                }
            }).collect(Collectors.toList());

            //降序排列，取最新的
            Collections.sort(activities, (o1, o2) -> {
                if (o1.getBacklogId() != null && o2.getBacklogId() != null) {
                    return o2.getBacklogId().compareTo(o1.getBacklogId());
                } else {
                    return o2.getBpmActivitySqlId().compareTo(o1.getBpmActivitySqlId());
                }
            });
            Optional<ActivityDataBO> activityOpt = activities.stream().findFirst();
            if (activityOpt.isPresent()) {
                activityDataBO = activityOpt.get();
            }

            Map<String, Object> taskObject = new HashMap<>();
            tasks.add(taskObject);
            taskObject.put("minSplit",activityDataBO.getCreatedFlag());
            taskObject.put("processSerialNumber", activityDataBO.getProcessSerialNumber());
            taskObject.put("bpmActivitySqlId", activityDataBO.getBpmActivitySqlId());
            taskObject.put("bpmData", activityDataBO.getBpmData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBpmData(), Map.class));
            taskObject.put("stateData", activityDataBO.getBpmStateData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBpmStateData(), Map.class));
            taskObject.put("tmActivityId", activityDataBO.getTmActivityId());
            taskObject.put("compositionId", activityDataBO.getCompositionId());
            taskObject.put("tmCategory", activityDataBO.getTmCategory());
            taskObject.put("tmPattern", activityDataBO.getTmPattern());
            taskObject.put("bpmActivityId", activityDataBO.getBpmActivityId());
            taskObject.put("bpmActivityType", activityDataBO.getBpmActivityType());
            taskObject.put("performerIds", activityDataBO.getPerformerIds() == null ? null : JsonUtils.jsonToObject(activityDataBO.getPerformerIds(), new ArrayList<String>().getClass()));
            taskObject.put("businessUnit", activityDataBO.getBusinessUnit() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBusinessUnit(), Map.class));
            taskObject.put("tmActivityName", activityDataBO.getTmActivityName());
            taskObject.put("proxyToken", activityDataBO.getProxyToken());
            taskObject.put("traceId", activityDataBO.getTraceId());
            taskObject.put("type", activityDataBO.getType());
            taskObject.put("taskUid", activityDataBO.getTaskUid());

            //增加营运单元信息
            List<String> eocNames = new ArrayList();
            if (!StringUtils.isEmpty(activityDataBO.getEocName()) && !eocNames.contains(activityDataBO.getEocName())) {
                eocNames.add(activityDataBO.getEocName());
            }
            taskObject.put("eocName", eocNames);

            if (!StringUtils.isEmpty(activityDataBO.getApprovalState())) {
                taskObject.put("approvalState", GlobalConstant.backlogStatusMap.getOrDefault(activityDataBO.getApprovalState(), ""));
                taskObject.put("isRapprovalInfoShow", activityDataBO.getApprovalState());
            }

            //backlog
            List<Map<String, Object>> backlogs = new ArrayList<>();
            taskObject.put("backlog", backlogs);

            for (ActivityDataBO dataDTO : activities) {
                if (dataDTO.getBacklogId() == null) {
                    continue;
                }
                Map<String, Object> backlog = new HashMap<>();
                backlogs.add(backlog);

                backlog.put("backlogId", dataDTO.getWorkItemId());
                // 执行者的租户id
                backlog.put("targetTenantId", dataDTO.getTargetTenantId());
                backlog.put("performerId", dataDTO.getPerformerId());
                backlog.put("performerName", dataDTO.getPerformerName());
                backlog.put("performerAgentId", dataDTO.getPerformerAgentId());
                backlog.put("performerAgentName", dataDTO.getPerformerAgentName());
                backlog.put("performerState", dataDTO.getPerformerState());
                backlog.put("readCount", dataDTO.getReadCount());
                backlog.put("startTime", dataDTO.getStartTime());
                backlog.put("planEndTime", dataDTO.getPlanEndTime());
                backlog.put("endTime", dataDTO.getEndTime());
                backlog.put("closed", dataDTO.getBacklogClosed());
                backlog.put("backlogName", dataDTO.getBacklogName());
                backlog.put("ptmBacklogId", dataDTO.getPtmBacklogId());
                backlog.put("submitId", backlogSubmitIdMap.get(dataDTO.getPtmBacklogId()));
                backlog.put("ptmWorkItemId", dataDTO.getPtmWorkItemId());
                backlog.put("merge", dataDTO.getMerge());
                backlog.put("planEndTimeMin", dataDTO.getPlanEndTimeMin());
                backlog.put("planEndTimeMax", dataDTO.getPlanEndTimeMax());
                backlog.put("createType", dataDTO.getCreateType());
                // 项目状态
                backlog.put("projectState", dataDTO.getProjectState());

                //增加营运单元信息
                if (!StringUtils.isEmpty(dataDTO.getEocName()) && !eocNames.contains(dataDTO.getEocName())) {
                    eocNames.add(dataDTO.getEocName());
                }

                if (dataDTO.getEndTime() == null) {
                    if (dataDTO.getMerge()) {
                        //倒计时
                        backlog.put("remainTime", TimeUtils.dateInterval(LocalDateTime.now(), dataDTO.getPlanEndTimeMin()));
                        //逾期
                        backlog.put("overdueDate", TimeUtils.dateInterval(dataDTO.getPlanEndTimeMin(), LocalDateTime.now()));
                    } else {
                        //倒计时
                        backlog.put("remainTime", TimeUtils.dateInterval(LocalDateTime.now(), dataDTO.getPlanEndTime()));
                        //逾期
                        backlog.put("overdueDate", TimeUtils.dateInterval(dataDTO.getPlanEndTime(), LocalDateTime.now()));
                    }
                }
                backlog.put("workitemList", dataDTO.getWorkitemList() == null ? null : JsonUtils.jsonToObject(dataDTO.getWorkitemList(), tasks.getClass()));
                //如果有就返回，不判断是否完成
                backlog.put("finishedActionId", parseFinishedActionId(dataDTO, (List<Map<String, Object>>) backlog.get("workitemList")));
                backlog.put("bpmSignReason", dataDTO.getStepSignReason());
                backlog.put("backlogPerformId", activityDataBO.getBacklogPerformId());
                //暂时只取一个，后期支持会签和或签的时候，还需要处理
                break;
            }
            backlogSubmitIdMap.clear();
        }
        return root;
    }

    private String getBacklogKey(ActivityDataBO activityDataBO){
        String key =  activityDataBO.getProcessSerialNumber()+activityDataBO.getTaskUid();
        if(BooleanUtils.isTrue(activityDataBO.getCreatedFlag())){
            key = key+"_"+activityDataBO.getWorkItemId();
        }
        return key;
    }

    /**
     * @param backlogIds Set<Long>
     * @return Map<Long, Integer>
     * @description 分批查询submitid, 正常来说子卡不会很多，这里主要是为了优化极端情况
     */
    protected Map<Long, Integer> backLogSubmitIds(Set<Long> backlogIds) {
        Map<Long, Integer> backLogSubmitIdsMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(backlogIds)) {
            return backLogSubmitIdsMap;
        }
        List<Long> backlogIdsList = Lists.newArrayList(backlogIds);
        //每次最多查50个
        int batchSize = 50;
        int modeSize = backlogIdsList.size() % batchSize;
        int batchNums = backlogIdsList.size() / batchSize + (modeSize == 0 ? 0 : 1);
        int idx = 0;
        while (idx < batchNums) {
            int start = idx * batchSize;
            int end = start + (modeSize != 0 && idx == (batchNums - 1) ? modeSize : batchSize);
            idx++;
            List<Long> batchList = new ArrayList(backlogIdsList.subList(start, end));
            //性能优化，select * 改为只查询两个字段
            List<PtmBacklogBO> backlogList = ptmBacklogMapper.selectSubIdsBatByBackIds(batchList);
            if (CollectionUtils.isEmpty(backlogList)) {
                continue;
            }
            backlogList.stream().forEach(backlog -> backLogSubmitIdsMap.put(backlog.getBacklogId(), backlog.getSubmitId()));
        }
        return backLogSubmitIdsMap;
    }

    /**
     * 获取提交唯一键
     *
     * @param workItemId
     * @return
     */
    private Integer getSubmitId(Long workItemId) {
        Integer submitId = null;
        if (workItemId != null) {
            PtmBacklog ptmBacklog = commonPtmTransformService.getBacklogByIdFromDb(workItemId);
            submitId = ptmBacklog != null ? ptmBacklog.getSubmitId() : null;
        }
        return submitId;
    }

    private List<String> getStartApproveActivity(String tmTaskId, String tmActivityId) {

        TmActivityResponseDTO resonse = themeMapService.getActivityAction(tmTaskId, tmActivityId, TmPageName.TASK_CARD_NAME.getValue());
        return resonse.getStartApproveActivity();
    }

    private List<JSONObject> getDetailAllDataKeys(JSONArray dataKeys, String detailField) {
        List<JSONObject> result = new ArrayList<>();

        for (int i = 0; i < dataKeys.size(); i++) {
            JSONObject dkJson = dataKeys.getJSONObject(i);
            if (detailField != null && dkJson.containsKey(detailField)) {
                result.addAll(dkJson.getJSONArray(detailField));
            }
        }
        return result;
    }

    private void processSignInform(long workitemId, Map<String, Object> map) {
        // 上下文 authoredUser 信息
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        QueryWrapper<SignInform> signInformQueryWrapper = new QueryWrapper<>();
        signInformQueryWrapper.eq("resource_id", workitemId)
                .eq("resource_type", "backlog")
                .eq("tenant_id", authoredUser.getTenantId())
                .last(" limit 1");
        SignInform signInform = signInformMapper.selectOne(signInformQueryWrapper);
        if (signInform == null || org.apache.commons.lang.StringUtils.isBlank(signInform.getSignAfter())) {
            return;
        }
        List tasks = (List) map.get("tasks");
        if (!CollectionUtils.isEmpty(tasks)) {
            for (Object task : tasks) {
                Map taskMap = (Map) task;
                taskMap.put("informer", signInform.getSignAfter());
            }
        }
    }

    private BpmTaskApprovePreviousActivityDTO getPreApproveList(String workItemId) {
        BpmTaskPreApproveRequestDTO requestDTO = BpmTaskPreApproveRequestDTO.builder()
                .locale(LocaleContextHolder.getLocale().toLanguageTag())
                .workitemId(workItemId)
                .build();
        return taskEngineService.queryPreApprove(requestDTO);
    }

    /**
     * 解析导致任务卡关闭的actionId
     *
     * @return
     */
    private String parseFinishedActionId(ActivityDataBO activityData, List<Map<String, Object>> tasks) {
        // finishedActionId不为空 或 任务卡未关闭
        if (StringUtils.hasText(activityData.getFinishedActionId())
                || (!Objects.equals(ActivityState.COMPLETED.getCode(), activityData.getStepState())) && BooleanUtils.isNotTrue(activityData.getBacklogClosed())) {
            return activityData.getFinishedActionId();
        }

        String finishedActionId = null;
        //如果没有结束按钮，且已结束，特殊处理终止、撤销等状态
        // 已撤销
        if (Objects.equals(ActivityWorkitemSubState.END_TASK_UNDO.getValue(), activityData.getStepSubState())) {
            finishedActionId = "athena_bpm_cancel";
        }
        // 已交接
        else if (isBacklogClosedCausedByHandover(tasks)) {
            finishedActionId = "uibot_action_id_handover";
        }
        // 其他情况，赋值已结束
        else {
            finishedActionId = "uibot_action_id_finished";
        }

        return finishedActionId;
    }

    public Map<String, Object> getEditActions(AuthoredUser authoredUser, List<Map<String, Object>> workitemIds, Boolean isHistory,boolean isAllQuery) {
        List<ActivityDataBO> list = commonPtmTransformService.getActivityDataByBacklogId(workitemIds, isHistory,isAllQuery);
        Map<String, Object> map = getActionsBatch(list);
        return map;
    }

    private Map<String, Object> getActionsBatch(List<ActivityDataBO> list) {

        if (CollectionUtils.isEmpty(list) || list.get(0) == null) {
            return null;
        }
        Map<String, Object> root = new HashMap<>();

        //这个list里面的activityDataDto是不是有要求，比如说：projectId相同？
        ActivityDataBO activityDataBO = list.get(0);
        Map<String, Object> project = new HashMap<>();
        root.put("project", project);
        project.put("projectId", activityDataBO.getTaskId());
        project.put("tmProjectId", activityDataBO.getTmTaskId());
        project.put("chargeId", activityDataBO.getChargeId());
        project.put("chargeName", activityDataBO.getChargeName());
        project.put("tenantId", activityDataBO.getTenantId());
        project.put("startTime", activityDataBO.getTaskStartTime());
        project.put("endTime", activityDataBO.getTaskEndTime());
        project.put("projectName", activityDataBO.getTaskName());
        project.put("processCreateTime", activityDataBO.getProcessCreateTime());
        project.put("projectBpmData", activityDataBO.getProjectBpmData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getProjectBpmData(), Map.class));

        if (!StringUtils.isEmpty(activityDataBO.getTaskSourceIds())) {
            List<String> ids = new ArrayList<>();
            for (String item : activityDataBO.getTaskSourceIds().split(",")) {
                ids.add(item);
            }
            project.put("sourceIds", ids);
        }

        List<String> processSerialNumberList = new ArrayList<>();
        for (ActivityDataBO dataDTO : list) {
            String key = dataDTO.getProcessSerialNumber() + dataDTO.getTaskUid();
            if (!processSerialNumberList.contains(key)) {
                processSerialNumberList.add(key);
            }
        }


        List<Map<String, Object>> tasks = new ArrayList<>();
        root.put("tasks", tasks);
        for (String processSerialNumber : processSerialNumberList) {
            List<ActivityDataBO> activities = list.stream().filter(x -> (x.getProcessSerialNumber() + x.getTaskUid()).equals(processSerialNumber))
                    .collect(Collectors.toList());

            //降序排列，取最新的
            Collections.sort(activities, (o1, o2) -> {
                if (o1.getBacklogId() != null && o2.getBacklogId() != null) {
                    return o2.getBacklogId().compareTo(o1.getBacklogId());
                } else {
                    return o2.getBpmActivitySqlId().compareTo(o1.getBpmActivitySqlId());
                }
            });
            Optional<ActivityDataBO> activityOpt = activities.stream().findFirst();
            if (activityOpt.isPresent()) {
                activityDataBO = activityOpt.get();
            }

            Map<String, Object> taskObject = new HashMap<>();
            tasks.add(taskObject);

            taskObject.put("tmTaskId", activityDataBO.getTmTaskId());
            taskObject.put("processSerialNumber", activityDataBO.getProcessSerialNumber());
            taskObject.put("bpmActivitySqlId", activityDataBO.getBpmActivitySqlId());
            taskObject.put("bpmData", activityDataBO.getBpmData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBpmData(), Map.class));
            taskObject.put("stateData", activityDataBO.getBpmStateData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBpmStateData(), Map.class));
            taskObject.put("tmActivityId", activityDataBO.getTmActivityId());
            taskObject.put("compositionId", activityDataBO.getCompositionId());
            taskObject.put("tmCategory", activityDataBO.getTmCategory());
            taskObject.put("tmPattern", activityDataBO.getTmPattern());
            taskObject.put("bpmActivityId", activityDataBO.getBpmActivityId());
            taskObject.put("bpmActivityType", activityDataBO.getBpmActivityType());
            taskObject.put("performerIds", activityDataBO.getPerformerIds() == null ? null : JsonUtils.jsonToObject(activityDataBO.getPerformerIds(), new ArrayList<String>().getClass()));
            taskObject.put("businessUnit", activityDataBO.getBusinessUnit() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBusinessUnit(), Map.class));
            taskObject.put("tmActivityName", activityDataBO.getTmActivityName());
            taskObject.put("proxyToken", activityDataBO.getProxyToken());
            taskObject.put("traceId", activityDataBO.getTraceId());
            taskObject.put("type", activityDataBO.getType());
            taskObject.put("taskUid", activityDataBO.getTaskUid());
            taskObject.put("backlogId", activityDataBO.getBacklogId());
            taskObject.put("ptmActivityId", activityDataBO.getPtmActivityId());

            //增加营运单元信息
            List<String> eocNames = new ArrayList();
            if (!StringUtils.isEmpty(activityDataBO.getEocName()) && !eocNames.contains(activityDataBO.getEocName())) {
                eocNames.add(activityDataBO.getEocName());
            }
            taskObject.put("eocName", eocNames);

            if (!StringUtils.isEmpty(activityDataBO.getApprovalState())) {
                taskObject.put("approvalState", GlobalConstant.backlogStatusMap.getOrDefault(activityDataBO.getApprovalState(), ""));
                taskObject.put("isRapprovalInfoShow", activityDataBO.getApprovalState());
            }

            //backlog
            List<Map<String, Object>> backlogs = new ArrayList<>();
            taskObject.put("backlog", backlogs);

            for (ActivityDataBO dataDTO : activities) {
                if (dataDTO.getBacklogId() == null) {
                    continue;
                }

//                PtmBacklog ptmBacklog = ptmBacklogMapper.selectById(dataDTO.getPtmBacklogId());

                Map<String, Object> backlog = new HashMap<>();
                backlogs.add(backlog);

                backlog.put("backlogId", dataDTO.getWorkItemId());
                // 执行者的租户id
                backlog.put("targetTenantId", dataDTO.getTargetTenantId());
                backlog.put("performerId", dataDTO.getPerformerId());
                backlog.put("performerName", dataDTO.getPerformerName());
                backlog.put("performerAgentId", dataDTO.getPerformerAgentId());
                backlog.put("performerAgentName", dataDTO.getPerformerAgentName());
                backlog.put("performerState", dataDTO.getPerformerState());
                backlog.put("readCount", dataDTO.getReadCount());
                backlog.put("startTime", dataDTO.getStartTime());
                backlog.put("planEndTime", dataDTO.getPlanEndTime());
                backlog.put("endTime", dataDTO.getEndTime());
                backlog.put("closed", dataDTO.getBacklogClosed());
                backlog.put("backlogName", dataDTO.getBacklogName());
                backlog.put("ptmBacklogId", dataDTO.getPtmBacklogId());
//                backlog.put("submitId",ptmBacklog != null ? ptmBacklog.getSubmitId() : null);
                backlog.put("ptmWorkItemId", dataDTO.getPtmWorkItemId());
                backlog.put("merge", dataDTO.getMerge());
                backlog.put("planEndTimeMin", dataDTO.getPlanEndTimeMin());
                backlog.put("planEndTimeMax", dataDTO.getPlanEndTimeMax());
                backlog.put("createType", dataDTO.getCreateType());

                //增加营运单元信息
                if (!StringUtils.isEmpty(dataDTO.getEocName()) && !eocNames.contains(dataDTO.getEocName())) {
                    eocNames.add(dataDTO.getEocName());
                }

                if (dataDTO.getEndTime() == null) {
                    if (dataDTO.getMerge()) {
                        //倒计时
                        backlog.put("remainTime", TimeUtils.dateInterval(LocalDateTime.now(), dataDTO.getPlanEndTimeMin()));
                        //逾期
                        backlog.put("overdueDate", TimeUtils.dateInterval(dataDTO.getPlanEndTimeMin(), LocalDateTime.now()));
                    } else {
                        //倒计时
                        backlog.put("remainTime", TimeUtils.dateInterval(LocalDateTime.now(), dataDTO.getPlanEndTime()));
                        //逾期
                        backlog.put("overdueDate", TimeUtils.dateInterval(dataDTO.getPlanEndTime(), LocalDateTime.now()));
                    }
                }
                backlog.put("workitemList", dataDTO.getWorkitemList() == null ? null : JsonUtils.jsonToObject(dataDTO.getWorkitemList(), tasks.getClass()));
                //如果有就返回，不判断是否完成
                backlog.put("finishedActionId", dataDTO.getFinishedActionId());
                if (StringUtils.isEmpty(dataDTO.getFinishedActionId()) && Objects.equals(3, dataDTO.getStepState())) {
                    //如果没有结束按钮，且已结束，特殊处理终止、撤销等状态
                    if (Objects.equals(ActivityWorkitemSubState.END_TASK_UNDO.getValue(), dataDTO.getStepSubState())) {
                        //已撤销
                        backlog.put("finishedActionId", "athena_bpm_cancel");
                    } else {
                        //其他情况，赋值已结束
                        backlog.put("finishedActionId", "uibot_action_id_finished");
                    }
                }
                backlog.put("bpmSignReason", dataDTO.getStepSignReason());
                backlog.put("backlogPerformId", activityDataBO.getBacklogPerformId());
                //暂时只取一个，后期支持会签和或签的时候，还需要处理
                break;
            }
        }
        return root;
    }

    /**
     * 任务卡关闭是否为交接导致
     *
     * @param tasks
     * @return
     */
    private boolean isBacklogClosedCausedByHandover(List<Map<String, Object>> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return false;
        }

        return tasks.stream().filter(task -> Objects.equals(ActivityWorkitemSubState.HANDOVER.getCode(), task.get("subState"))).count() > 0;
    }

    public Map<String, Object> getEditActions(AuthoredUser authoredUser, List<Map<String, Object>> workitemIds, Boolean isHistory) {
        return getEditActions(authoredUser,workitemIds,isHistory,false);
    }

}
