package com.digiwin.athena.abt.application.service.atmc.migration.backlog;

import cn.hutool.core.collection.CollUtil;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.PageUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.BacklogCardField;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardAbstractDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.CardConfigDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.backlog.TaskCardDTO;
import com.digiwin.athena.abt.application.dto.migration.atmc.project.ProjectCardDTO;
import com.digiwin.athena.abt.application.service.abt.migration.ptm.CommonPtmTransformService;
import com.digiwin.athena.abt.application.service.abt.migration.restfull.atmc.AtmcService;
import com.digiwin.athena.abt.application.service.atmc.migration.atdm.AtdmService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.aglie.AglieService;
import com.digiwin.athena.abt.application.service.atmc.migration.restfull.thememap.ThemeMapService;
import com.digiwin.athena.abt.application.utils.BacklogAbstractUtil;

import com.digiwin.athena.abt.core.concurrent.pool.DynamicThreadPool;
import com.digiwin.athena.abt.infrastructure.pojo.bo.migration.atmc.BacklogBO;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.CardColumn;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.QueryResultSet;
import com.digiwin.athena.abt.infrastructure.pojo.po.migration.atmc.TaskDefCodeData;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.concurrent.JaRunnable;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

import javax.annotation.Resource;
import java.util.*;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * Description 批量查询
 * Author hebaokai
 * Date 2024/2/29 15:11
 **/
@Service
@Data
@Slf4j
public class BacklogBatchQueryBusinessDataService {

    @Autowired
    private AtmcService atmcService;

    @Autowired
    private ThemeMapService themeMapService;

    @Resource
    private BacklogAbstractUtil backlogAbstractUtil;

    @Resource
    private TodoBacklogQueryService backlogCardQueryService;

    @Autowired
    private BacklogActionCreateService backlogActionCreateService;

    @Autowired
    private AglieService aglieService;

    @Autowired
    private AtdmService atdmService;

    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    private DynamicThreadPool taskExecutor;

    public static final String CARD_BUSINESS_MESSAGE = "cardBusinessMessage";

    public static final String NON_REAL_TIME = "NON_REAL_TIME";

    public static final String PARTITION_SIZE = "abt.dataField.partitionSize";

    /**
     * 批量设置BusinessMessage-项目
     *
     * @param cardList
     * @param user
     * @param pageCode
     */
    public void setBusinessMessageForProject(List<ProjectCardDTO> cardList, AuthoredUser user, String pageCode) {
        if (!atmcService.verifyConfig(CARD_BUSINESS_MESSAGE, CARD_BUSINESS_MESSAGE)) {
            return;
        }
        // 非实时，读取数据库
        List<ProjectCardDTO> nonRealTimeCardList = cardList.stream()
                .filter(card -> NON_REAL_TIME.equals(card.getBusinessMessageSourceMethod()))
                .collect(Collectors.toList());
        // 分批查询业务数据
        int pageSize = 10;
        int totalPage = PageUtil.totalPage(nonRealTimeCardList.size(), pageSize);
        for (int i = 0; i < totalPage; i++) {
            List<ProjectCardDTO> cardListSub = CollUtil.sub(nonRealTimeCardList, i * pageSize, (i + 1) * pageSize);
            List<Long> backlogIdList = cardListSub.stream().map(ProjectCardDTO::getId).collect(Collectors.toList());
            Map<Long, Map<String, List<String>>> batchBusinessMessage =
                    backlogAbstractUtil.getAndBuildBusinessMessage(backlogIdList, pageCode, user.getTenantId());
            // 根据cardId回填业务数据
            cardListSub.forEach(card -> card.setBusinessMessage(batchBusinessMessage.get(card.getId())));
        }
    }

    public Map<Long, Object> addDataFieldsByBacklogId(Long backlogId, String tmActivityId, AuthoredUser user) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("km rule process time");
        Map<String, Object> taskCardOptimizeRules = themeMapService.getTaskCardOptimizeRules();
        stopWatch.stop();
        log.info(" process time get km rule data :{}", stopWatch.prettyPrint());
        List<TaskDefCodeData> groupRuleList = getGroupRuleList(taskCardOptimizeRules);
        List<String> taskCodeList = groupRuleList.stream().map(TaskDefCodeData::getTaskCode).collect(Collectors.toList());
        List<Map<String, Object>> labelRuleList = (List<Map<String, Object>>) taskCardOptimizeRules.get("labelRule");
        List<CardColumn> columnRuleList = getColumnRuleList(taskCardOptimizeRules);
        labelRuleList.forEach(e -> taskCodeList.add(e.get("taskCode").toString()));
        List<Map> orderRuleList = getOrderRuleList(taskCardOptimizeRules);
//        orderRuleList.forEach(e -> taskCodeList.add(e.get("taskCode").toString()));
        columnRuleList.forEach(e -> taskCodeList.add(e.getTaskCode()));
        Map<String, Object> orderMap = orderRuleList.stream()
                .collect(Collectors.toMap(e -> e.get("taskCode").toString(), a -> a, (k1, k2) -> k1));
        List<TaskCardDTO> backlogIds = new ArrayList<>();
        TaskCardDTO taskCardDTO = new TaskCardDTO();
        taskCardDTO.setBacklogId(backlogId);
        taskCardDTO.setTmActivityId(tmActivityId);
        backlogIds.add(taskCardDTO);
        Map<Long, Object> dataFieldMap = getSingleDataFieldMap(backlogIds, user, taskCodeList, groupRuleList, labelRuleList, columnRuleList);
        Map<String, Object> businessDataMap = (Map<String, Object>) dataFieldMap.get(backlogId);
        if (businessDataMap == null) {
            //业务数据查询出现异常
            businessDataMap = new HashMap<>();
        }
        businessDataMap.put("order", generateOrder(tmActivityId, orderMap));
        Map<Long, Object> result = new HashMap<>();
        result.put(backlogId, businessDataMap);
        return result;
    }

    private List<TaskDefCodeData> getGroupRuleList(Map<String, Object> map) {
        Object groupRule = map.get("groupRule");
        cn.hutool.json.JSONObject groupRuleJson = JSONUtil.parseObj(groupRule);
        Object groupType = groupRuleJson.get("groupType");
        cn.hutool.json.JSONObject groupTypeJson = JSONUtil.parseObj(groupType);
        cn.hutool.json.JSONArray jsonArray = JSONUtil.parseArray(groupTypeJson.get("businessKey"));
        return JSONUtil.toList(jsonArray, TaskDefCodeData.class);
    }

    private List<CardColumn> getColumnRuleList(Map<String, Object> map) {
        Object groupRule = map.get("columnRule");
        cn.hutool.json.JSONArray columnArray = JSONUtil.parseArray(groupRule);
        return JSONUtil.toList(columnArray, CardColumn.class);
    }

    private List<Map> getOrderRuleList(Map<String, Object> map) {
        Object orderRule = map.get("orderRule");
        cn.hutool.json.JSONArray orderRuleArray = JSONUtil.parseArray(orderRule);
        return JSONUtil.toList(orderRuleArray, Map.class);
    }

    private Map<String, Integer> generateOrder(String tmActivityId, Map<String, Object> orderMap) {
        Map<String, Integer> map = new HashMap();
        Map<String, Object> orderData = (Map) orderMap.get(tmActivityId);
        map.put("taskOrderWeight", orderData == null ? 9999 : Integer.parseInt(orderData.get("orderWeight").toString()));
        return map;
    }

    private Map<Long, Object> getSingleDataFieldMap(List<TaskCardDTO> list, AuthoredUser user, List<String> taskCodeList, List<TaskDefCodeData> groupRuleList, List<Map<String, Object>> labelRuleList, List<CardColumn> columnRuleList) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("km definition process time");
        Map<String, List<String>> activityDefinitionMap = themeMapService.getActivityDefinitionList(list.stream()
                .map(TaskCardDTO::getTmActivityId)
                .filter(tmActivityId -> taskCodeList.contains(tmActivityId)).distinct().collect(Collectors.toList()));
        stopWatch.stop();
        log.info(" process time get km definition time :{}", stopWatch.prettyPrint());
        log.info(" process time get km definition data :{}", activityDefinitionMap);

        List<Map<String, Object>> dataList = new ArrayList<>();
        list.stream().filter(e -> taskCodeList.contains(e.getTmActivityId())).forEach(e -> {
            Map<String, Object> map = new HashMap<>();
            map.put("backlogId", e.getBacklogId());
            map.put("keys", activityDefinitionMap.get(e.getTmActivityId()));
            dataList.add(map);
        });
        Map<Long, Object> dataFieldMap = new HashMap<>();
        //如果datalist为空不走下面逻辑
        if (CollectionUtils.isEmpty(dataList)) {
            return dataFieldMap;
        }

        Map<String, Object> editActions = backlogActionCreateService.getEditActions(user, dataList, false);
        log.info(" get actions data from ptm :{}", editActions);
        processData(editActions.get("project"), (List<Map>) editActions.get("tasks"), dataFieldMap, user, groupRuleList, labelRuleList, columnRuleList);
        return dataFieldMap;
    }

    private void processData(Object project, List<Map> tasks, Map<Long, Object> dataFieldMap, AuthoredUser user, List<TaskDefCodeData> groupRuleList, List<Map<String, Object>> labelRuleList, List<CardColumn> columnRuleList) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(" process single time tasks size:" + tasks.size());
        Map<String, Object> activityMap = new HashMap<>();
        activityMap.put("project", project);
        String tmTaskId = tasks.get(0).get("tmTaskId").toString();
        String tmActivityId = tasks.get(0).get("tmActivityId").toString();
        activityMap.put("tasks", tasks);
        JSONArray tmTaskAndActivityBk = themeMapService.getTmTaskAndActivityBk("activity", tmActivityId, user);
        String bkConcat = "";
        String dataName = "";
        try {
            List<String> segmentList = new ArrayList<>();
            JSONArray bks = ((JSONObject) tmTaskAndActivityBk.get(0)).getJSONArray("bk");
            JSONObject bk = (JSONObject) bks.get(0);
            dataName = bk.getString("dataName");
            JSONArray fields = bk.getJSONArray("field");
            fields.stream().forEach(e -> {
                JSONObject field = (JSONObject) e;
                String segment = field.getString("dataName");
                segmentList.add(segment);
            });
            bkConcat = Joiner.on("$&").join(segmentList);
            List<String> bkList = Arrays.asList(bkConcat.split("\\$&"));
            Map<String, Long> bkBacklogMap = buildBkBacklogMap(activityMap, bkConcat, dataName);
            BaseResultDTO<Map> actionResponse = aglieService.getTaskCardAbstractStrBatch(tmTaskId,
                    tmActivityId, bkConcat, activityMap);
            Map pageDataMap = actionResponse.getResponse();
            QueryResultSet resultSet = atdmService.getResultSet(pageDataMap, user);
            Map<String, Object> executeContext = (Map<String, Object>) pageDataMap.get("executeContext");
            String application = executeContext.get("application").toString();
            Map<String, Map<String, Object>> dataFields = backlogCardQueryService.getDataFields(columnRuleList, application, labelRuleList, groupRuleList, resultSet, bkList, tmActivityId);
            for (Map.Entry<String, Map<String, Object>> pdmEntry : dataFields.entrySet()) {
                Long backlogId = bkBacklogMap.get(pdmEntry.getKey());
                dataFieldMap.put(backlogId, pdmEntry.getValue());
            }
        } catch (Exception e) {
            log.error("【parse BK failure:{} 】", tmTaskAndActivityBk);
        }
        stopWatch.stop();
        log.info("process data included servers 【km;uibot;atdm】:{}", stopWatch.prettyPrint());
    }

    private Map<String, Long> buildBkBacklogMap(Map<String, Object> activityMap, String bkContact, String dataName) {
        String[] list = bkContact.split("\\$&");
        List<Map<String, Object>> tasks = (List<Map<String, Object>>) activityMap.get("tasks");
        Map<String, Long> result = new HashMap<>();
        tasks.forEach(e -> {
            if (e.get("bpmData") != null) {
                Object inParams = ((Map<String, Object>) e.get("bpmData")).get(dataName);
                ((List<Map<String, String>>) inParams).forEach(el -> {
                    List<String> bks = new ArrayList<>();
                    for (String s : list) {
                        if (el.get(s) != null) {
                            bks.add(el.get(s));
                        }
                    }
                    String bk = Joiner.on("$&").join(bks);
                    result.put(bk, (long) e.get("backlogId"));
                });
            }
        });

        return result;
    }

    public void setBusinessMessage(TaskCardDTO taskCardDTO, AuthoredUser user, String pageCode) {
        if (!atmcService.verifyConfig(CARD_BUSINESS_MESSAGE, CARD_BUSINESS_MESSAGE)) {
            return;
        }
        //非实时，退出
        if (!NON_REAL_TIME.equals(taskCardDTO.getBusinessMessageSourceMethod())) {
            return;
        }

        //构建查询参数
        Map activityDataMap = null;
        BacklogBO backlogBO = commonPtmTransformService.selectBacklogForCard(taskCardDTO.getBacklogId());
        if (backlogBO != null && backlogBO.getTmActivityId() != null) {
            Object activityData = backlogActionCreateService.getEditActions(user, backlogBO.getId(), null);
            if (activityData instanceof Map) {
                activityDataMap = (Map) activityData;
                activityDataMap.put("businessMessageSourceType", CardAbstractDTO.SOURCE_TYPE_API);
                activityDataMap.put("cardId", taskCardDTO.getBacklogId());
                activityDataMap.put("pageCode", pageCode);
                activityDataMap.put("tmTaskId", backlogBO.getTmTaskId());
                activityDataMap.put("tmActivityId", backlogBO.getTmActivityId());
                activityDataMap.put("tenantId", user.getTenantId());
            }
        }

        //查询业务数据
        if (activityDataMap != null) {
            Map<String, Object> businessMessage = backlogAbstractUtil.getBusinessMessage(activityDataMap);
            //Map<String, List<String>> tempBusinessMessage = businessMessage.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (List<String>) e.getValue()));
            /**
             * 获取数据格式如下：
             * "this_is_weather.wea_id__wea_id": [
             *  "0.32"
             * ]
             * 需要修改为{
             * 	"wea_id" : [ "0.32" ]
             * }
             * mqtt刷新自定义列才认识
             */
            BacklogCardField backlogCardField = backlogAbstractUtil.buildBacklogCardField(taskCardDTO.getBacklogId(), pageCode, user.getTenantId(), businessMessage);
            if (CollectionUtils.isNotEmpty(backlogCardField.getValueList())) {
                Map<String, List<String>> businessMessageMap = backlogCardField.getValueList().get(0).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey,
                        e -> e.getValue().stream().map(String::valueOf).collect(Collectors.toList())));
                //回填业务数据
                taskCardDTO.setBusinessMessage(businessMessageMap);
            }
        }
    }

    public void addDataFields(List<TaskCardDTO> list, AuthoredUser user) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("km rule process time");
        Map<String, Object> taskCardOptimizeRules = themeMapService.getTaskCardOptimizeRules();
        stopWatch.stop();
        log.info(" process time get km rule data :{}", stopWatch.prettyPrint());
        List<TaskDefCodeData> groupRuleList = getGroupRuleList(taskCardOptimizeRules);
        // 所有的 taskCode
        List<String> taskCodeList = groupRuleList.stream().map(TaskDefCodeData::getTaskCode).collect(Collectors.toList());
        // label
        List<Map<String, Object>> labelRuleList = (List<Map<String, Object>>) taskCardOptimizeRules.get("labelRule");
        // column
        List<CardColumn> columnRuleList = getColumnRuleList(taskCardOptimizeRules);
        labelRuleList.forEach(e -> taskCodeList.add(e.get("taskCode").toString()));
        // order
        List<Map> orderRuleList = getOrderRuleList(taskCardOptimizeRules);
//        orderRuleList.forEach(e -> taskCodeList.add(e.get("taskCode").toString()));
        columnRuleList.forEach(e -> taskCodeList.add(e.getTaskCode()));
        Map<String, Object> orderMap = orderRuleList.stream()
                .collect(Collectors.toMap(e -> e.get("taskCode").toString(), a -> a, (k1, k2) -> k1));
        try {
            Object businessMessageSourceMethodMap = taskCardOptimizeRules.get("businessMessageSourceMethodMap");
            cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(businessMessageSourceMethodMap);
            Set<String> businessMessageSourceMethodNotRealTimeTaskCodes = jsonObject.keySet();
            HashSet<String> callDataFieldTaskCodeList = new HashSet<>(taskCodeList);
            callDataFieldTaskCodeList.removeAll(businessMessageSourceMethodNotRealTimeTaskCodes);
            Map<Long, Object> dataFieldMap = getDataFieldMap(list, user, new ArrayList<>(callDataFieldTaskCodeList), groupRuleList, labelRuleList, columnRuleList);
            log.info("【dataFiledMap-data: {}】", dataFieldMap);
            HashMap<String, List<CardColumn>> cardColumnMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(columnRuleList)) {
                cardColumnMap.putAll(columnRuleList.stream().filter(o -> StringUtils.isNotBlank(o.getTaskCode()))
                        .collect(Collectors.groupingBy(o -> o.getTaskCode())));
            }
            list.forEach(e -> {
                if (businessMessageSourceMethodNotRealTimeTaskCodes.contains(e.getTmActivityId())) {
                    e.setBusinessMessageSourceMethod(NON_REAL_TIME);

                    //遍历CardConfigDTO配置
                    List<CardConfigDTO> beanList = jsonObject.getBeanList(e.getTmActivityId(), CardConfigDTO.class);
                    for (int i = beanList.size() - 1; i >= 0; i--) {
                        CardConfigDTO cardConfigDTO = beanList.get(i);

                        if (cardConfigDTO.getConfig() == null) {
                            continue;
                        }

                        CardConfigDTO.Config config = cardConfigDTO.getConfig();

                        //Label结构下defaultEffective为false,Label结构不用输出，清空
                        if (this.isDefaultEffectiveFalse(config)) {
                            config.setLabel(null);
                        }

                        //如果config结构下属性都是空，这个CardConfigDTO就无需存在
                        //这样的数据只有配置了标签，然后交付设计器又不显示这个标签才存在，其他都为空，从km平台获取的就是空的内容，不会走到这里。
                        if (this.configIsEmpty(config)) {
                            beanList.remove(i);
                        }
                    }

                    e.setCardConfig(beanList);
                } else {

                    if (dataFieldMap.get(e.getBacklogId()) != null) {
                        try {
                            adaptCardConfig(cardColumnMap, dataFieldMap, e);
                        } catch (Exception ex) {
                            log.error("adaptCardConfig error,", ex);
                        }
                    }
                }
                if (dataFieldMap.get(e.getBacklogId()) != null) {
                    Map<String, Object> dataField = (Map<String, Object>) dataFieldMap.get(e.getBacklogId());
                    e.setGroup((Map<String, String>) dataField.get("group"));
                    e.setLabels((List<Map<String, Object>>) dataField.get("label"));
                    e.setColumns((List<Map<String, Object>>) dataField.get("columns"));
                }
                e.setOrder(generateOrder(e.getTmActivityId(), orderMap));
            });
            Map<String, List<TaskCardDTO>> listMap = list.stream().collect(Collectors.groupingBy(TaskCardDTO::getTmActivityId));
            Map<String, List<CardConfigDTO>> taskCodeConfigMap = new HashMap<>();
            for (Map.Entry<String, List<TaskCardDTO>> entry : listMap.entrySet()) {
                List<TaskCardDTO> taskCardDTOList = entry.getValue();
                List<CardConfigDTO> configDTOS = combine(taskCardDTOList);
                taskCodeConfigMap.put(entry.getKey(), configDTOS);
            }
            list.forEach(o -> {
                o.setCardConfig(taskCodeConfigMap.get(o.getTmActivityId()));
            });

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<Long, Object> getDataFieldMap(List<TaskCardDTO> list, AuthoredUser user, List<String> taskCodeList, List<TaskDefCodeData> groupRuleList, List<Map<String, Object>> labelRuleList, List<CardColumn> columnRuleList) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("km definition process time");
        Map<String, List<String>> activityDefinitionMap = themeMapService.getActivityDefinitionList(list.stream()
                .map(TaskCardDTO::getTmActivityId)
                .filter(taskCodeList::contains).distinct().collect(Collectors.toList()));
        stopWatch.stop();
        log.info(" process time get km definition data :{}", stopWatch.prettyPrint());

        List<Map<String, Object>> dataList = new ArrayList<>();
        list.stream().filter(e -> taskCodeList.contains(e.getTmActivityId())).forEach(e -> {
            Map<String, Object> map = new HashMap<>();
            map.put("backlogId", e.getBacklogId());
            map.put("keys", activityDefinitionMap.get(e.getTmActivityId()));
            dataList.add(map);
        });
        Map<Long, Object> dataFieldMap = new HashMap<>();
        try {
            futureAssembly(dataList, dataFieldMap, user, taskCodeList, groupRuleList, labelRuleList, columnRuleList);
            return dataFieldMap;
        } catch (Exception e) {
            log.error(" futureAssembly error:{}", e.getMessage());
            return dataFieldMap;
        } finally {

        }
    }

    /**
     * 判断Label结构下defaultEffective是否为false
     *
     * @param config
     * @return
     */
    private boolean isDefaultEffectiveFalse(CardConfigDTO.Config config) {
        return config.getLabel() != null &&
                config.getLabel().getDefaultEffective().equals("false");
    }

    /**
     * 判断config结构下属性是否都是空
     *
     * @param config
     * @return
     */
    private boolean configIsEmpty(CardConfigDTO.Config config) {
        return config.getLabel() == null &&
                config.getColumn() == null &&
                config.getFilter() == null &&
                config.getGroup() == null &&
                config.getOrder() == null;
    }

    private void adaptCardConfig(Map<String, List<CardColumn>> map, Map<Long, Object> dataFieldMap, TaskCardDTO e) {
        Map<String, Object> dataField = (Map<String, Object>) dataFieldMap.get(e.getBacklogId());
        List<Map<String, Object>> label = (List<Map<String, Object>>) dataField.get("label");
        Map<String, Object> group = (Map<String, Object>) dataField.get("group");
        List<Map<String, Object>> columns = (List<Map<String, Object>>) dataField.get("columns");
        Map<String, CardConfigDTO.Config.Label> labelMap = new HashMap<>();
        Map<String, Set<Object>> businessMessage = new HashMap<>();
        if (label != null) {
            label.forEach(o -> {
                Object code = o.get("code");
                Object value = o.get("value");
                Set<Object> objects = new HashSet<>();
                objects.add(value);
                businessMessage.put(String.valueOf(code), objects);
            });

            labelMap.putAll(label.stream().collect(Collectors.toMap(o -> String.valueOf(o.get("code")), o -> {
                CardConfigDTO.Config.Label label1 = new CardConfigDTO.Config.Label();
                label1.setAliasName(String.valueOf(o.get("name")));
                label1.setDefaultEffective("true");
                label1.setStyle(JSONUtil.toBean(JSONUtil.toJsonStr(o.get("style")), CardConfigDTO.Config.Label.Style.class));
                return label1;
            }, (o1, o2) -> o1)));
        }
        Map<String, CardConfigDTO.Config.Column> columnMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(columns)) {
            for (Map<String, Object> column : columns) {
                for (Map.Entry<String, Object> entry : column.entrySet()) {
                    Set<Object> set = businessMessage.get(entry.getKey());
                    if (set == null) {
                        set = new HashSet<>();
                    }
                    if (entry.getValue() != null) {
                        set.add(entry.getValue());
                    }
                    businessMessage.put(entry.getKey(), set);
                }
            }
        }
        List<CardColumn> cardColumns = map.get(e.getTmActivityId());
        if (CollectionUtils.isNotEmpty(cardColumns)) {
            columnMap.putAll(cardColumns.stream().collect(Collectors.toMap(col -> col.getCode(), o -> {
                CardColumn cardColumn = JSONUtil.toBean(JSONUtil.toJsonStr(o), CardColumn.class);
                CardConfigDTO.Config.Column column = new CardConfigDTO.Config.Column();
                column.setValueType(cardColumn.getValueType());
                column.setAliasName(cardColumn.getName());
                column.setDefaultEffective("true");
                return column;
            }, (o1, o2) -> o1)));
        }

        List<CardConfigDTO> cardConfigDTOS = new ArrayList<>();
        if (group != null && !group.isEmpty()) {

            String code = String.valueOf(group.get("code"));
            String name = String.valueOf(group.get("name"));
            Object value = group.get("groupName");
            // if (code.contains("-")){
            //     String[] split = code.split("-");
            //     code = split[split.length-1];
            // }
            Set<Object> set = businessMessage.get(code);
            if (set == null) {
                set = new LinkedHashSet<>();
            }
            if (value != null) {
                set.add(String.valueOf(value));
            }
            businessMessage.put(String.valueOf(code), set);

            CardConfigDTO configDTO = new CardConfigDTO();
            configDTO.setAliasField(code);
            CardConfigDTO.Config config = new CardConfigDTO.Config();
            configDTO.setConfig(config);
            config.setColumn(columnMap.remove(code));
            config.setLabel(labelMap.remove(code));
            CardConfigDTO.Config.Data group1 = new CardConfigDTO.Config.Data();
            group1.setDefaultEffective("true");
            group1.setAliasName(name);
            config.setGroup(group1);
            cardConfigDTOS.add(configDTO);
        }
        if (label != null) {

            label.forEach(o -> {
                String code = String.valueOf(o.get("code"));
                String name = String.valueOf(o.get("name"));
                CardConfigDTO.Config.Column column = columnMap.remove(code);
                CardConfigDTO configDTO1 = new CardConfigDTO();
                configDTO1.setAliasField(code);
                CardConfigDTO.Config config1 = new CardConfigDTO.Config();
                configDTO1.setConfig(config1);
                config1.setLabel(labelMap.get(code));
                config1.setColumn(column);

                CardConfigDTO.Config.Data filter = new CardConfigDTO.Config.Data();
                filter.setDefaultEffective("true");
                filter.setAliasName(name);
                filter.setDataType("string");
                filter.setNormal(true);

                config1.setFilter(filter);
                CardConfigDTO.Config.Data order = new CardConfigDTO.Config.Data();
                order.setDefaultEffective("true");
                order.setAliasName(name);
                config1.setOrder(order);
                cardConfigDTOS.add(configDTO1);
            });
        }
        columnMap.forEach((k, v) -> {
            CardConfigDTO configDTO1 = new CardConfigDTO();
            configDTO1.setAliasField(k);
            CardConfigDTO.Config config1 = new CardConfigDTO.Config();
            configDTO1.setConfig(config1);
            config1.setColumn(v);
            cardConfigDTOS.add(configDTO1);
        });
        Map<String, List<String>> businessMessageStr = Maps.newHashMapWithExpectedSize(businessMessage.size());
        businessMessage.forEach((k, v) -> {
            if (CollectionUtils.isNotEmpty(v)) {
                businessMessageStr.put(k, v.stream().map(String::valueOf).collect(Collectors.toList()));
            }
        });
        e.setBusinessMessage(businessMessageStr);
        e.setCardConfig(cardConfigDTOS);
    }

    private List<CardConfigDTO> combine(List<TaskCardDTO> taskCardDTOList) {
        List<CardConfigDTO> configDTOS = taskCardDTOList.stream().filter(o -> CollectionUtils.isNotEmpty(o.getCardConfig()))
                .flatMap(o -> o.getCardConfig().stream()).collect(Collectors.toList());
        Map<String, CardConfigDTO> map = configDTOS.stream().collect(Collectors.toMap(o -> o.getAliasField(), o -> o, (o1, o2) -> {
            CardConfigDTO.Config config1 = o1.getConfig();
            CardConfigDTO.Config config2 = o2.getConfig();
            if (config1 == null) {
                o1.setConfig(config2);
            }
            if (config2 == null) {
                return o1;
            }
            config1 = o1.getConfig();
            if (config1 == null) {
                return o1;
            }
            if (config2.getLabel() != null) {
                CardConfigDTO.Config.Label label1 = config1.getLabel();
                if (label1 == null) {
                    config1.setLabel(config2.getLabel());
                }
            }
            if (config2.getGroup() != null) {
                CardConfigDTO.Config.Data group1 = config1.getGroup();
                if (group1 == null) {
                    config1.setGroup(config2.getGroup());
                }
            }
            if (config2.getColumn() != null) {
                CardConfigDTO.Config.Column column1 = config1.getColumn();
                if (column1 == null) {
                    config1.setColumn(config2.getColumn());
                }
            }
            if (config2.getFilter() != null) {
                CardConfigDTO.Config.Data filter1 = config1.getFilter();
                if (filter1 == null) {
                    config1.setFilter(config2.getFilter());
                }
            }
            if (config2.getOrder() != null) {
                CardConfigDTO.Config.Data order1 = config1.getOrder();
                if (order1 == null) {
                    config1.setOrder(config2.getOrder());
                }
            }
            return o1;
        }, LinkedHashMap::new));
        return new ArrayList<>(map.values());
    }

    private void futureAssembly(List<Map<String, Object>> listData, Map<Long, Object> dataFieldMap, AuthoredUser user
            , List<String> taskCodeList, List<TaskDefCodeData> groupRuleList, List<Map<String, Object>> labelRuleList, List<CardColumn> columnRuleList) {
        int size = JaProperty.getInteger(PARTITION_SIZE, 200);

        List<CompletableFuture<Void>> completableFutureList = new ArrayList<>(64);
        List<List<Map<String, Object>>> partition = Lists.partition(listData, size);
        AppAuthContext context = AppAuthContextHolder.getContext();
        partition.parallelStream().forEach(list -> {
            // 修复多线程获取上下文
            AppAuthContextHolder.setContext(context);
            Map<String, Object> editActions = backlogActionCreateService.getEditActions(user, list, false);
            Map<String, List<Map>> groupTasks = ((List<Map>) editActions.get("tasks"))
                    .stream()
                    .filter(el -> checkTaskCodeQueryOrNot(taskCodeList, el.get("tmActivityId").toString()))
                    .collect(Collectors.groupingBy(el -> el.get("tmTaskId") + "-" + el.get("tmActivityId")));
            List<CompletableFuture<Void>> tempFutures = groupTasks.entrySet().stream().map(entry -> CompletableFuture.runAsync(JaRunnable.get(() -> {
                processData(editActions.get("project"), entry.getValue(),
                        dataFieldMap, user, groupRuleList, labelRuleList, columnRuleList);
            }), taskExecutor)).collect(Collectors.toList());
            completableFutureList.addAll(tempFutures);
        });
        CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0])).join();
    }

    private Boolean checkTaskCodeQueryOrNot(List<String> taskCodes, String taskCode) {
        return taskCodes.contains(taskCode);
    }

    public void addDataFieldsV2(List<TaskCardDTO> list, AuthoredUser user, String pageCode) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("km rule v2 process time");
        cn.hutool.json.JSONObject param = new cn.hutool.json.JSONObject();
        param.putIfAbsent("pageCode", pageCode);
        Set<String> codes = new HashSet<>();
        if ("task-card".equals(pageCode)) {
            codes.addAll(list.stream().map(TaskCardDTO::getTmActivityId).collect(Collectors.toSet()));
        } else if ("project-card".equals(pageCode)) {
            codes.addAll(list.stream().map(TaskCardDTO::getTmTaskId).collect(Collectors.toSet()));
        } else {
            stopWatch.stop();
            return;
        }
        if (codes.isEmpty()){
            stopWatch.stop();
            return;
        }
        param.putIfAbsent("codes", codes);
        Map<String, Object> taskCardOptimizeRules = themeMapService.postCardConfigByType(param);
        stopWatch.stop();
        log.info(" process time v2 get km rule data :{}", stopWatch.prettyPrint());

        try {
            log.info("【cardConfig-data: {}】", taskCardOptimizeRules);
            Object orderRule = taskCardOptimizeRules.get("orderRule");
            cn.hutool.json.JSONArray orderRuleArray = JSONUtil.parseArray(orderRule);
            List<Map> orderRuleList = JSONUtil.toList(orderRuleArray, Map.class);
            Map<String,Object> orderMap = orderRuleList.stream()
                    .collect(Collectors.toMap(e1->e1.get("taskCode").toString(),a -> a,(k1,k2)->k1));
            list.forEach(e -> {
                if ("task-card".equals(pageCode)) {
                    if (taskCardOptimizeRules.get(e.getTmActivityId()) != null) {
                        Object o = taskCardOptimizeRules.get(e.getTmActivityId());
                        Map<String, List> config =  JSONUtil.toBean(JSONUtil.toJsonStr(o), new TypeReference<Map<String, List>>() {
                        },true);
                        if (config != null) {
                            e.setCardConfig(JSONUtil.toList(JSONUtil.parseArray(config.get("config")),CardConfigDTO.class) );
                        }
                    }
                    e.setOrder(generateOrder(e.getTmActivityId(),orderMap));
                    cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(JSONUtil.toJsonStr(taskCardOptimizeRules.get("businessMessageSourceMethodMap")));
                    e.setBusinessMessageSourceMethod(jsonObject.getStr(e.getTmActivityId()));
                } else if ("project-card".equals(pageCode)) {

                    if (taskCardOptimizeRules.get(e.getTmActivityId()) != null) {
                        Object o = taskCardOptimizeRules.get(e.getTmTaskId());
                        Map<String, List> config = JSONUtil.toBean(JSONUtil.toJsonStr(o), new TypeReference<Map<String, List>>() {
                        }, true);
                        if (config != null) {
                            e.setCardConfig(JSONUtil.toList(JSONUtil.parseArray(config.get("config")),CardConfigDTO.class) );
                        }
                    }
                    e.setOrder(generateOrder(e.getTmActivityId(),orderMap));
                    cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(JSONUtil.toJsonStr(taskCardOptimizeRules.get("businessMessageSourceMethodMap")));
                    e.setBusinessMessageSourceMethod(jsonObject.getStr(e.getTmTaskId()));
                }

            });

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
